/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.view.WindowInsetsCompat;
import com.braze.enums.inappmessage.TextAlign;
import com.braze.models.inappmessage.IInAppMessageWithImage;
import com.braze.support.BrazeLogger;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import com.braze.ui.inappmessage.views.IInAppMessageView;
import com.braze.ui.support.ViewUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B\u001b\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0016J \u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020$H\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u000eH\u0016J\u0010\u00105\u001a\u00020\"2\u0006\u00106\u001a\u000207H\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00069"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageBaseView;", "Landroid/widget/RelativeLayout;", "Lcom/braze/ui/inappmessage/views/IInAppMessageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "messageClickableView", "Landroid/view/View;", "getMessageClickableView", "()Landroid/view/View;", "hasAppliedWindowInsets", "", "getHasAppliedWindowInsets", "()Z", "setHasAppliedWindowInsets", "(Z)V", "messageTextView", "Landroid/widget/TextView;", "getMessageTextView", "()Landroid/widget/TextView;", "messageImageView", "Landroid/widget/ImageView;", "getMessageImageView", "()Landroid/widget/ImageView;", "messageIconView", "getMessageIconView", "messageBackgroundObject", "", "getMessageBackgroundObject", "()Ljava/lang/Object;", "setMessageBackgroundColor", "", "color", "", "setMessageTextColor", "setMessageTextAlign", "textAlign", "Lcom/braze/enums/inappmessage/TextAlign;", "setMessage", "text", "", "setMessageImageView", "bitmap", "Landroid/graphics/Bitmap;", "setMessageIcon", "icon", "iconColor", "iconBackgroundColor", "resetMessageMargins", "imageRetrievalSuccessful", "applyWindowInsets", "insets", "Landroidx/core/view/WindowInsetsCompat;", "Companion", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nInAppMessageBaseView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppMessageBaseView.kt\ncom/braze/ui/inappmessage/views/InAppMessageBaseView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public abstract class InAppMessageBaseView
extends RelativeLayout
implements IInAppMessageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasAppliedWindowInsets;

    public InAppMessageBaseView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @Nullable
    public View getMessageClickableView() {
        return (View)this;
    }

    @Override
    public boolean getHasAppliedWindowInsets() {
        return this.hasAppliedWindowInsets;
    }

    @Override
    public void setHasAppliedWindowInsets(boolean bl) {
        this.hasAppliedWindowInsets = bl;
    }

    @Nullable
    public abstract TextView getMessageTextView();

    @Nullable
    public abstract ImageView getMessageImageView();

    @Nullable
    public abstract TextView getMessageIconView();

    @Nullable
    public abstract Object getMessageBackgroundObject();

    public void setMessageBackgroundColor(int color2) {
        Object object = this.getMessageBackgroundObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.View");
        InAppMessageViewUtils.setViewBackgroundColor((View)object, color2);
    }

    public void setMessageTextColor(int color2) {
        block0: {
            TextView textView = this.getMessageTextView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            InAppMessageViewUtils.setTextViewColor(it, color2);
        }
    }

    public void setMessageTextAlign(@NotNull TextAlign textAlign) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            TextView textView = this.getMessageTextView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            InAppMessageViewUtils.setTextAlignment(it, textAlign);
        }
    }

    public void setMessage(@NotNull String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            TextView textView = this.getMessageTextView();
            if (textView == null) break block0;
            textView.setText((CharSequence)text);
        }
    }

    public void setMessageImageView(@NotNull Bitmap bitmap) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            ImageView imageView = this.getMessageImageView();
            if (imageView == null) break block0;
            ImageView it = imageView;
            boolean bl = false;
            InAppMessageViewUtils.setImage(bitmap, it);
        }
    }

    public void setMessageIcon(@NotNull String icon, int iconColor, int iconBackgroundColor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            TextView textView = this.getMessageIconView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            InAppMessageViewUtils.setIcon(context, icon, iconColor, iconBackgroundColor, it);
        }
    }

    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        Object object;
        ImageView imageView = this.getMessageImageView();
        if (imageView != null) {
            ImageView it = imageView;
            boolean bl = false;
            if (!imageRetrievalSuccessful) {
                ViewUtils.removeViewFromParent((View)it);
            } else {
                ViewUtils.removeViewFromParent((View)this.getMessageIconView());
            }
        }
        boolean bl = (object = this.getMessageIconView()) != null && (object = object.getText()) != null && (object = object.toString()) != null ? StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
        if (bl) {
            ViewUtils.removeViewFromParent((View)this.getMessageIconView());
        }
    }

    @Override
    public void applyWindowInsets(@NotNull WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        this.setHasAppliedWindowInsets(true);
    }

    @JvmStatic
    @Nullable
    public static final String getAppropriateImageUrl(@NotNull IInAppMessageWithImage inAppMessage) {
        return Companion.getAppropriateImageUrl(inAppMessage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageBaseView$Companion;", "", "<init>", "()V", "getAppropriateImageUrl", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessageWithImage;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String getAppropriateImageUrl(@NotNull IInAppMessageWithImage inAppMessage) {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            String localImagePath = inAppMessage.getLocalImageUrl();
            CharSequence charSequence = localImagePath;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                File imageFile = new File(localImagePath);
                if (imageFile.exists()) {
                    return localImagePath;
                }
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, () -> Companion.getAppropriateImageUrl$lambda$0(localImagePath), (int)6, null);
            }
            return inAppMessage.getRemoteImageUrl();
        }

        private static final String getAppropriateImageUrl$lambda$0(String $localImagePath) {
            return "Local bitmap file does not exist. Using remote url instead. Local path: " + $localImagePath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

