/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.braze.enums.inappmessage.ImageStyle;
import com.braze.models.inappmessage.IInAppMessageImmersive;
import com.braze.models.inappmessage.InAppMessageModal;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.inappmessage.config.BrazeInAppMessageParams;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import com.braze.ui.inappmessage.views.IInAppMessageImageView;
import com.braze.ui.inappmessage.views.InAppMessageImageView;
import com.braze.ui.inappmessage.views.InAppMessageImmersiveBaseView;
import com.braze.ui.support.ViewUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0015042\u0006\u00105\u001a\u000202H\u0016J0\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020/2\u0006\u00108\u001a\u0002022\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u0002022\u0006\u0010;\u001a\u000202H\u0014J\u0018\u0010<\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010=\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020>2\u0006\u0010\b\u001a\u00020?H\u0014J\u001a\u0010@\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0016\u0010 \u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0016\u0010\"\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001bR\u0016\u0010$\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006A"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageModalView;", "Lcom/braze/ui/inappmessage/views/InAppMessageImmersiveBaseView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "inAppMessageImageView", "Lcom/braze/ui/inappmessage/views/InAppMessageImageView;", "getInAppMessageImageView", "()Lcom/braze/ui/inappmessage/views/InAppMessageImageView;", "setInAppMessageImageView", "(Lcom/braze/ui/inappmessage/views/InAppMessageImageView;)V", "inAppMessage", "Lcom/braze/models/inappmessage/InAppMessageModal;", "getInAppMessage", "()Lcom/braze/models/inappmessage/InAppMessageModal;", "setInAppMessage", "(Lcom/braze/models/inappmessage/InAppMessageModal;)V", "frameView", "Landroid/view/View;", "getFrameView", "()Landroid/view/View;", "messageTextView", "Landroid/widget/TextView;", "getMessageTextView", "()Landroid/widget/TextView;", "messageHeaderTextView", "getMessageHeaderTextView", "messageClickableView", "getMessageClickableView", "messageCloseButtonView", "getMessageCloseButtonView", "messageIconView", "getMessageIconView", "messageBackgroundObject", "Landroid/graphics/drawable/Drawable;", "getMessageBackgroundObject", "()Landroid/graphics/drawable/Drawable;", "messageImageView", "Landroid/widget/ImageView;", "getMessageImageView", "()Landroid/widget/ImageView;", "resetMessageMargins", "", "imageRetrievalSuccessful", "", "setMessageBackgroundColor", "color", "", "getMessageButtonViews", "", "numButtons", "onLayout", "changed", "left", "top", "right", "bottom", "applyInAppMessageParameters", "setInAppMessageImageViewAttributes", "Lcom/braze/models/inappmessage/IInAppMessageImmersive;", "Lcom/braze/ui/inappmessage/views/IInAppMessageImageView;", "resizeGraphicFrameIfAppropriate", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nInAppMessageModalView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppMessageModalView.kt\ncom/braze/ui/inappmessage/views/InAppMessageModalView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public class InAppMessageModalView
extends InAppMessageImmersiveBaseView {
    @Nullable
    private InAppMessageImageView inAppMessageImageView;
    @Nullable
    private InAppMessageModal inAppMessage;

    public InAppMessageModalView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Nullable
    protected final InAppMessageImageView getInAppMessageImageView() {
        return this.inAppMessageImageView;
    }

    protected final void setInAppMessageImageView(@Nullable InAppMessageImageView inAppMessageImageView) {
        this.inAppMessageImageView = inAppMessageImageView;
    }

    @Nullable
    protected final InAppMessageModal getInAppMessage() {
        return this.inAppMessage;
    }

    protected final void setInAppMessage(@Nullable InAppMessageModal inAppMessageModal) {
        this.inAppMessage = inAppMessageModal;
    }

    @Override
    @Nullable
    public View getFrameView() {
        return this.findViewById(R.id.com_braze_inappmessage_modal_frame);
    }

    @Override
    @Nullable
    public TextView getMessageTextView() {
        return (TextView)this.findViewById(R.id.com_braze_inappmessage_modal_message);
    }

    @Override
    @Nullable
    public TextView getMessageHeaderTextView() {
        return (TextView)this.findViewById(R.id.com_braze_inappmessage_modal_header_text);
    }

    @Override
    @Nullable
    public View getMessageClickableView() {
        return this.findViewById(R.id.com_braze_inappmessage_modal);
    }

    @Override
    @Nullable
    public View getMessageCloseButtonView() {
        return this.findViewById(R.id.com_braze_inappmessage_modal_close_button);
    }

    @Override
    @Nullable
    public TextView getMessageIconView() {
        return (TextView)this.findViewById(R.id.com_braze_inappmessage_modal_icon);
    }

    @Nullable
    public Drawable getMessageBackgroundObject() {
        View view = this.getMessageClickableView();
        return view != null ? view.getBackground() : null;
    }

    @Override
    @Nullable
    public ImageView getMessageImageView() {
        return this.inAppMessageImageView;
    }

    @Override
    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        block1: {
            View scrollViewChild;
            super.resetMessageMargins(imageRetrievalSuccessful);
            RelativeLayout imageLayout = (RelativeLayout)this.findViewById(R.id.com_braze_inappmessage_modal_image_layout);
            if ((imageRetrievalSuccessful || this.getMessageIconView() != null) && imageLayout != null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                layoutParams.setMargins(0, 0, 0, 0);
                imageLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            View view = scrollViewChild = this.findViewById(R.id.com_braze_inappmessage_modal_text_layout);
            if (view == null) break block1;
            view.setOnClickListener(arg_0 -> InAppMessageModalView.resetMessageMargins$lambda$1(this, arg_0));
        }
    }

    @Override
    public void setMessageBackgroundColor(int color2) {
        View view = this.findViewById(R.id.com_braze_inappmessage_modal);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        InAppMessageViewUtils.setViewBackgroundColorFilter(view, color2);
    }

    @Override
    @NotNull
    public List<View> getMessageButtonViews(int numButtons) {
        List buttonViews = new ArrayList();
        switch (numButtons) {
            case 1: {
                View singleButtonParent;
                View view = singleButtonParent = this.findViewById(R.id.com_braze_inappmessage_modal_button_layout_single);
                if (view != null) {
                    view.setVisibility(0);
                }
                View singleButton = this.findViewById(R.id.com_braze_inappmessage_modal_button_single_one);
                if (singleButton == null) break;
                buttonViews.add(singleButton);
                break;
            }
            case 2: {
                View dualButtonParent;
                View view = dualButtonParent = this.findViewById(R.id.com_braze_inappmessage_modal_button_layout_dual);
                if (view != null) {
                    view.setVisibility(0);
                }
                View dualButton1 = this.findViewById(R.id.com_braze_inappmessage_modal_button_dual_one);
                View dualButton2 = this.findViewById(R.id.com_braze_inappmessage_modal_button_dual_two);
                if (dualButton1 != null) {
                    buttonViews.add(dualButton1);
                }
                if (dualButton2 == null) break;
                buttonViews.add(dualButton2);
            }
        }
        return buttonViews;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.resizeGraphicFrameIfAppropriate(context, this.inAppMessage);
    }

    public void applyInAppMessageParameters(@NotNull Context context, @NotNull InAppMessageModal inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        this.inAppMessage = inAppMessage;
        InAppMessageImageView inAppMessageImageView = this.inAppMessageImageView = (InAppMessageImageView)this.findViewById(R.id.com_braze_inappmessage_modal_imageview);
        if (inAppMessageImageView != null) {
            InAppMessageImageView it = inAppMessageImageView;
            boolean bl = false;
            this.setInAppMessageImageViewAttributes(context, (IInAppMessageImmersive)inAppMessage, it);
        }
        this.resizeGraphicFrameIfAppropriate(context, inAppMessage);
    }

    protected void setInAppMessageImageViewAttributes(@NotNull Context context, @NotNull IInAppMessageImmersive inAppMessage, @NotNull IInAppMessageImageView inAppMessageImageView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)inAppMessageImageView, (String)"inAppMessageImageView");
        float pixelRadius = (float)ViewUtils.convertDpToPixels(context, BrazeInAppMessageParams.getModalizedImageRadiusDp());
        if (inAppMessage.getImageStyle() == ImageStyle.GRAPHIC) {
            inAppMessageImageView.setCornersRadiusPx(pixelRadius);
        } else {
            inAppMessageImageView.setCornersRadiiPx(pixelRadius, pixelRadius, 0.0f, 0.0f);
        }
        inAppMessageImageView.setInAppMessageImageCropType(inAppMessage.getCropType());
    }

    protected void resizeGraphicFrameIfAppropriate(@NotNull Context context, @Nullable InAppMessageModal inAppMessage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InAppMessageModal inAppMessageModal = inAppMessage;
        if (inAppMessageModal == null || (inAppMessageModal = inAppMessageModal.getBitmap()) == null) {
            return;
        }
        InAppMessageModal bitmap = inAppMessageModal;
        if (inAppMessage.getImageStyle() != ImageStyle.GRAPHIC) {
            return;
        }
        double imageAspectRatio = (double)bitmap.getWidth() / (double)bitmap.getHeight();
        Resources resources = context.getResources();
        int marginPixels = resources.getDimensionPixelSize(R.dimen.com_braze_inappmessage_modal_margin);
        int maxModalWidth = resources.getDimensionPixelSize(R.dimen.com_braze_inappmessage_modal_max_width);
        int maxModalHeight = resources.getDimensionPixelSize(R.dimen.com_braze_inappmessage_modal_max_height);
        this.post(() -> InAppMessageModalView.resizeGraphicFrameIfAppropriate$lambda$3(this, marginPixels, maxModalWidth, maxModalHeight, imageAspectRatio));
    }

    private static final String resetMessageMargins$lambda$1$lambda$0() {
        return "Passing scrollView click event to message clickable view.";
    }

    private static final void resetMessageMargins$lambda$1(InAppMessageModalView this$0, View it) {
        block0: {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (boolean)false, InAppMessageModalView::resetMessageMargins$lambda$1$lambda$0, (int)7, null);
            View view = this$0.getMessageClickableView();
            if (view == null) break block0;
            view.performClick();
        }
    }

    private static final void resizeGraphicFrameIfAppropriate$lambda$3(InAppMessageModalView this$0, int $marginPixels, int $maxModalWidth, int $maxModalHeight, double $imageAspectRatio) {
        double maxWidthPixelSize = Math.min(this$0.getMeasuredWidth() - $marginPixels, $maxModalWidth);
        double maxHeightPixelSize = Math.min(this$0.getMeasuredHeight() - $marginPixels, $maxModalHeight);
        double maxSizeAspectRatio = maxWidthPixelSize / maxHeightPixelSize;
        View modalBoundView = this$0.findViewById(R.id.com_braze_inappmessage_modal_graphic_bound);
        if (modalBoundView != null) {
            ViewGroup.LayoutParams layoutParams = modalBoundView.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)layoutParams;
            if ($imageAspectRatio >= maxSizeAspectRatio) {
                params.width = (int)maxWidthPixelSize;
                params.height = (int)(maxWidthPixelSize / $imageAspectRatio);
            } else {
                params.width = (int)(maxHeightPixelSize * $imageAspectRatio);
                params.height = (int)maxHeightPixelSize;
            }
            modalBoundView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }
}

