/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.push.BrazePushReceiver;
import com.braze.support.BrazeLogger;
import com.braze.support.ReflectionUtils;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.lang.reflect.Method;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/braze/push/BrazeFirebaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "<init>", "()V", "onNewToken", "", "newToken", "", "onMessageReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "Companion", "android-sdk-ui_release"})
public class BrazeFirebaseMessagingService
extends FirebaseMessagingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FCM_SERVICE_OMR_METHOD = "onMessageReceived";
    @NotNull
    private static final String CONTEXT_ATTACH_METHOD = "attachBaseContext";

    public void onNewToken(@NotNull String newToken) {
        Intrinsics.checkNotNullParameter((Object)newToken, (String)"newToken");
        super.onNewToken(newToken);
        BrazeInternal.applyPendingRuntimeConfiguration((Context)((Context)this));
        BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider((Context)this);
        CharSequence charSequence = Braze.Companion.getConfiguredApiKey(configurationProvider);
        if (charSequence == null || charSequence.length() == 0) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeFirebaseMessagingService.onNewToken$lambda$0(newToken), (int)6, null);
            return;
        }
        if (!configurationProvider.isFirebaseMessagingServiceOnNewTokenRegistrationEnabled()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeFirebaseMessagingService.onNewToken$lambda$1(newToken), (int)6, null);
            return;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeFirebaseMessagingService.onNewToken$lambda$2(newToken), (int)6, null);
        Braze.Companion.getInstance((Context)this).setRegisteredPushToken(newToken);
    }

    public void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        super.onMessageReceived(remoteMessage);
        Companion.handleBrazeRemoteMessage((Context)this, remoteMessage);
    }

    private static final String onNewToken$lambda$0(String $newToken) {
        return "No configured API key, not registering token in onNewToken. Token: " + $newToken;
    }

    private static final String onNewToken$lambda$1(String $newToken) {
        return "Automatic FirebaseMessagingService.OnNewToken() registration disabled, not registering token: " + $newToken;
    }

    private static final String onNewToken$lambda$2(String $newToken) {
        return "Registering Firebase push token in onNewToken. Token: " + $newToken;
    }

    @JvmStatic
    public static final boolean handleBrazeRemoteMessage(@NotNull Context context, @NotNull RemoteMessage remoteMessage) {
        return Companion.handleBrazeRemoteMessage(context, remoteMessage);
    }

    @JvmStatic
    public static final boolean isBrazePushNotification(@NotNull RemoteMessage remoteMessage) {
        return Companion.isBrazePushNotification(remoteMessage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/braze/push/BrazeFirebaseMessagingService$Companion;", "", "<init>", "()V", "FCM_SERVICE_OMR_METHOD", "", "CONTEXT_ATTACH_METHOD", "handleBrazeRemoteMessage", "", "context", "Landroid/content/Context;", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "isBrazePushNotification", "invokeFallbackFirebaseService", "", "classpath", "invokeFallbackFirebaseService$android_sdk_ui_release", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean handleBrazeRemoteMessage(@NotNull Context context, @NotNull RemoteMessage remoteMessage) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
            if (!this.isBrazePushNotification(remoteMessage)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handleBrazeRemoteMessage$lambda$0(remoteMessage), (int)6, null);
                BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
                if (configurationProvider.isFallbackFirebaseMessagingServiceEnabled()) {
                    String fallbackClassPath = configurationProvider.getFallbackFirebaseMessagingServiceClasspath();
                    if (fallbackClassPath != null) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handleBrazeRemoteMessage$lambda$1(fallbackClassPath), (int)6, null);
                        this.invokeFallbackFirebaseService$android_sdk_ui_release(fallbackClassPath, remoteMessage, context);
                    } else {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handleBrazeRemoteMessage$lambda$2, (int)7, null);
                    }
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handleBrazeRemoteMessage$lambda$3, (int)7, null);
                }
                return false;
            }
            Map map = remoteMessage.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
            Map remoteMessageData = map;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handleBrazeRemoteMessage$lambda$4(remoteMessageData), (int)6, null);
            Intent pushIntent = new Intent("firebase_messaging_service_routing_action");
            Bundle bundle = new Bundle();
            for (Map.Entry entry : remoteMessageData.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> Companion.handleBrazeRemoteMessage$lambda$5(key, value), (int)6, null);
                bundle.putString(key, value);
            }
            pushIntent.putExtras(bundle);
            BrazePushReceiver.Companion.handleReceivedIntent$default(BrazePushReceiver.Companion, context, pushIntent, false, 4, null);
            return true;
        }

        @JvmStatic
        public final boolean isBrazePushNotification(@NotNull RemoteMessage remoteMessage) {
            Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
            Map map = remoteMessage.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
            Map remoteMessageData = map;
            return Intrinsics.areEqual((Object)"true", remoteMessageData.get("_ab"));
        }

        public final void invokeFallbackFirebaseService$android_sdk_ui_release(@NotNull String classpath, @NotNull RemoteMessage remoteMessage, @NotNull Context context) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
            Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object fallbackObject = ReflectionUtils.constructObjectQuietly$default((ReflectionUtils)ReflectionUtils.INSTANCE, (String)classpath, null, null, (int)6, null);
            if (fallbackObject == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.invokeFallbackFirebaseService$lambda$6(classpath), (int)7, null);
                return;
            }
            Class[] classArray = new Class[]{Context.class};
            Method attachMethod = ReflectionUtils.INSTANCE.getDeclaredMethodQuietly(classpath, BrazeFirebaseMessagingService.CONTEXT_ATTACH_METHOD, classArray);
            if (attachMethod != null) {
                attachMethod.setAccessible(true);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.invokeFallbackFirebaseService$lambda$7(classpath), (int)7, null);
                objectArray = new Object[]{context};
                Pair invokeReturn = ReflectionUtils.invokeMethodQuietly((Object)fallbackObject, (Method)attachMethod, (Object[])objectArray);
                if (!((Boolean)invokeReturn.getFirst()).booleanValue()) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.invokeFallbackFirebaseService$lambda$8(classpath), (int)7, null);
                    return;
                }
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::invokeFallbackFirebaseService$lambda$9, (int)7, null);
                return;
            }
            objectArray = new Class[]{RemoteMessage.class};
            Method method = ReflectionUtils.getMethodQuietly((String)classpath, (String)BrazeFirebaseMessagingService.FCM_SERVICE_OMR_METHOD, (Class[])objectArray);
            if (method == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.invokeFallbackFirebaseService$lambda$10(classpath), (int)7, null);
                return;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.invokeFallbackFirebaseService$lambda$11(classpath), (int)7, null);
            Object[] objectArray2 = new Object[]{remoteMessage};
            Pair omrReturn = ReflectionUtils.invokeMethodQuietly((Object)fallbackObject, (Method)method, (Object[])objectArray2);
            if (!((Boolean)omrReturn.getFirst()).booleanValue()) {
                String cfr_ignored_0 = "Failure invoking " + classpath + ".onMessageReceived.";
            }
        }

        private static final String handleBrazeRemoteMessage$lambda$0(RemoteMessage $remoteMessage) {
            return "Remote message did not originate from Braze. Not consuming remote message: " + $remoteMessage;
        }

        private static final String handleBrazeRemoteMessage$lambda$1(String $fallbackClassPath) {
            return "Fallback FCM service enabled. Attempting to use fallback class at " + $fallbackClassPath;
        }

        private static final String handleBrazeRemoteMessage$lambda$2() {
            return "Fallback FCM service enabled but classpath is null. Not routing to any fallback service.";
        }

        private static final String handleBrazeRemoteMessage$lambda$3() {
            return "FallbackFirebaseMessagingService is not enabled";
        }

        private static final String handleBrazeRemoteMessage$lambda$4(Map $remoteMessageData) {
            return "Got remote message from FCM: " + $remoteMessageData;
        }

        private static final String handleBrazeRemoteMessage$lambda$5(String $key, String $value) {
            return "Adding bundle item from FCM remote data with key: " + $key + " and value: " + $value;
        }

        private static final String invokeFallbackFirebaseService$lambda$6(String $classpath) {
            return "Fallback firebase messaging service " + $classpath + " could not be constructed. Not routing fallback RemoteMessage.";
        }

        private static final String invokeFallbackFirebaseService$lambda$7(String $classpath) {
            return "Attempting to call " + $classpath + " attachBaseContext";
        }

        private static final String invokeFallbackFirebaseService$lambda$8(String $classpath) {
            return "Failure invoking " + $classpath + ".attachBaseContext. Not doing anything.";
        }

        private static final String invokeFallbackFirebaseService$lambda$9() {
            return "Could not find attachBaseContext. Not doing anything.";
        }

        private static final String invokeFallbackFirebaseService$lambda$10(String $classpath) {
            return "Fallback firebase messaging service method " + $classpath + ".onMessageReceived could not be retrieved. Not routing fallback RemoteMessage.";
        }

        private static final String invokeFallbackFirebaseService$lambda$11(String $classpath) {
            return "Attempting to invoke firebase messaging fallback service " + $classpath + ".onMessageReceived";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

