/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.app.Notification;
import android.content.Context;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.braze.IBrazeNotificationFactory;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.models.push.BrazeNotificationPayload;
import com.braze.push.BrazeNotificationActionUtils;
import com.braze.push.BrazeNotificationStyleFactory;
import com.braze.push.BrazeNotificationUtils;
import com.braze.support.BrazeLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ0\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a8\u0006\u0013"}, d2={"Lcom/braze/push/BrazeNotificationFactory;", "Lcom/braze/IBrazeNotificationFactory;", "<init>", "()V", "createNotification", "Landroid/app/Notification;", "payload", "Lcom/braze/models/push/BrazeNotificationPayload;", "appConfigurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "context", "Landroid/content/Context;", "notificationExtras", "Landroid/os/Bundle;", "brazeExtras", "populateNotificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "configurationProvider", "Companion", "android-sdk-ui_release"})
public class BrazeNotificationFactory
implements IBrazeNotificationFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BrazeNotificationFactory internalInstance = new BrazeNotificationFactory();

    @Nullable
    public Notification createNotification(@NotNull BrazeNotificationPayload payload) {
        Notification notification;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        NotificationCompat.Builder builder = Companion.populateNotificationBuilder(payload);
        if (builder != null) {
            notification = builder.build();
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeNotificationFactory::createNotification$lambda$0, (int)6, null);
            notification = null;
        }
        return notification;
    }

    @Nullable
    public final Notification createNotification(@Nullable BrazeConfigurationProvider appConfigurationProvider, @Nullable Context context, @Nullable Bundle notificationExtras, @Nullable Bundle brazeExtras) {
        BrazeNotificationPayload payload = new BrazeNotificationPayload(notificationExtras, brazeExtras, context, appConfigurationProvider);
        return this.createNotification(payload);
    }

    @Nullable
    public final NotificationCompat.Builder populateNotificationBuilder(@Nullable BrazeConfigurationProvider configurationProvider, @Nullable Context context, @Nullable Bundle notificationExtras, @Nullable Bundle brazeExtras) {
        BrazeNotificationPayload payload = new BrazeNotificationPayload(notificationExtras, brazeExtras, context, configurationProvider);
        return Companion.populateNotificationBuilder(payload);
    }

    private static final String createNotification$lambda$0() {
        return "Notification could not be built. Returning null as created notification";
    }

    @NotNull
    public static final BrazeNotificationFactory getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final NotificationCompat.Builder populateNotificationBuilder(@NotNull BrazeNotificationPayload payload) {
        return Companion.populateNotificationBuilder(payload);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/braze/push/BrazeNotificationFactory$Companion;", "", "<init>", "()V", "internalInstance", "Lcom/braze/push/BrazeNotificationFactory;", "instance", "getInstance$annotations", "getInstance", "()Lcom/braze/push/BrazeNotificationFactory;", "populateNotificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "payload", "Lcom/braze/models/push/BrazeNotificationPayload;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BrazeNotificationFactory getInstance() {
            return internalInstance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        @Nullable
        public final NotificationCompat.Builder populateNotificationBuilder(@NotNull BrazeNotificationPayload payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> Companion.populateNotificationBuilder$lambda$0(payload), (int)6, null);
            Context context = payload.getContext();
            if (context == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::populateNotificationBuilder$lambda$1, (int)7, null);
                return null;
            }
            BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
            if (brazeConfigurationProvider == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::populateNotificationBuilder$lambda$2, (int)7, null);
                return null;
            }
            Bundle notificationExtras = payload.getNotificationExtras();
            BrazeNotificationUtils.prefetchBitmapsIfNewlyReceivedStoryPush(payload);
            String notificationChannelId = BrazeNotificationUtils.getOrCreateNotificationChannelId(payload);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, notificationChannelId).setAutoCancel(true);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setAutoCancel(...)");
            NotificationCompat.Builder notificationBuilder = builder;
            BrazeNotificationUtils.setTitleIfPresent(notificationBuilder, payload);
            BrazeNotificationUtils.setContentIfPresent(notificationBuilder, payload);
            BrazeNotificationUtils.setTickerIfPresent(notificationBuilder, payload);
            BrazeNotificationUtils.setSetShowWhen(notificationBuilder, payload);
            BrazeNotificationUtils.setContentIntentIfPresent(context, notificationBuilder, notificationExtras);
            BrazeNotificationUtils.setDeleteIntent(context, notificationBuilder, notificationExtras);
            BrazeNotificationUtils.setSmallIcon(brazeConfigurationProvider, notificationBuilder);
            BrazeNotificationUtils.setLargeIconIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setSoundIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setSummaryTextIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setPriorityIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationStyleFactory.Companion.setStyleIfSupported(notificationBuilder, payload);
            BrazeNotificationActionUtils.addNotificationActions(notificationBuilder, payload);
            BrazeNotificationUtils.setAccentColorIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setCategoryIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setVisibilityIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setPublicVersionIfPresentAndSupported(notificationBuilder, payload);
            BrazeNotificationUtils.setNotificationBadgeNumberIfPresent(notificationBuilder, payload);
            return notificationBuilder;
        }

        private static final String populateNotificationBuilder$lambda$0(BrazeNotificationPayload $payload) {
            return "Using BrazeNotificationPayload: " + $payload;
        }

        private static final String populateNotificationBuilder$lambda$1() {
            return "BrazeNotificationPayload has null context. Not creating notification";
        }

        private static final String populateNotificationBuilder$lambda$2() {
            return "BrazeNotificationPayload has null app configuration provider. Not creating notification";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

