/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Bundle;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.IBrazeDeeplinkHandler;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.BrazeDateFormat;
import com.braze.enums.BrazeViewBounds;
import com.braze.models.push.BrazeNotificationPayload;
import com.braze.push.BrazeNotificationUtils;
import com.braze.push.NotificationTrampolineActivity;
import com.braze.push.support.HtmlUtils;
import com.braze.support.BrazeImageUtils;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.support.IntentUtils;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.R;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/braze/push/BrazeNotificationStyleFactory;", "", "<init>", "()V", "NoOpSentinelStyle", "Companion", "android-sdk-ui_release"})
public class BrazeNotificationStyleFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int BIG_PICTURE_STYLE_IMAGE_HEIGHT = 192;
    @NotNull
    private static final String STORY_SET_GRAVITY = "setGravity";
    @NotNull
    private static final String STORY_SET_VISIBILITY = "setVisibility";

    @JvmStatic
    public static final void setStyleIfSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Companion.setStyleIfSupported(notificationBuilder, payload);
    }

    @JvmStatic
    @VisibleForTesting
    public static final void setBigPictureSummaryAndTitle(@NotNull NotificationCompat.BigPictureStyle bigPictureNotificationStyle, @NotNull BrazeNotificationPayload payload) {
        Companion.setBigPictureSummaryAndTitle(bigPictureNotificationStyle, payload);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010*\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/braze/push/BrazeNotificationStyleFactory$Companion;", "", "<init>", "()V", "BIG_PICTURE_STYLE_IMAGE_HEIGHT", "", "STORY_SET_GRAVITY", "", "STORY_SET_VISIBILITY", "setStyleIfSupported", "", "notificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "payload", "Lcom/braze/models/push/BrazeNotificationPayload;", "getNotificationStyle", "Landroidx/core/app/NotificationCompat$Style;", "getBigTextNotificationStyle", "Landroidx/core/app/NotificationCompat$BigTextStyle;", "getStoryStyle", "Landroidx/core/app/NotificationCompat$DecoratedCustomViewStyle;", "getInlineImageStyle", "getBigPictureNotificationStyle", "Landroidx/core/app/NotificationCompat$BigPictureStyle;", "getConversationalPushStyle", "Landroidx/core/app/NotificationCompat$MessagingStyle;", "createStoryPageClickedPendingIntent", "Landroid/app/PendingIntent;", "context", "Landroid/content/Context;", "pushStoryPage", "Lcom/braze/models/push/BrazeNotificationPayload$PushStoryPage;", "createStoryTraversedPendingIntent", "notificationExtras", "Landroid/os/Bundle;", "pageIndex", "populatePushStoryPage", "", "view", "Landroid/widget/RemoteViews;", "setBigPictureSummaryAndTitle", "bigPictureNotificationStyle", "isRemoteViewNotificationAvailableSpaceConstrained", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setStyleIfSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
            Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            NotificationCompat.Style style = this.getNotificationStyle(notificationBuilder, payload);
            if (!(style instanceof NoOpSentinelStyle)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::setStyleIfSupported$lambda$0, (int)7, null);
                notificationBuilder.setStyle(style);
            }
        }

        @NotNull
        public final NotificationCompat.Style getNotificationStyle(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
            Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            NotificationCompat.Style style = null;
            if (payload.isPushStory() && payload.getContext() != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getNotificationStyle$lambda$1, (int)7, null);
                style = (NotificationCompat.Style)this.getStoryStyle(notificationBuilder, payload);
            } else if (payload.isConversationalPush() && Build.VERSION.SDK_INT >= 25) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getNotificationStyle$lambda$2, (int)7, null);
                style = (NotificationCompat.Style)this.getConversationalPushStyle(notificationBuilder, payload);
            } else if (payload.getBigImageUrl() != null) {
                NotificationCompat.Style style2;
                if (Build.VERSION.SDK_INT >= 23 && payload.isInlineImagePush()) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getNotificationStyle$lambda$3, (int)7, null);
                    style2 = this.getInlineImageStyle(payload, notificationBuilder);
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getNotificationStyle$lambda$4, (int)7, null);
                    style2 = style = (NotificationCompat.Style)this.getBigPictureNotificationStyle(payload);
                }
            }
            if (style == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getNotificationStyle$lambda$5, (int)7, null);
                style = (NotificationCompat.Style)this.getBigTextNotificationStyle(payload);
            }
            return style;
        }

        @NotNull
        public final NotificationCompat.BigTextStyle getBigTextNotificationStyle(@NotNull BrazeNotificationPayload payload) {
            NotificationCompat.BigTextStyle bigTextNotificationStyle;
            block3: {
                String it;
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                bigTextNotificationStyle = new NotificationCompat.BigTextStyle();
                BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
                if (brazeConfigurationProvider == null) {
                    return bigTextNotificationStyle;
                }
                BrazeConfigurationProvider appConfigProvider = brazeConfigurationProvider;
                CharSequence charSequence = payload.getContentText();
                if (charSequence != null && (charSequence = HtmlUtils.getHtmlSpannedTextIfEnabled(charSequence, appConfigProvider)) != null) {
                    CharSequence it2 = charSequence;
                    boolean bl = false;
                    bigTextNotificationStyle.bigText(it2);
                }
                String string = payload.getBigSummaryText();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    bigTextNotificationStyle.setSummaryText(HtmlUtils.getHtmlSpannedTextIfEnabled(it, appConfigProvider));
                }
                String string2 = payload.getBigTitleText();
                if (string2 == null) break block3;
                it = string2;
                boolean bl = false;
                bigTextNotificationStyle.setBigContentTitle(HtmlUtils.getHtmlSpannedTextIfEnabled(it, appConfigProvider));
            }
            return bigTextNotificationStyle;
        }

        @Nullable
        public final NotificationCompat.DecoratedCustomViewStyle getStoryStyle(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
            Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Context context = payload.getContext();
            if (context == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getStoryStyle$lambda$9, (int)7, null);
                return null;
            }
            List pushStoryPages = payload.getPushStoryPages();
            int pageIndex = payload.getPushStoryPageIndex();
            BrazeNotificationPayload.PushStoryPage pushStoryPage = (BrazeNotificationPayload.PushStoryPage)pushStoryPages.get(pageIndex);
            RemoteViews storyView = new RemoteViews(context.getPackageName(), R.layout.com_braze_push_story_one_image);
            if (!this.populatePushStoryPage(storyView, payload, pushStoryPage)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, Companion::getStoryStyle$lambda$10, (int)6, null);
                return null;
            }
            Bundle notificationExtras = payload.getNotificationExtras();
            NotificationCompat.DecoratedCustomViewStyle style = new NotificationCompat.DecoratedCustomViewStyle();
            int numPages = pushStoryPages.size();
            PendingIntent previousButtonPendingIntent = this.createStoryTraversedPendingIntent(context, notificationExtras, (pageIndex - 1 + numPages) % numPages);
            storyView.setOnClickPendingIntent(R.id.com_braze_story_button_previous, previousButtonPendingIntent);
            PendingIntent nextButtonPendingIntent = this.createStoryTraversedPendingIntent(context, notificationExtras, (pageIndex + 1) % numPages);
            storyView.setOnClickPendingIntent(R.id.com_braze_story_button_next, nextButtonPendingIntent);
            notificationBuilder.setCustomBigContentView(storyView);
            notificationBuilder.setOnlyAlertOnce(true);
            return style;
        }

        @RequiresApi(api=23)
        @Nullable
        public final NotificationCompat.Style getInlineImageStyle(@NotNull BrazeNotificationPayload payload, @NotNull NotificationCompat.Builder notificationBuilder) {
            NotificationCompat.Style style;
            ApplicationInfo color2;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
            Context context = payload.getContext();
            if (context == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getInlineImageStyle$lambda$11, (int)7, null);
                return null;
            }
            String imageUrl = payload.getBigImageUrl();
            CharSequence charSequence = imageUrl;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getInlineImageStyle$lambda$12, (int)7, null);
                return null;
            }
            Bundle notificationExtras = payload.getNotificationExtras();
            Bitmap largeNotificationBitmap = Braze.Companion.getInstance(context).getImageLoader().getPushBitmapFromUrl(context, notificationExtras, imageUrl, BrazeViewBounds.NOTIFICATION_INLINE_PUSH_IMAGE);
            if (largeNotificationBitmap == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getInlineImageStyle$lambda$13, (int)7, null);
                return null;
            }
            boolean isNotificationSpaceConstrained = this.isRemoteViewNotificationAvailableSpaceConstrained(context);
            RemoteViews remoteView = new RemoteViews(context.getPackageName(), isNotificationSpaceConstrained ? R.layout.com_braze_push_inline_image_constrained : R.layout.com_braze_notification_inline_image);
            BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
            Icon icon = Icon.createWithResource((Context)context, (int)configurationProvider.getSmallNotificationIconResourceId());
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"createWithResource(...)");
            Icon appIcon = icon;
            Integer n = payload.getAccentColor();
            if (n != null) {
                int color2 = ((Number)n).intValue();
                boolean bl = false;
                appIcon.setTint(color2);
            }
            remoteView.setImageViewIcon(R.id.com_braze_inline_image_push_app_icon, appIcon);
            PackageManager packageManager = context.getPackageManager();
            try {
                color2 = Build.VERSION.SDK_INT >= 33 ? packageManager.getApplicationInfo(context.getPackageName(), PackageManager.ApplicationInfoFlags.of((long)0L)) : packageManager.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, Companion::getInlineImageStyle$lambda$15, (int)4, null);
                return null;
            }
            ApplicationInfo applicationInfo = color2;
            CharSequence charSequence2 = packageManager.getApplicationLabel(applicationInfo);
            Intrinsics.checkNotNull((Object)charSequence2, (String)"null cannot be cast to non-null type kotlin.String");
            String applicationName = (String)charSequence2;
            CharSequence htmlSpannedAppName = HtmlUtils.getHtmlSpannedTextIfEnabled(applicationName, configurationProvider);
            remoteView.setTextViewText(R.id.com_braze_inline_image_push_app_name_text, htmlSpannedAppName);
            remoteView.setTextViewText(R.id.com_braze_inline_image_push_time_text, (CharSequence)DateTimeUtils.formatDateNow((BrazeDateFormat)BrazeDateFormat.CLOCK_12_HOUR));
            String string = notificationExtras.getString("t");
            if (string != null) {
                String title = string;
                boolean bl = false;
                remoteView.setTextViewText(R.id.com_braze_inline_image_push_title_text, HtmlUtils.getHtmlSpannedTextIfEnabled(title, configurationProvider));
            }
            String string2 = notificationExtras.getString("a");
            if (string2 != null) {
                String content = string2;
                boolean bl = false;
                remoteView.setTextViewText(R.id.com_braze_inline_image_push_content_text, HtmlUtils.getHtmlSpannedTextIfEnabled(content, configurationProvider));
            }
            notificationBuilder.setCustomContentView(remoteView);
            if (isNotificationSpaceConstrained) {
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                style = (NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle();
            } else {
                remoteView.setImageViewBitmap(R.id.com_braze_inline_image_push_side_image, largeNotificationBitmap);
                style = new NoOpSentinelStyle();
            }
            return style;
        }

        @Nullable
        public final NotificationCompat.BigPictureStyle getBigPictureNotificationStyle(@NotNull BrazeNotificationPayload payload) {
            NotificationCompat.BigPictureStyle bigPictureStyle;
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Context context = payload.getContext();
            if (context == null) {
                return null;
            }
            Context context2 = context;
            String imageUrl = payload.getBigImageUrl();
            CharSequence charSequence = imageUrl;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            Bundle notificationExtras = payload.getNotificationExtras();
            Bitmap imageBitmap = Braze.Companion.getInstance(context2).getImageLoader().getPushBitmapFromUrl(context2, notificationExtras, imageUrl, BrazeViewBounds.NOTIFICATION_EXPANDED_IMAGE);
            if (imageBitmap == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.getBigPictureNotificationStyle$lambda$18(imageUrl), (int)7, null);
                return null;
            }
            try {
                if (imageBitmap.getWidth() > imageBitmap.getHeight()) {
                    int displayWidthPixels;
                    int bigPictureHeightPixels = BrazeImageUtils.getPixelsFromDensityAndDp((int)BrazeImageUtils.getDensityDpi((Context)context2), (int)192);
                    int bigPictureWidthPixels = 2 * bigPictureHeightPixels;
                    if (bigPictureWidthPixels > (displayWidthPixels = BrazeImageUtils.getDisplayWidthPixels((Context)context2))) {
                        bigPictureWidthPixels = displayWidthPixels;
                    }
                    try {
                        imageBitmap = Bitmap.createScaledBitmap((Bitmap)imageBitmap, (int)bigPictureWidthPixels, (int)bigPictureHeightPixels, (boolean)true);
                    }
                    catch (Exception e) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, Companion::getBigPictureNotificationStyle$lambda$19, (int)4, null);
                    }
                }
                NotificationCompat.BigPictureStyle bigPictureNotificationStyle = new NotificationCompat.BigPictureStyle();
                bigPictureNotificationStyle.bigPicture(imageBitmap);
                this.setBigPictureSummaryAndTitle(bigPictureNotificationStyle, payload);
                bigPictureStyle = bigPictureNotificationStyle;
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, Companion::getBigPictureNotificationStyle$lambda$20, (int)4, null);
                bigPictureStyle = null;
            }
            return bigPictureStyle;
        }

        @Nullable
        public final NotificationCompat.MessagingStyle getConversationalPushStyle(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
            NotificationCompat.MessagingStyle messagingStyle;
            Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            try {
                Map conversationPersonMap = payload.getConversationPersonMap();
                BrazeNotificationPayload.ConversationPerson replyPerson = (BrazeNotificationPayload.ConversationPerson)conversationPersonMap.get(payload.getConversationReplyPersonId());
                if (replyPerson == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::getConversationalPushStyle$lambda$21, (int)7, null);
                    return null;
                }
                NotificationCompat.MessagingStyle style = new NotificationCompat.MessagingStyle(replyPerson.getPerson());
                for (BrazeNotificationPayload.ConversationMessage message : payload.getConversationMessages()) {
                    BrazeNotificationPayload.ConversationPerson person = (BrazeNotificationPayload.ConversationPerson)conversationPersonMap.get(message.getPersonId());
                    if (person == null) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.getConversationalPushStyle$lambda$22(message), (int)7, null);
                        return null;
                    }
                    style.addMessage((CharSequence)message.getMessage(), message.getTimestamp(), person.getPerson());
                }
                style.setGroupConversation(conversationPersonMap.size() > 1);
                notificationBuilder.setShortcutId(payload.getConversationShortcutId());
                messagingStyle = style;
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, Companion::getConversationalPushStyle$lambda$23, (int)4, null);
                messagingStyle = null;
            }
            return messagingStyle;
        }

        private final PendingIntent createStoryPageClickedPendingIntent(Context context, BrazeNotificationPayload payload, BrazeNotificationPayload.PushStoryPage pushStoryPage) {
            Intent intent = new Intent("com.braze.action.BRAZE_STORY_CLICKED").setClass(context, NotificationTrampolineActivity.class);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setClass(...)");
            Intent storyClickedIntent = intent;
            storyClickedIntent.setFlags(storyClickedIntent.getFlags() | BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.NOTIFICATION_PUSH_STORY_PAGE_CLICK));
            Bundle it = payload.getNotificationExtras();
            boolean bl = false;
            storyClickedIntent.putExtras(it);
            storyClickedIntent.putExtra("braze_action_uri", pushStoryPage.getDeeplink());
            storyClickedIntent.putExtra("braze_action_use_webview", pushStoryPage.getUseWebview());
            storyClickedIntent.putExtra("braze_story_page_id", pushStoryPage.getStoryPageId());
            storyClickedIntent.putExtra("braze_campaign_id", pushStoryPage.getCampaignId());
            int notificationId = BrazeNotificationUtils.getNotificationId(payload);
            storyClickedIntent.putExtra("nid", notificationId);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)IntentUtils.getRequestCode(), (Intent)storyClickedIntent, (int)IntentUtils.getImmutablePendingIntentFlags());
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getActivity(...)");
            return pendingIntent;
        }

        private final PendingIntent createStoryTraversedPendingIntent(Context context, Bundle notificationExtras, int pageIndex) {
            Intent intent = new Intent("com.braze.action.STORY_TRAVERSE").setClass(context, BrazeNotificationUtils.getNotificationReceiverClass());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setClass(...)");
            Intent storyNextClickedIntent = intent;
            if (notificationExtras != null) {
                notificationExtras.putInt("braze_story_index", pageIndex);
                storyNextClickedIntent.putExtras(notificationExtras);
            }
            int flags = 0x40000000 | IntentUtils.getImmutablePendingIntentFlags();
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)storyNextClickedIntent, (int)flags);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(...)");
            return pendingIntent;
        }

        private final boolean populatePushStoryPage(RemoteViews view, BrazeNotificationPayload payload, BrazeNotificationPayload.PushStoryPage pushStoryPage) {
            Context context = payload.getContext();
            if (context == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::populatePushStoryPage$lambda$25, (int)7, null);
                return false;
            }
            BrazeConfigurationProvider configurationProvider = payload.getConfigurationProvider();
            if (configurationProvider == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::populatePushStoryPage$lambda$26, (int)7, null);
                return false;
            }
            String bitmapUrl = pushStoryPage.getBitmapUrl();
            CharSequence charSequence = bitmapUrl;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::populatePushStoryPage$lambda$27, (int)7, null);
                return false;
            }
            Bundle notificationExtras = payload.getNotificationExtras();
            Bitmap bitmap = Braze.Companion.getInstance(context).getImageLoader().getPushBitmapFromUrl(context, notificationExtras, bitmapUrl, BrazeViewBounds.NOTIFICATION_ONE_IMAGE_STORY);
            if (bitmap == null) {
                return false;
            }
            Bitmap largeNotificationBitmap = bitmap;
            view.setImageViewBitmap(R.id.com_braze_story_image_view, largeNotificationBitmap);
            String pageTitle = pushStoryPage.getTitle();
            CharSequence charSequence2 = pageTitle;
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                CharSequence pageTitleText = HtmlUtils.getHtmlSpannedTextIfEnabled(pageTitle, configurationProvider);
                view.setTextViewText(R.id.com_braze_story_text_view, pageTitleText);
                int titleGravity = pushStoryPage.getTitleGravity();
                view.setInt(R.id.com_braze_story_text_view_container, BrazeNotificationStyleFactory.STORY_SET_GRAVITY, titleGravity);
            } else {
                view.setInt(R.id.com_braze_story_text_view_container, BrazeNotificationStyleFactory.STORY_SET_VISIBILITY, 8);
            }
            String pageSubtitle = pushStoryPage.getSubtitle();
            CharSequence titleGravity = pageSubtitle;
            if (!(titleGravity == null || StringsKt.isBlank((CharSequence)titleGravity))) {
                CharSequence pageSubtitleText = HtmlUtils.getHtmlSpannedTextIfEnabled(pageSubtitle, configurationProvider);
                view.setTextViewText(R.id.com_braze_story_text_view_small, pageSubtitleText);
                int subtitleGravity = pushStoryPage.getSubtitleGravity();
                view.setInt(R.id.com_braze_story_text_view_small_container, BrazeNotificationStyleFactory.STORY_SET_GRAVITY, subtitleGravity);
            } else {
                view.setInt(R.id.com_braze_story_text_view_small_container, BrazeNotificationStyleFactory.STORY_SET_VISIBILITY, 8);
            }
            PendingIntent storyClickedPendingIntent = this.createStoryPageClickedPendingIntent(context, payload, pushStoryPage);
            view.setOnClickPendingIntent(R.id.com_braze_story_relative_layout, storyClickedPendingIntent);
            return true;
        }

        @JvmStatic
        @VisibleForTesting
        public final void setBigPictureSummaryAndTitle(@NotNull NotificationCompat.BigPictureStyle bigPictureNotificationStyle, @NotNull BrazeNotificationPayload payload) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)bigPictureNotificationStyle, (String)"bigPictureNotificationStyle");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
                if (brazeConfigurationProvider == null) {
                    return;
                }
                BrazeConfigurationProvider appConfigProvider = brazeConfigurationProvider;
                String bigSummaryText = payload.getBigSummaryText();
                String bigTitleText = payload.getBigTitleText();
                String summaryText = payload.getSummaryText();
                if (bigSummaryText != null) {
                    bigPictureNotificationStyle.setSummaryText(HtmlUtils.getHtmlSpannedTextIfEnabled(bigSummaryText, appConfigProvider));
                }
                if (bigTitleText != null) {
                    bigPictureNotificationStyle.setBigContentTitle(HtmlUtils.getHtmlSpannedTextIfEnabled(bigTitleText, appConfigProvider));
                }
                if (summaryText != null || bigSummaryText != null) break block4;
                String string = payload.getContentText();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    bigPictureNotificationStyle.setSummaryText(HtmlUtils.getHtmlSpannedTextIfEnabled(it, appConfigProvider));
                }
            }
        }

        private final boolean isRemoteViewNotificationAvailableSpaceConstrained(Context context) {
            return Build.VERSION.SDK_INT >= 31 && context.getApplicationContext().getApplicationInfo().targetSdkVersion >= 31;
        }

        private static final String setStyleIfSupported$lambda$0() {
            return "Setting style for notification";
        }

        private static final String getNotificationStyle$lambda$1() {
            return "Rendering push notification with DecoratedCustomViewStyle (Story)";
        }

        private static final String getNotificationStyle$lambda$2() {
            return "Rendering conversational push";
        }

        private static final String getNotificationStyle$lambda$3() {
            return "Rendering push notification with custom inline image style";
        }

        private static final String getNotificationStyle$lambda$4() {
            return "Rendering push notification with BigPictureStyle";
        }

        private static final String getNotificationStyle$lambda$5() {
            return "Rendering push notification with BigTextStyle";
        }

        private static final String getStoryStyle$lambda$9() {
            return "Push story page cannot render without a context";
        }

        private static final String getStoryStyle$lambda$10() {
            return "Push story page was not populated correctly. Not using DecoratedCustomViewStyle.";
        }

        private static final String getInlineImageStyle$lambda$11() {
            return "Inline Image Push cannot render without a context";
        }

        private static final String getInlineImageStyle$lambda$12() {
            return "Inline Image Push image url invalid";
        }

        private static final String getInlineImageStyle$lambda$13() {
            return "Inline Image Push failed to get image bitmap";
        }

        private static final String getInlineImageStyle$lambda$15() {
            return "Inline Image Push application info was null";
        }

        private static final String getBigPictureNotificationStyle$lambda$18(String $imageUrl) {
            return "Failed to download image bitmap for big picture notification style. Url: " + $imageUrl;
        }

        private static final String getBigPictureNotificationStyle$lambda$19() {
            return "Failed to scale image bitmap, using original.";
        }

        private static final String getBigPictureNotificationStyle$lambda$20() {
            return "Failed to create Big Picture Style.";
        }

        private static final String getConversationalPushStyle$lambda$21() {
            return "Reply person does not exist in mapping. Not rendering a style";
        }

        private static final String getConversationalPushStyle$lambda$22(BrazeNotificationPayload.ConversationMessage $message) {
            return "Message person does not exist in mapping. Not rendering a style. " + $message;
        }

        private static final String getConversationalPushStyle$lambda$23() {
            return "Failed to create conversation push style. Returning null.";
        }

        private static final String populatePushStoryPage$lambda$25() {
            return "Push story page cannot render without a context";
        }

        private static final String populatePushStoryPage$lambda$26() {
            return "Push story page cannot render without a configuration provider";
        }

        private static final String populatePushStoryPage$lambda$27() {
            return "Push story page image url invalid";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/braze/push/BrazeNotificationStyleFactory$NoOpSentinelStyle;", "Landroidx/core/app/NotificationCompat$Style;", "<init>", "()V", "android-sdk-ui_release"})
    private static final class NoOpSentinelStyle
    extends NotificationCompat.Style {
    }
}

