/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.UiModeManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.SystemClock;
import androidx.core.app.NotificationCompat;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.Constants;
import com.braze.IBrazeNotificationFactory;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.BrazePushEventType;
import com.braze.enums.BrazeViewBounds;
import com.braze.enums.Channel;
import com.braze.events.BrazePushEvent;
import com.braze.models.push.BrazeNotificationPayload;
import com.braze.push.BrazeAmazonDeviceMessagingReceiver;
import com.braze.push.BrazeNotificationFactory;
import com.braze.push.BrazePushReceiver;
import com.braze.push.NotificationTrampolineActivity;
import com.braze.push.support.HtmlUtils;
import com.braze.support.BrazeLogger;
import com.braze.support.IntentUtils;
import com.braze.support.JsonUtils;
import com.braze.support.PermissionUtils;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.actions.UriAction;
import com.braze.ui.support.UriUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001[B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J*\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001d*\u00020\u0014H\u0007J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J \u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0007J.\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0007J\u0010\u0010,\u001a\u00020*2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010-\u001a\u00020*2\u0006\u0010\"\u001a\u00020#H\u0007J\"\u0010.\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0007J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00105\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00106\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\"\u00107\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0007J\"\u00108\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0007J\u0018\u00109\u001a\u00020*2\u0006\u0010:\u001a\u0002002\u0006\u00103\u001a\u000204H\u0007J\u0018\u0010;\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010<\u001a\u00020\u001d2\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010=\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010>\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010?\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010@\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010A\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010B\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010C\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00020*H\u0007J\u001c\u0010F\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010G\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010H\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010I\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u0010J\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001aH\u0007J\u0010\u0010K\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010L\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010M\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010N\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010O\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001c\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020S2\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0007J\"\u0010T\u001a\u00020U2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010V\u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0002J.\u0010W\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010X\u001a\u00020Y2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\"\u0010W\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\\"}, d2={"Lcom/braze/push/BrazeNotificationUtils;", "", "<init>", "()V", "TAG", "", "SOURCE_KEY", "activeNotificationFactory", "Lcom/braze/IBrazeNotificationFactory;", "getActiveNotificationFactory", "()Lcom/braze/IBrazeNotificationFactory;", "notificationReceiverClass", "Ljava/lang/Class;", "getNotificationReceiverClass", "()Ljava/lang/Class;", "handleNotificationOpened", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "handleNotificationDeleted", "routeUserWithNotificationOpenedIntent", "brazePush", "Lcom/braze/events/BrazePushEvent;", "extras", "Landroid/os/Bundle;", "deepLink", "useWebView", "", "isBrazePushMessage", "isNotificationMessage", "sendPushMessageReceivedBroadcast", "notificationExtras", "payload", "Lcom/braze/models/push/BrazeNotificationPayload;", "requestGeofenceRefreshIfAppropriate", "refreshFeatureFlagsIfAppropriate", "refreshBannersIfAppropriate", "setNotificationDurationAlarm", "thisClass", "notificationId", "", "durationInMillis", "getNotificationId", "getNotificationPriority", "wakeScreenIfAppropriate", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "prefetchBitmapsIfNewlyReceivedStoryPush", "setTitleIfPresent", "notificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "setContentIfPresent", "setTickerIfPresent", "setContentIntentIfPresent", "setDeleteIntent", "setSmallIcon", "appConfigurationProvider", "setSetShowWhen", "setLargeIconIfPresentAndSupported", "setSoundIfPresentAndSupported", "setSummaryTextIfPresentAndSupported", "setPriorityIfPresentAndSupported", "setAccentColorIfPresentAndSupported", "setCategoryIfPresentAndSupported", "setVisibilityIfPresentAndSupported", "setPublicVersionIfPresentAndSupported", "isValidNotificationVisibility", "visibility", "logBaiduNotificationClick", "customContentString", "handleCancelNotificationAction", "cancelNotification", "isUninstallTrackingPush", "getOrCreateNotificationChannelId", "setNotificationBadgeNumberIfPresent", "handlePushStoryPageClicked", "handleContentCardsSerializedCardIfPresent", "sendNotificationOpenedBroadcast", "getValidNotificationChannel", "Landroid/app/NotificationChannel;", "notificationManager", "Landroid/app/NotificationManager;", "getPushActionPendingIntent", "Landroid/app/PendingIntent;", "action", "sendPushActionIntent", "broadcastType", "Lcom/braze/push/BrazeNotificationUtils$BrazeNotificationBroadcastType;", "pushIntent", "BrazeNotificationBroadcastType", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nBrazeNotificationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeNotificationUtils.kt\ncom/braze/push/BrazeNotificationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1122:1\n1#2:1123\n1#2:1134\n1611#3,9:1124\n1863#3:1133\n1864#3:1135\n1620#3:1136\n1863#3,2:1137\n*S KotlinDebug\n*F\n+ 1 BrazeNotificationUtils.kt\ncom/braze/push/BrazeNotificationUtils\n*L\n457#1:1134\n457#1:1124,9\n457#1:1133\n457#1:1135\n457#1:1136\n458#1:1137,2\n*E\n"})
public final class BrazeNotificationUtils {
    @NotNull
    public static final BrazeNotificationUtils INSTANCE = new BrazeNotificationUtils();
    @NotNull
    private static final String TAG = BrazeLogger.getBrazeLogTag(BrazeNotificationUtils.class);
    @NotNull
    private static final String SOURCE_KEY = "source";

    private BrazeNotificationUtils() {
    }

    @JvmStatic
    @NotNull
    public static final IBrazeNotificationFactory getActiveNotificationFactory() {
        IBrazeNotificationFactory iBrazeNotificationFactory = Braze.Companion.getCustomBrazeNotificationFactory();
        if (iBrazeNotificationFactory == null) {
            iBrazeNotificationFactory = BrazeNotificationFactory.Companion.getInstance();
        }
        return iBrazeNotificationFactory;
    }

    @JvmStatic
    @NotNull
    public static final Class<?> getNotificationReceiverClass() {
        return Constants.isAmazonDevice() ? BrazeAmazonDeviceMessagingReceiver.class : BrazePushReceiver.class;
    }

    @JvmStatic
    public static final void handleNotificationOpened(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            Braze.Companion.getInstance(context).logPushNotificationOpened(intent);
            BrazeNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            BrazeConfigurationProvider appConfigurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
            if (appConfigurationProvider.getDoesHandlePushDeepLinksAutomatically()) {
                BrazeNotificationUtils.routeUserWithNotificationOpenedIntent(context, intent);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeNotificationUtils::handleNotificationOpened$lambda$0, (int)6, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::handleNotificationOpened$lambda$1, (int)4, null);
        }
    }

    @JvmStatic
    public static final void handleNotificationDeleted(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::handleNotificationDeleted$lambda$2, (int)7, null);
            Bundle notificationExtras = intent.getExtras();
            if (notificationExtras != null) {
                BrazeNotificationPayload notificationPayload = new BrazeNotificationPayload(notificationExtras, null, context, null, 10, null);
                INSTANCE.sendPushActionIntent(context, BrazeNotificationBroadcastType.DELETED, notificationExtras, notificationPayload);
            } else {
                BrazeNotificationUtils.sendPushActionIntent$default(INSTANCE, context, BrazeNotificationBroadcastType.DELETED, notificationExtras, null, 8, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::handleNotificationDeleted$lambda$3, (int)4, null);
        }
    }

    @JvmStatic
    public static final void routeUserWithNotificationOpenedIntent(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::routeUserWithNotificationOpenedIntent$lambda$4, (int)7, null);
        Bundle extras = intent.getBundleExtra("extra");
        if (extras == null) {
            extras = new Bundle();
        }
        extras.putString("cid", intent.getStringExtra("cid"));
        extras.putString(SOURCE_KEY, "Appboy");
        String deepLink = intent.getStringExtra("uri");
        boolean useWebView = StringsKt.equals((String)"true", (String)intent.getStringExtra("ab_use_webview"), (boolean)true);
        INSTANCE.routeUserWithNotificationOpenedIntent(context, extras, deepLink, useWebView);
    }

    @JvmStatic
    public static final void routeUserWithNotificationOpenedIntent(@NotNull Context context, @NotNull BrazePushEvent brazePush) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)brazePush, (String)"brazePush");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::routeUserWithNotificationOpenedIntent$lambda$5, (int)7, null);
        Bundle extras = brazePush.getNotificationPayload().getBrazeExtras();
        extras.putString("cid", brazePush.getNotificationPayload().getCampaignId());
        extras.putString(SOURCE_KEY, "Appboy");
        String deepLink = brazePush.getNotificationPayload().getDeeplink();
        Boolean bl = brazePush.getNotificationPayload().getUseWebView();
        boolean useWebView = bl != null ? bl : false;
        INSTANCE.routeUserWithNotificationOpenedIntent(context, extras, deepLink, useWebView);
    }

    private final void routeUserWithNotificationOpenedIntent(Context context, Bundle extras, String deepLink, boolean useWebView) {
        CharSequence charSequence = deepLink;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> BrazeNotificationUtils.routeUserWithNotificationOpenedIntent$lambda$6(deepLink, useWebView), (int)7, null);
            extras.putString("uri", deepLink);
            extras.putBoolean("ab_use_webview", useWebView);
            UriAction uriAction = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(deepLink, extras, useWebView, Channel.PUSH);
            if (uriAction != null) {
                UriAction it = uriAction;
                boolean bl = false;
                BrazeDeeplinkHandler.Companion.getInstance().gotoUri(context, it);
            }
        } else {
            Intent mainActivityIntent = UriUtils.getMainActivityIntent(context, extras);
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> BrazeNotificationUtils.routeUserWithNotificationOpenedIntent$lambda$8(mainActivityIntent), (int)7, null);
            context.startActivity(mainActivityIntent);
        }
    }

    @JvmStatic
    public static final boolean isBrazePushMessage(@NotNull Intent $this$isBrazePushMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$isBrazePushMessage, (String)"<this>");
        Bundle bundle = $this$isBrazePushMessage.getExtras();
        if (bundle == null) {
            return false;
        }
        Bundle extras = bundle;
        return StringsKt.equals((String)"true", (String)extras.getString("_ab"), (boolean)true);
    }

    @JvmStatic
    public static final boolean isNotificationMessage(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return false;
        }
        Bundle extras = bundle;
        return extras.containsKey("t") && extras.containsKey("a");
    }

    @JvmStatic
    public static final void sendPushMessageReceivedBroadcast(@NotNull Context context, @NotNull Bundle notificationExtras, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationExtras, (String)"notificationExtras");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::sendPushMessageReceivedBroadcast$lambda$9, (int)7, null);
        INSTANCE.sendPushActionIntent(context, BrazeNotificationBroadcastType.RECEIVED, notificationExtras, payload);
    }

    @JvmStatic
    public static final boolean requestGeofenceRefreshIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (payload.getShouldSyncGeofences() && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::requestGeofenceRefreshIfAppropriate$lambda$10, (int)7, null);
            BrazeInternal.requestGeofenceRefresh((Context)context, (boolean)true);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeNotificationUtils::requestGeofenceRefreshIfAppropriate$lambda$11, (int)6, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean refreshFeatureFlagsIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (payload.getShouldRefreshFeatureFlags() && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::refreshFeatureFlagsIfAppropriate$lambda$12, (int)7, null);
            BrazeInternal.refreshFeatureFlags((Context)context);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeNotificationUtils::refreshFeatureFlagsIfAppropriate$lambda$13, (int)6, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean refreshBannersIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (payload.getShouldRefreshBanners() && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::refreshBannersIfAppropriate$lambda$14, (int)7, null);
            BrazeInternal.refreshBanners((Context)context);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeNotificationUtils::refreshBannersIfAppropriate$lambda$15, (int)6, null);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void setNotificationDurationAlarm(@NotNull Context context, @Nullable Class<?> thisClass, int notificationId, int durationInMillis) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent cancelIntent = new Intent(context, thisClass);
        cancelIntent.setAction("com.braze.action.CANCEL_NOTIFICATION");
        cancelIntent.putExtra("nid", notificationId);
        int flags = 0x8000000 | IntentUtils.getImmutablePendingIntentFlags();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)cancelIntent, (int)flags);
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager alarmManager = (AlarmManager)object;
        if (durationInMillis >= 1000) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.setNotificationDurationAlarm$lambda$16(durationInMillis), (int)7, null);
            alarmManager.set(3, SystemClock.elapsedRealtime() + (long)durationInMillis, pendingIntent);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int getNotificationId(@NotNull BrazeNotificationPayload payload) {
        int n;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Integer customNotificationId = payload.getCustomNotificationId();
        if (customNotificationId != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.getNotificationId$lambda$17(customNotificationId), (int)7, null);
            n = customNotificationId;
        } else {
            void var3_5;
            String it;
            String messageKey = null;
            messageKey = "";
            String string = payload.getTitleText();
            if (string != null) {
                it = string;
                boolean bl = false;
                messageKey = messageKey + it;
            }
            String string2 = payload.getContentText();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                messageKey = messageKey + it;
            }
            String string3 = messageKey;
            int notificationId = string3 != null ? string3.hashCode() : 0;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.getNotificationId$lambda$20(notificationId), (int)7, null);
            n = var3_5;
        }
        return n;
    }

    @JvmStatic
    public static final int getNotificationPriority(@NotNull BrazeNotificationPayload payload) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Integer notificationPriority = payload.getNotificationPriorityInt();
            Integer n = payload.getNotificationPriorityInt();
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            boolean bl2 = -2 <= it ? it < 3 : false;
            if (bl2) {
                return it;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> BrazeNotificationUtils.getNotificationPriority$lambda$22$lambda$21(notificationPriority), (int)6, null);
        }
        return 0;
    }

    @JvmStatic
    public static final boolean wakeScreenIfAppropriate(@NotNull Context context, @NotNull BrazeConfigurationProvider configurationProvider, @Nullable Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        return BrazeNotificationUtils.wakeScreenIfAppropriate(new BrazeNotificationPayload(notificationExtras, null, context, configurationProvider, 2, null));
    }

    @JvmStatic
    @SuppressLint(value={"WakelockTimeout"})
    public static final boolean wakeScreenIfAppropriate(@NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = context;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return false;
        }
        BrazeConfigurationProvider configurationProvider = brazeConfigurationProvider;
        Bundle notificationExtras = payload.getNotificationExtras();
        if (!PermissionUtils.hasPermission((Context)context2, (String)"android.permission.WAKE_LOCK") || !configurationProvider.isPushWakeScreenForNotificationEnabled()) {
            return false;
        }
        try {
            Object object = context2.getSystemService("uimode");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.UiModeManager");
            UiModeManager uiModeManager = (UiModeManager)object;
            if (uiModeManager.getCurrentModeType() == 4) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::wakeScreenIfAppropriate$lambda$23, (int)7, null);
                return false;
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::wakeScreenIfAppropriate$lambda$24, (int)4, null);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context2.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager notificationManager = (NotificationManager)object;
            NotificationChannel notificationChannel = BrazeNotificationUtils.getValidNotificationChannel(notificationManager, notificationExtras);
            if (notificationChannel == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::wakeScreenIfAppropriate$lambda$25, (int)7, null);
                return false;
            }
            if (notificationChannel.getImportance() == 1) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.wakeScreenIfAppropriate$lambda$26(notificationChannel), (int)7, null);
                return false;
            }
        } else if (BrazeNotificationUtils.getNotificationPriority(payload) == -2) {
            return false;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::wakeScreenIfAppropriate$lambda$27, (int)7, null);
        Object object = context2.getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager powerManager = (PowerManager)object;
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(0x1000001A, TAG);
        wakeLock.acquire();
        wakeLock.release();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void prefetchBitmapsIfNewlyReceivedStoryPush(@NotNull BrazeNotificationPayload payload) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        if (!payload.isPushStory() || !payload.isNewlyReceivedPushStory()) {
            return;
        }
        Iterable $this$mapNotNull$iv = payload.getPushStoryPages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BrazeNotificationPayload.PushStoryPage it = (BrazeNotificationPayload.PushStoryPage)element$iv$iv;
            boolean bl2 = false;
            if (it.getBitmapUrl() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeNotificationUtils.prefetchBitmapsIfNewlyReceivedStoryPush$lambda$30$lambda$29(it), (int)6, null);
            Braze.Companion.getInstance(context2).getImageLoader().getPushBitmapFromUrl(context2, payload.getBrazeExtras(), it, BrazeViewBounds.NOTIFICATION_ONE_IMAGE_STORY);
        }
        payload.setNewlyReceivedPushStory(false);
    }

    @JvmStatic
    public static final void setTitleIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setTitleIfPresent$lambda$31, (int)7, null);
        String string = payload.getTitleText();
        if (string == null) {
            return;
        }
        String titleText = string;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return;
        }
        BrazeConfigurationProvider configurationProvider = brazeConfigurationProvider;
        notificationBuilder.setContentTitle(HtmlUtils.getHtmlSpannedTextIfEnabled(titleText, configurationProvider));
    }

    @JvmStatic
    public static final void setContentIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setContentIfPresent$lambda$32, (int)7, null);
        String string = payload.getContentText();
        if (string == null) {
            return;
        }
        String contentText = string;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return;
        }
        BrazeConfigurationProvider configurationProvider = brazeConfigurationProvider;
        notificationBuilder.setContentText(HtmlUtils.getHtmlSpannedTextIfEnabled(contentText, configurationProvider));
    }

    @JvmStatic
    public static final void setTickerIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setTickerIfPresent$lambda$33, (int)7, null);
        String string = payload.getTitleText();
        if (string == null) {
            return;
        }
        String titleText = string;
        notificationBuilder.setTicker((CharSequence)titleText);
    }

    @JvmStatic
    public static final void setContentIntentIfPresent(@NotNull Context context, @NotNull NotificationCompat.Builder notificationBuilder, @Nullable Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        try {
            PendingIntent pushOpenedPendingIntent = INSTANCE.getPushActionPendingIntent(context, "com.braze.action.BRAZE_PUSH_CLICKED", notificationExtras);
            notificationBuilder.setContentIntent(pushOpenedPendingIntent);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::setContentIntentIfPresent$lambda$34, (int)4, null);
        }
    }

    @JvmStatic
    public static final void setDeleteIntent(@NotNull Context context, @NotNull NotificationCompat.Builder notificationBuilder, @Nullable Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        try {
            Intent intent = new Intent("com.braze.action.BRAZE_PUSH_DELETED").setClass(context, INSTANCE.getNotificationReceiverClass());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setClass(...)");
            Intent pushDeletedIntent = intent;
            if (notificationExtras != null) {
                pushDeletedIntent.putExtras(notificationExtras);
            }
            int flags = 0x40000000 | IntentUtils.getImmutablePendingIntentFlags();
            PendingIntent pushDeletedPendingIntent = PendingIntent.getBroadcast((Context)context, (int)IntentUtils.getRequestCode(), (Intent)pushDeletedIntent, (int)flags);
            notificationBuilder.setDeleteIntent(pushDeletedPendingIntent);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::setDeleteIntent$lambda$35, (int)4, null);
        }
    }

    @JvmStatic
    public static final int setSmallIcon(@NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull NotificationCompat.Builder notificationBuilder) {
        Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        int smallNotificationIconResourceId = appConfigurationProvider.getSmallNotificationIconResourceId();
        if (smallNotificationIconResourceId == 0) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSmallIcon$lambda$36, (int)7, null);
            smallNotificationIconResourceId = appConfigurationProvider.getApplicationIconResourceId();
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSmallIcon$lambda$37, (int)7, null);
        }
        notificationBuilder.setSmallIcon(smallNotificationIconResourceId);
        return smallNotificationIconResourceId;
    }

    @JvmStatic
    public static final void setSetShowWhen(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (payload.isPushStory()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSetShowWhen$lambda$38, (int)7, null);
            notificationBuilder.setShowWhen(false);
        }
    }

    @JvmStatic
    public static final boolean setLargeIconIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (payload.isPushStory()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setLargeIconIfPresentAndSupported$lambda$39, (int)7, null);
            return false;
        }
        Context context = payload.getContext();
        if (context == null) {
            return false;
        }
        Context context2 = context;
        BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
        if (brazeConfigurationProvider == null) {
            return false;
        }
        BrazeConfigurationProvider appConfigurationProvider = brazeConfigurationProvider;
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setLargeIconIfPresentAndSupported$lambda$40, (int)7, null);
            String string = payload.getLargeIcon();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Bitmap largeNotificationBitmap = Braze.Companion.getInstance(context2).getImageLoader().getPushBitmapFromUrl(context2, null, it, BrazeViewBounds.NOTIFICATION_LARGE_ICON);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setLargeIconIfPresentAndSupported$lambda$42, (int)7, null);
            int largeNotificationIconResourceId = appConfigurationProvider.getLargeNotificationIconResourceId();
            if (largeNotificationIconResourceId != 0) {
                Bitmap largeNotificationBitmap = BitmapFactory.decodeResource((Resources)context2.getResources(), (int)largeNotificationIconResourceId);
                notificationBuilder.setLargeIcon(largeNotificationBitmap);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setLargeIconIfPresentAndSupported$lambda$43, (int)7, null);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::setLargeIconIfPresentAndSupported$lambda$44, (int)4, null);
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setLargeIconIfPresentAndSupported$lambda$45, (int)7, null);
        return false;
    }

    @JvmStatic
    public static final void setSoundIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        NotificationCompat.Builder builder;
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = payload.getNotificationSound();
        if (string == null) {
            return;
        }
        String soundUri = string;
        if (Intrinsics.areEqual((Object)soundUri, (Object)"d")) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSoundIfPresentAndSupported$lambda$46, (int)7, null);
            builder = notificationBuilder.setDefaults(1);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSoundIfPresentAndSupported$lambda$47, (int)7, null);
            builder = notificationBuilder.setSound(Uri.parse((String)soundUri));
        }
    }

    @JvmStatic
    public static final void setSummaryTextIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String summaryText = payload.getSummaryText();
        if (summaryText != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSummaryTextIfPresentAndSupported$lambda$48, (int)7, null);
            NotificationCompat.Builder builder = notificationBuilder.setSubText((CharSequence)summaryText);
            Intrinsics.checkNotNull((Object)builder);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setSummaryTextIfPresentAndSupported$lambda$49, (int)7, null);
        }
    }

    @JvmStatic
    public static final void setPriorityIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setPriorityIfPresentAndSupported$lambda$50, (int)7, null);
        notificationBuilder.setPriority(BrazeNotificationUtils.getNotificationPriority(payload));
    }

    @JvmStatic
    public static final void setAccentColorIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                Integer accentColor = payload.getAccentColor();
                if (accentColor == null) break block0;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setAccentColorIfPresentAndSupported$lambda$51, (int)7, null);
                notificationBuilder.setColor(accentColor.intValue());
                break block1;
            }
            BrazeConfigurationProvider brazeConfigurationProvider = payload.getConfigurationProvider();
            if (brazeConfigurationProvider == null) break block1;
            BrazeConfigurationProvider it = brazeConfigurationProvider;
            boolean bl = false;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setAccentColorIfPresentAndSupported$lambda$53$lambda$52, (int)7, null);
            notificationBuilder.setColor(it.getDefaultNotificationAccentColor());
        }
    }

    @JvmStatic
    public static final void setCategoryIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String notificationCategory = payload.getNotificationCategory();
        if (notificationCategory != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setCategoryIfPresentAndSupported$lambda$54, (int)7, null);
            NotificationCompat.Builder builder = notificationBuilder.setCategory(notificationCategory);
            Intrinsics.checkNotNull((Object)builder);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setCategoryIfPresentAndSupported$lambda$55, (int)7, null);
        }
    }

    @JvmStatic
    public static final void setVisibilityIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Integer visibility = payload.getNotificationVisibility();
        if (visibility != null) {
            if (BrazeNotificationUtils.isValidNotificationVisibility(visibility)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setVisibilityIfPresentAndSupported$lambda$56, (int)7, null);
                NotificationCompat.Builder builder = notificationBuilder.setVisibility(visibility.intValue());
                Intrinsics.checkNotNull((Object)builder);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> BrazeNotificationUtils.setVisibilityIfPresentAndSupported$lambda$57(visibility), (int)6, null);
            }
        }
    }

    @JvmStatic
    public static final void setPublicVersionIfPresentAndSupported(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Context context = payload.getContext();
        BrazeConfigurationProvider appConfigurationProvider = payload.getConfigurationProvider();
        if (context == null || payload.getPublicNotificationExtras() == null || appConfigurationProvider == null) {
            return;
        }
        String notificationChannelId = BrazeNotificationUtils.getOrCreateNotificationChannelId(payload);
        Bundle publicNotificationExtras = JsonUtils.parseJsonObjectIntoBundle((String)payload.getPublicNotificationExtras());
        if (publicNotificationExtras.isEmpty()) {
            return;
        }
        BrazeNotificationPayload publicPayload = new BrazeNotificationPayload(publicNotificationExtras, null, context, appConfigurationProvider, 2, null);
        NotificationCompat.Builder publicNotificationBuilder = new NotificationCompat.Builder(context, notificationChannelId);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.setPublicVersionIfPresentAndSupported$lambda$58(publicPayload), (int)7, null);
        BrazeNotificationUtils.setContentIfPresent(publicNotificationBuilder, publicPayload);
        BrazeNotificationUtils.setTitleIfPresent(publicNotificationBuilder, publicPayload);
        BrazeNotificationUtils.setSummaryTextIfPresentAndSupported(publicNotificationBuilder, publicPayload);
        BrazeNotificationUtils.setSmallIcon(appConfigurationProvider, publicNotificationBuilder);
        BrazeNotificationUtils.setAccentColorIfPresentAndSupported(publicNotificationBuilder, publicPayload);
        notificationBuilder.setPublicVersion(publicNotificationBuilder.build());
    }

    @JvmStatic
    public static final boolean isValidNotificationVisibility(int visibility) {
        return visibility == -1 || visibility == 0 || visibility == 1;
    }

    @JvmStatic
    public static final void logBaiduNotificationClick(@Nullable Context context, @Nullable String customContentString) {
        if (customContentString == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeNotificationUtils::logBaiduNotificationClick$lambda$59, (int)6, null);
            return;
        }
        if (context == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, BrazeNotificationUtils::logBaiduNotificationClick$lambda$60, (int)6, null);
            return;
        }
        try {
            JSONObject jsonExtras = new JSONObject(customContentString);
            String source = JsonUtils.getOptionalString((JSONObject)jsonExtras, (String)SOURCE_KEY);
            String campaignId = JsonUtils.getOptionalString((JSONObject)jsonExtras, (String)"cid");
            if (source != null && Intrinsics.areEqual((Object)source, (Object)"Appboy") && campaignId != null) {
                Braze.Companion.getInstance(context).logPushNotificationOpened(campaignId);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> BrazeNotificationUtils.logBaiduNotificationClick$lambda$61(customContentString), (int)4, null);
        }
    }

    @JvmStatic
    public static final void handleCancelNotificationAction(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            if (intent.hasExtra("nid")) {
                int notificationId = intent.getIntExtra("nid", -1);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.handleCancelNotificationAction$lambda$62(notificationId), (int)7, null);
                Object object = context.getSystemService("notification");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager notificationManager = (NotificationManager)object;
                notificationManager.cancel("appboy_notification", notificationId);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::handleCancelNotificationAction$lambda$63, (int)4, null);
        }
    }

    @JvmStatic
    public static final void cancelNotification(@NotNull Context context, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.cancelNotification$lambda$64(notificationId), (int)7, null);
            Intent intent = new Intent("com.braze.action.CANCEL_NOTIFICATION").setClass(context, INSTANCE.getNotificationReceiverClass());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setClass(...)");
            Intent cancelNotificationIntent = intent;
            cancelNotificationIntent.setPackage(context.getPackageName());
            cancelNotificationIntent.putExtra("nid", notificationId);
            IntentUtils.addComponentAndSendBroadcast((Context)context, (Intent)cancelNotificationIntent);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::cancelNotification$lambda$65, (int)4, null);
        }
    }

    @JvmStatic
    public static final boolean isUninstallTrackingPush(@NotNull Bundle notificationExtras) {
        Intrinsics.checkNotNullParameter((Object)notificationExtras, (String)"notificationExtras");
        try {
            if (notificationExtras.containsKey("appboy_uninstall_tracking")) {
                return true;
            }
            Bundle fcmExtras = notificationExtras.getBundle("extra");
            if (fcmExtras != null) {
                return fcmExtras.containsKey("appboy_uninstall_tracking");
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::isUninstallTrackingPush$lambda$66, (int)4, null);
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final String getOrCreateNotificationChannelId(@NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String channelIdFromExtras = payload.getNotificationChannelId();
        String defaultChannelId = "com_appboy_default_notification_channel";
        if (Build.VERSION.SDK_INT < 26) {
            String string = channelIdFromExtras;
            if (string == null) {
                string = defaultChannelId;
            }
            return string;
        }
        Context context = payload.getContext();
        BrazeConfigurationProvider config = payload.getConfigurationProvider();
        Context context2 = context;
        Object object = context2 != null ? context2.getSystemService("notification") : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        if (channelIdFromExtras != null) {
            if (notificationManager.getNotificationChannel(channelIdFromExtras) != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.getOrCreateNotificationChannelId$lambda$67(channelIdFromExtras), (int)7, null);
                return channelIdFromExtras;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.getOrCreateNotificationChannelId$lambda$68(channelIdFromExtras), (int)7, null);
        }
        if (notificationManager.getNotificationChannel(defaultChannelId) == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::getOrCreateNotificationChannelId$lambda$69, (int)7, null);
            BrazeConfigurationProvider brazeConfigurationProvider = config;
            NotificationChannel channel = new NotificationChannel(defaultChannelId, (CharSequence)(brazeConfigurationProvider != null ? brazeConfigurationProvider.getDefaultNotificationChannelName() : null), 3);
            BrazeConfigurationProvider brazeConfigurationProvider2 = config;
            channel.setDescription(brazeConfigurationProvider2 != null ? brazeConfigurationProvider2.getDefaultNotificationChannelDescription() : null);
            notificationManager.createNotificationChannel(channel);
        }
        return defaultChannelId;
    }

    @JvmStatic
    public static final void setNotificationBadgeNumberIfPresent(@NotNull NotificationCompat.Builder notificationBuilder, @NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (Build.VERSION.SDK_INT < 26) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::setNotificationBadgeNumberIfPresent$lambda$70, (int)7, null);
            return;
        }
        Integer notificationBadgeNumber = payload.getNotificationBadgeNumber();
        if (notificationBadgeNumber != null) {
            notificationBuilder.setNumber(notificationBadgeNumber.intValue());
        }
    }

    @JvmStatic
    public static final void handlePushStoryPageClicked(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            String deepLink;
            CharSequence charSequence;
            Braze.Companion.getInstance(context).logPushStoryPageClicked(intent.getStringExtra("braze_campaign_id"), intent.getStringExtra("braze_story_page_id"));
            BrazeConfigurationProvider appConfigurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
            int notificationId = intent.getIntExtra("nid", 0);
            if (appConfigurationProvider.getDoesPushStoryDismissOnClick() && notificationId != 0) {
                BrazeNotificationUtils.cancelNotification(context, notificationId);
            }
            if (!((charSequence = (CharSequence)(deepLink = intent.getStringExtra("braze_action_uri"))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                intent.putExtra("uri", intent.getStringExtra("braze_action_uri"));
                String useWebviewString = intent.getStringExtra("braze_action_use_webview");
                CharSequence charSequence2 = useWebviewString;
                if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    intent.putExtra("ab_use_webview", useWebviewString);
                }
            } else {
                intent.removeExtra("uri");
            }
            BrazeNotificationUtils.sendNotificationOpenedBroadcast(context, intent);
            if (appConfigurationProvider.getDoesHandlePushDeepLinksAutomatically()) {
                BrazeNotificationUtils.routeUserWithNotificationOpenedIntent(context, intent);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> BrazeNotificationUtils.handlePushStoryPageClicked$lambda$71(deepLink), (int)6, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, BrazeNotificationUtils::handlePushStoryPageClicked$lambda$72, (int)4, null);
        }
    }

    @JvmStatic
    public static final void handleContentCardsSerializedCardIfPresent(@NotNull BrazeNotificationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String contentCardData = payload.getContentCardSyncData();
        String contentCardDataUserId = payload.getContentCardSyncUserId();
        Context context = payload.getContext();
        if (contentCardData != null && context != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.handleContentCardsSerializedCardIfPresent$lambda$73(contentCardDataUserId, contentCardData), (int)7, null);
            BrazeInternal.addSerializedContentCardToStorage((Context)context, (String)contentCardData, (String)contentCardDataUserId);
        }
    }

    @JvmStatic
    public static final void sendNotificationOpenedBroadcast(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::sendNotificationOpenedBroadcast$lambda$74, (int)7, null);
        Bundle notificationExtras = intent.getExtras();
        if (notificationExtras != null) {
            BrazeNotificationPayload notificationPayload = new BrazeNotificationPayload(notificationExtras, null, context, null, 10, null);
            INSTANCE.sendPushActionIntent(context, BrazeNotificationBroadcastType.OPENED, notificationExtras, notificationPayload);
        } else {
            BrazeNotificationUtils.sendPushActionIntent$default(INSTANCE, context, BrazeNotificationBroadcastType.OPENED, notificationExtras, null, 8, null);
        }
    }

    @JvmStatic
    @TargetApi(value=26)
    @Nullable
    public static final NotificationChannel getValidNotificationChannel(@NotNull NotificationManager notificationManager, @Nullable Bundle notificationExtras) {
        NotificationChannel defaultNotificationChannel;
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        if (notificationExtras == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::getValidNotificationChannel$lambda$75, (int)7, null);
            return null;
        }
        String channelIdFromExtras = notificationExtras.getString("ab_nc", null);
        CharSequence charSequence = channelIdFromExtras;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(channelIdFromExtras);
            if (notificationChannel != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.getValidNotificationChannel$lambda$76(channelIdFromExtras), (int)7, null);
                return notificationChannel;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, () -> BrazeNotificationUtils.getValidNotificationChannel$lambda$77(channelIdFromExtras), (int)7, null);
        }
        if ((defaultNotificationChannel = notificationManager.getNotificationChannel("com_appboy_default_notification_channel")) != null) {
            return defaultNotificationChannel;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)INSTANCE, null, null, (boolean)false, BrazeNotificationUtils::getValidNotificationChannel$lambda$78, (int)7, null);
        return null;
    }

    private final PendingIntent getPushActionPendingIntent(Context context, String action, Bundle notificationExtras) {
        Intent intent = new Intent(action).setClass(context, NotificationTrampolineActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"setClass(...)");
        Intent pushActionIntent = intent;
        if (notificationExtras != null) {
            pushActionIntent.putExtras(notificationExtras);
        }
        int flags = 0x40000000 | IntentUtils.getImmutablePendingIntentFlags();
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)IntentUtils.getRequestCode(), (Intent)pushActionIntent, (int)flags);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getActivity(...)");
        return pendingIntent;
    }

    private final void sendPushActionIntent(Context context, BrazeNotificationBroadcastType broadcastType, Bundle notificationExtras, BrazeNotificationPayload payload) {
        Intent intent;
        switch (WhenMappings.$EnumSwitchMapping$0[broadcastType.ordinal()]) {
            case 1: {
                Intent intent2 = new Intent("com.braze.push.intent.NOTIFICATION_OPENED").setPackage(context.getPackageName());
                Intrinsics.checkNotNull((Object)intent2);
                intent = intent2;
                break;
            }
            case 2: {
                Intent intent2 = new Intent("com.braze.push.intent.NOTIFICATION_RECEIVED").setPackage(context.getPackageName());
                Intrinsics.checkNotNull((Object)intent2);
                intent = intent2;
                break;
            }
            case 3: {
                Intent intent2 = new Intent("com.braze.push.intent.NOTIFICATION_DELETED").setPackage(context.getPackageName());
                Intrinsics.checkNotNull((Object)intent2);
                intent = intent2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intent brazePushIntent = intent;
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeNotificationUtils.sendPushActionIntent$lambda$79(broadcastType), (int)6, null);
        this.sendPushActionIntent(context, brazePushIntent, notificationExtras);
        if (payload != null) {
            BrazeInternal.INSTANCE.publishBrazePushAction(context, broadcastType.getBrazePushEventType(), payload);
        }
    }

    static /* synthetic */ void sendPushActionIntent$default(BrazeNotificationUtils brazeNotificationUtils, Context context, BrazeNotificationBroadcastType brazeNotificationBroadcastType, Bundle bundle, BrazeNotificationPayload brazeNotificationPayload, int n, Object object) {
        if ((n & 8) != 0) {
            brazeNotificationPayload = null;
        }
        brazeNotificationUtils.sendPushActionIntent(context, brazeNotificationBroadcastType, bundle, brazeNotificationPayload);
    }

    private final void sendPushActionIntent(Context context, Intent pushIntent, Bundle notificationExtras) {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BrazeNotificationUtils.sendPushActionIntent$lambda$80(pushIntent), (int)6, null);
        if (notificationExtras != null) {
            pushIntent.putExtras(notificationExtras);
        }
        IntentUtils.addComponentAndSendBroadcast((Context)context, (Intent)pushIntent);
    }

    private static final String handleNotificationOpened$lambda$0() {
        return "Not handling deep links automatically, skipping deep link handling";
    }

    private static final String handleNotificationOpened$lambda$1() {
        return "Exception occurred attempting to handle notification opened intent.";
    }

    private static final String handleNotificationDeleted$lambda$2() {
        return "Sending notification deleted broadcast";
    }

    private static final String handleNotificationDeleted$lambda$3() {
        return "Exception occurred attempting to handle notification delete intent.";
    }

    private static final String routeUserWithNotificationOpenedIntent$lambda$4() {
        return "routeUserWithNotificationOpenedIntent called with Intent";
    }

    private static final String routeUserWithNotificationOpenedIntent$lambda$5() {
        return "routeUserWithNotificationOpenedIntent called with BrazePushEvent";
    }

    private static final String routeUserWithNotificationOpenedIntent$lambda$6(String $deepLink, boolean $useWebView) {
        return "Found a deep link: " + $deepLink + ". Use webview set to: " + $useWebView;
    }

    private static final String routeUserWithNotificationOpenedIntent$lambda$8(Intent $mainActivityIntent) {
        return "Push notification had no deep link. Opening main activity: " + $mainActivityIntent;
    }

    private static final String sendPushMessageReceivedBroadcast$lambda$9() {
        return "Sending push message received broadcast";
    }

    private static final String requestGeofenceRefreshIfAppropriate$lambda$10() {
        return "Geofence sync key was true. Syncing geofences.";
    }

    private static final String requestGeofenceRefreshIfAppropriate$lambda$11() {
        return "Geofence sync key not included in push payload or false. Not syncing geofences.";
    }

    private static final String refreshFeatureFlagsIfAppropriate$lambda$12() {
        return "Feature flag refresh key was true. Refreshing feature flags.";
    }

    private static final String refreshFeatureFlagsIfAppropriate$lambda$13() {
        return "Feature flag refresh key not included in push payload or false. Not refreshing feature flags.";
    }

    private static final String refreshBannersIfAppropriate$lambda$14() {
        return "Banners refresh key was true. Refreshing Banners.";
    }

    private static final String refreshBannersIfAppropriate$lambda$15() {
        return "Banners refresh key not included in push payload or false. Not refreshing banners.";
    }

    private static final String setNotificationDurationAlarm$lambda$16(int $durationInMillis) {
        return "Setting Notification duration alarm for " + $durationInMillis + " ms";
    }

    private static final String getNotificationId$lambda$17(Integer $customNotificationId) {
        return "Using notification id provided in the message's extras bundle: " + $customNotificationId;
    }

    private static final String getNotificationId$lambda$20(int $notificationId) {
        return "Message without notification id provided in the extras bundle received. Using a hash of the message: " + $notificationId;
    }

    private static final String getNotificationPriority$lambda$22$lambda$21(Integer $notificationPriority) {
        return "Received invalid notification priority " + $notificationPriority;
    }

    private static final String wakeScreenIfAppropriate$lambda$23() {
        return "Not waking this TV UI mode device";
    }

    private static final String wakeScreenIfAppropriate$lambda$24() {
        return "Failed to check for TV status during screen wake. Continuing.";
    }

    private static final String wakeScreenIfAppropriate$lambda$25() {
        return "Not waking screen on Android O+ device, could not find notification channel.";
    }

    private static final String wakeScreenIfAppropriate$lambda$26(NotificationChannel $notificationChannel) {
        return "Not acquiring wake-lock for Android O+ notification with importance: " + $notificationChannel.getImportance();
    }

    private static final String wakeScreenIfAppropriate$lambda$27() {
        return "Waking screen for notification";
    }

    private static final String prefetchBitmapsIfNewlyReceivedStoryPush$lambda$30$lambda$29(String $it) {
        return "Pre-fetching bitmap at URL: " + $it;
    }

    private static final String setTitleIfPresent$lambda$31() {
        return "Setting title for notification";
    }

    private static final String setContentIfPresent$lambda$32() {
        return "Setting content for notification";
    }

    private static final String setTickerIfPresent$lambda$33() {
        return "Setting ticker for notification";
    }

    private static final String setContentIntentIfPresent$lambda$34() {
        return "Error setting content intent.";
    }

    private static final String setDeleteIntent$lambda$35() {
        return "Error setting delete intent.";
    }

    private static final String setSmallIcon$lambda$36() {
        return "Small notification icon resource was not found. Will use the app icon when displaying notifications.";
    }

    private static final String setSmallIcon$lambda$37() {
        return "Setting small icon for notification via resource id";
    }

    private static final String setSetShowWhen$lambda$38() {
        return "Set show when not supported in story push.";
    }

    private static final String setLargeIconIfPresentAndSupported$lambda$39() {
        return "Large icon not supported in story push.";
    }

    private static final String setLargeIconIfPresentAndSupported$lambda$40() {
        return "Setting large icon for notification";
    }

    private static final String setLargeIconIfPresentAndSupported$lambda$42() {
        return "Large icon bitmap url not present in extras. Attempting to use resource id instead.";
    }

    private static final String setLargeIconIfPresentAndSupported$lambda$43() {
        return "Large icon resource id not present for notification";
    }

    private static final String setLargeIconIfPresentAndSupported$lambda$44() {
        return "Error setting large notification icon";
    }

    private static final String setLargeIconIfPresentAndSupported$lambda$45() {
        return "Large icon not set for notification";
    }

    private static final String setSoundIfPresentAndSupported$lambda$46() {
        return "Setting default sound for notification.";
    }

    private static final String setSoundIfPresentAndSupported$lambda$47() {
        return "Setting sound for notification via uri.";
    }

    private static final String setSummaryTextIfPresentAndSupported$lambda$48() {
        return "Setting summary text for notification";
    }

    private static final String setSummaryTextIfPresentAndSupported$lambda$49() {
        return "Summary text not present. Not setting summary text for notification.";
    }

    private static final String setPriorityIfPresentAndSupported$lambda$50() {
        return "Setting priority for notification";
    }

    private static final String setAccentColorIfPresentAndSupported$lambda$51() {
        return "Using accent color for notification from extras bundle";
    }

    private static final String setAccentColorIfPresentAndSupported$lambda$53$lambda$52() {
        return "Using default accent color for notification";
    }

    private static final String setCategoryIfPresentAndSupported$lambda$54() {
        return "Setting category for notification";
    }

    private static final String setCategoryIfPresentAndSupported$lambda$55() {
        return "Category not present in notification extras. Not setting category for notification.";
    }

    private static final String setVisibilityIfPresentAndSupported$lambda$56() {
        return "Setting visibility for notification";
    }

    private static final String setVisibilityIfPresentAndSupported$lambda$57(Integer $visibility) {
        return "Received invalid notification visibility " + $visibility;
    }

    private static final String setPublicVersionIfPresentAndSupported$lambda$58(BrazeNotificationPayload $publicPayload) {
        return "Setting public version of notification with payload: " + $publicPayload;
    }

    private static final String logBaiduNotificationClick$lambda$59() {
        return "customContentString was null. Doing nothing.";
    }

    private static final String logBaiduNotificationClick$lambda$60() {
        return "Cannot log baidu click with null context. Doing nothing.";
    }

    private static final String logBaiduNotificationClick$lambda$61(String $customContentString) {
        return "Caught an exception processing customContentString: " + $customContentString;
    }

    private static final String handleCancelNotificationAction$lambda$62(int $notificationId) {
        return "Cancelling notification action with id: " + $notificationId;
    }

    private static final String handleCancelNotificationAction$lambda$63() {
        return "Exception occurred handling cancel notification intent.";
    }

    private static final String cancelNotification$lambda$64(int $notificationId) {
        return "Cancelling notification action with id: " + $notificationId;
    }

    private static final String cancelNotification$lambda$65() {
        return "Exception occurred attempting to cancel notification.";
    }

    private static final String isUninstallTrackingPush$lambda$66() {
        return "Failed to determine if push is uninstall tracking. Returning false.";
    }

    private static final String getOrCreateNotificationChannelId$lambda$67(String $channelIdFromExtras) {
        return "Found notification channel in extras with id: " + $channelIdFromExtras;
    }

    private static final String getOrCreateNotificationChannelId$lambda$68(String $channelIdFromExtras) {
        return "Notification channel from extras is invalid. No channel found with id: " + $channelIdFromExtras;
    }

    private static final String getOrCreateNotificationChannelId$lambda$69() {
        return "Braze default notification channel does not exist on device. Creating default channel.";
    }

    private static final String setNotificationBadgeNumberIfPresent$lambda$70() {
        return "Notification badge number not supported on this android version. Not setting badge number for notification.";
    }

    private static final String handlePushStoryPageClicked$lambda$71(String $deepLink) {
        return "Not handling deep links automatically, skipping deep link handling for '" + $deepLink + '\'';
    }

    private static final String handlePushStoryPageClicked$lambda$72() {
        return "Caught exception while handling story click.";
    }

    private static final String handleContentCardsSerializedCardIfPresent$lambda$73(String $contentCardDataUserId, String $contentCardData) {
        return "Push contains associated Content Cards card. User id: " + $contentCardDataUserId + " Card data: " + $contentCardData;
    }

    private static final String sendNotificationOpenedBroadcast$lambda$74() {
        return "Sending notification opened broadcast";
    }

    private static final String getValidNotificationChannel$lambda$75() {
        return "Notification extras bundle was null. Could not find a valid notification channel";
    }

    private static final String getValidNotificationChannel$lambda$76(String $channelIdFromExtras) {
        return "Found notification channel in extras with id: " + $channelIdFromExtras;
    }

    private static final String getValidNotificationChannel$lambda$77(String $channelIdFromExtras) {
        return "Notification channel from extras is invalid, no channel found with id: " + $channelIdFromExtras;
    }

    private static final String getValidNotificationChannel$lambda$78() {
        return "Braze default notification channel does not exist on device.";
    }

    private static final String sendPushActionIntent$lambda$79(BrazeNotificationBroadcastType $broadcastType) {
        return "Sending Braze broadcast receiver intent for " + (Object)((Object)$broadcastType);
    }

    private static final String sendPushActionIntent$lambda$80(Intent $pushIntent) {
        return "Sending push action intent: " + $pushIntent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/braze/push/BrazeNotificationUtils$BrazeNotificationBroadcastType;", "", "brazePushEventType", "Lcom/braze/enums/BrazePushEventType;", "<init>", "(Ljava/lang/String;ILcom/braze/enums/BrazePushEventType;)V", "getBrazePushEventType", "()Lcom/braze/enums/BrazePushEventType;", "OPENED", "RECEIVED", "DELETED", "android-sdk-ui_release"})
    private static final class BrazeNotificationBroadcastType
    extends Enum<BrazeNotificationBroadcastType> {
        @NotNull
        private final BrazePushEventType brazePushEventType;
        public static final /* enum */ BrazeNotificationBroadcastType OPENED = new BrazeNotificationBroadcastType(BrazePushEventType.NOTIFICATION_OPENED);
        public static final /* enum */ BrazeNotificationBroadcastType RECEIVED = new BrazeNotificationBroadcastType(BrazePushEventType.NOTIFICATION_RECEIVED);
        public static final /* enum */ BrazeNotificationBroadcastType DELETED = new BrazeNotificationBroadcastType(BrazePushEventType.NOTIFICATION_DELETED);
        private static final /* synthetic */ BrazeNotificationBroadcastType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BrazeNotificationBroadcastType(BrazePushEventType brazePushEventType) {
            this.brazePushEventType = brazePushEventType;
        }

        @NotNull
        public final BrazePushEventType getBrazePushEventType() {
            return this.brazePushEventType;
        }

        public static BrazeNotificationBroadcastType[] values() {
            return (BrazeNotificationBroadcastType[])$VALUES.clone();
        }

        public static BrazeNotificationBroadcastType valueOf(String value) {
            return Enum.valueOf(BrazeNotificationBroadcastType.class, value);
        }

        @NotNull
        public static EnumEntries<BrazeNotificationBroadcastType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = brazeNotificationBroadcastTypeArray = new BrazeNotificationBroadcastType[]{BrazeNotificationBroadcastType.OPENED, BrazeNotificationBroadcastType.RECEIVED, BrazeNotificationBroadcastType.DELETED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrazeNotificationBroadcastType.values().length];
            try {
                nArray[BrazeNotificationBroadcastType.OPENED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrazeNotificationBroadcastType.RECEIVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrazeNotificationBroadcastType.DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

