/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationManagerCompat;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.Constants;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.coroutine.BrazeCoroutineScope;
import com.braze.models.push.BrazeNotificationPayload;
import com.braze.push.BrazeNotificationActionUtils;
import com.braze.push.BrazeNotificationUtils;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/braze/push/BrazePushReceiver;", "Landroid/content/BroadcastReceiver;", "<init>", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "Companion", "android-sdk-ui_release"})
public class BrazePushReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MESSAGE_TYPE_KEY = "message_type";
    @NotNull
    private static final String DELETED_MESSAGES_KEY = "deleted_messages";
    @NotNull
    private static final String NUMBER_OF_MESSAGES_DELETED_KEY = "total_deleted";
    @NotNull
    private static final String ADM_RECEIVE_INTENT_ACTION = "com.amazon.device.messaging.intent.RECEIVE";
    @NotNull
    private static final String ADM_REGISTRATION_INTENT_ACTION = "com.amazon.device.messaging.intent.REGISTRATION";
    @NotNull
    private static final String ADM_ERROR_KEY = "error";
    @NotNull
    private static final String ADM_ERROR_DESCRIPTION_KEY = "error_description";
    @NotNull
    private static final String ADM_REGISTRATION_ID_KEY = "registration_id";
    @NotNull
    private static final String ADM_UNREGISTERED_KEY = "unregistered";
    @NotNull
    public static final String FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION = "firebase_messaging_service_routing_action";
    @NotNull
    public static final String HMS_PUSH_SERVICE_ROUTING_ACTION = "hms_push_service_routing_action";

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        com.braze.push.BrazePushReceiver$Companion.handleReceivedIntent$default(Companion, context, intent, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent, boolean runOnThread) {
        Companion.handleReceivedIntent(context, intent, runOnThread);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean handleAdmRegistrationEventIfEnabled(@NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Context context, @NotNull Intent intent) {
        return Companion.handleAdmRegistrationEventIfEnabled(appConfigurationProvider, context, intent);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean handleAdmRegistrationIntent(@NotNull Context context, @NotNull Intent intent) {
        return Companion.handleAdmRegistrationIntent(context, intent);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean handlePushNotificationPayload(@NotNull Context context, @NotNull Intent intent) {
        return Companion.handlePushNotificationPayload(context, intent);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final BrazeNotificationPayload createPayload(@NotNull Context context, @NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Bundle notificationExtras, @NotNull Bundle brazeExtras) {
        return Companion.createPayload(context, appConfigurationProvider, notificationExtras, brazeExtras);
    }

    @JvmStatic
    @JvmOverloads
    public static final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent) {
        Companion.handleReceivedIntent(context, intent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007J \u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0007J\u001d\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/braze/push/BrazePushReceiver$Companion;", "", "<init>", "()V", "MESSAGE_TYPE_KEY", "", "DELETED_MESSAGES_KEY", "NUMBER_OF_MESSAGES_DELETED_KEY", "ADM_RECEIVE_INTENT_ACTION", "ADM_REGISTRATION_INTENT_ACTION", "ADM_ERROR_KEY", "ADM_ERROR_DESCRIPTION_KEY", "ADM_REGISTRATION_ID_KEY", "ADM_UNREGISTERED_KEY", "FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION", "HMS_PUSH_SERVICE_ROUTING_ACTION", "handlePush", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "handleReceivedIntent", "runOnThread", "", "handleAdmRegistrationEventIfEnabled", "appConfigurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "handleAdmRegistrationIntent", "handlePushNotificationPayload", "createPayload", "Lcom/braze/models/push/BrazeNotificationPayload;", "notificationExtras", "Landroid/os/Bundle;", "brazeExtras", "logNotificationMetadata", "payload", "logNotificationMetadata$android_sdk_ui_release", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void handlePush(Context context, Intent intent) {
            Context applicationContext = context.getApplicationContext();
            String action = intent.getAction();
            try {
                com.braze.push.BrazePushReceiver$Companion.handlePush$performWork(action, applicationContext, intent, context);
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> Companion.handlePush$lambda$3(action, intent), (int)4, null);
            }
        }

        @JvmStatic
        @JvmOverloads
        public final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent, boolean runOnThread) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (runOnThread) {
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)BrazeCoroutineScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, intent, null){
                    int label;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ Intent $intent;
                    {
                        this.$context = $context;
                        this.$intent = $intent;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Context context = this.$context.getApplicationContext();
                                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                                com.braze.push.BrazePushReceiver$Companion.access$handlePush(BrazePushReceiver.Companion, context, this.$intent);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else {
                this.handlePush(context, intent);
            }
        }

        public static /* synthetic */ void handleReceivedIntent$default(Companion companion, Context context, Intent intent, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.handleReceivedIntent(context, intent, bl);
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean handleAdmRegistrationEventIfEnabled(@NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handleAdmRegistrationEventIfEnabled$lambda$4(intent), (int)6, null);
            if (Constants.isAmazonDevice() && appConfigurationProvider.isAdmMessagingRegistrationEnabled()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handleAdmRegistrationEventIfEnabled$lambda$5, (int)7, null);
                this.handleAdmRegistrationIntent(context, intent);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, Companion::handleAdmRegistrationEventIfEnabled$lambda$6, (int)6, null);
            return false;
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean handleAdmRegistrationIntent(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            String error = intent.getStringExtra(BrazePushReceiver.ADM_ERROR_KEY);
            String errorDescription = intent.getStringExtra(BrazePushReceiver.ADM_ERROR_DESCRIPTION_KEY);
            String registrationId = intent.getStringExtra(BrazePushReceiver.ADM_REGISTRATION_ID_KEY);
            String unregistered = intent.getStringExtra(BrazePushReceiver.ADM_UNREGISTERED_KEY);
            if (error != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> Companion.handleAdmRegistrationIntent$lambda$7(error, errorDescription), (int)6, null);
            } else if (registrationId != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handleAdmRegistrationIntent$lambda$8(registrationId), (int)6, null);
                Braze.Companion.getInstance(context).setRegisteredPushToken(registrationId);
            } else if (unregistered != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> Companion.handleAdmRegistrationIntent$lambda$9(unregistered), (int)6, null);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, Companion::handleAdmRegistrationIntent$lambda$10, (int)6, null);
                return false;
            }
            return true;
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean handlePushNotificationPayload(@NotNull Context context, @NotNull Intent intent) {
            BrazeConfigurationProvider appConfigurationProvider;
            BrazeNotificationPayload payload;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (!BrazeNotificationUtils.isBrazePushMessage(intent)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$11, (int)7, null);
                return false;
            }
            if (Intrinsics.areEqual((Object)BrazePushReceiver.DELETED_MESSAGES_KEY, (Object)intent.getStringExtra(BrazePushReceiver.MESSAGE_TYPE_KEY))) {
                int totalDeleted = intent.getIntExtra(BrazePushReceiver.NUMBER_OF_MESSAGES_DELETED_KEY, -1);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handlePushNotificationPayload$lambda$12(totalDeleted), (int)6, null);
                return false;
            }
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                return false;
            }
            Bundle notificationExtras = bundle;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handlePushNotificationPayload$lambda$13(notificationExtras), (int)6, null);
            Bundle brazeExtras = BrazeNotificationPayload.Companion.getAttachedBrazeExtras(notificationExtras);
            notificationExtras.putBundle("extra", brazeExtras);
            if (!notificationExtras.containsKey("braze_push_received_timestamp")) {
                notificationExtras.putLong("braze_push_received_timestamp", DateTimeUtils.nowInMilliseconds());
            }
            if ((payload = this.createPayload(context, appConfigurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context), notificationExtras, brazeExtras)).isUninstallTrackingPush()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$14, (int)6, null);
                return false;
            }
            String string = payload.getPushUniqueId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!BrazeInternal.INSTANCE.validateAndStorePushId(context, it)) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handlePushNotificationPayload$lambda$16$lambda$15(it), (int)6, null);
                    return false;
                }
            }
            BrazeNotificationUtils.handleContentCardsSerializedCardIfPresent(payload);
            BrazeNotificationUtils.requestGeofenceRefreshIfAppropriate(payload);
            BrazeNotificationUtils.refreshFeatureFlagsIfAppropriate(payload);
            BrazeNotificationUtils.refreshBannersIfAppropriate(payload);
            if (payload.getShouldFetchTestTriggers() && appConfigurationProvider.isInAppMessageTestPushEagerDisplayEnabled() && BrazeInAppMessageManager.Companion.getInstance().getActivity() != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$17, (int)7, null);
                BrazeInternal.handleInAppMessageTestPush((Context)context, (Intent)intent);
                return false;
            }
            if (BrazeNotificationUtils.isNotificationMessage(intent)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$18, (int)7, null);
                int notificationId = BrazeNotificationUtils.getNotificationId(payload);
                notificationExtras.putInt("nid", notificationId);
                if (payload.isPushStory()) {
                    if (Constants.isAmazonDevice()) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$19, (int)7, null);
                        return false;
                    }
                    if (!notificationExtras.containsKey("braze_story_newly_received")) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$20, (int)7, null);
                        notificationExtras.putBoolean("braze_story_newly_received", true);
                    }
                }
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> Companion.handlePushNotificationPayload$lambda$21(payload), (int)6, null);
                Notification notification = BrazeNotificationUtils.getActiveNotificationFactory().createNotification(payload);
                if (notification == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$22, (int)7, null);
                    return false;
                }
                NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
                Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(...)");
                NotificationManagerCompat notificationManager = notificationManagerCompat;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> Companion.handlePushNotificationPayload$lambda$23(notificationManager), (int)7, null);
                if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") == 0) {
                    notificationManager.notify("appboy_notification", notificationId, notification);
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$24, (int)7, null);
                }
                BrazeNotificationUtils.sendPushMessageReceivedBroadcast(context, notificationExtras, payload);
                BrazeNotificationUtils.wakeScreenIfAppropriate(context, appConfigurationProvider, notificationExtras);
                Integer n = payload.getPushDuration();
                if (n != null) {
                    int duration = ((Number)n).intValue();
                    boolean bl = false;
                    BrazeNotificationUtils.setNotificationDurationAlarm(context, BrazePushReceiver.class, notificationId, duration);
                }
                this.logNotificationMetadata$android_sdk_ui_release(context, payload);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, Companion::handlePushNotificationPayload$lambda$26, (int)7, null);
            BrazeNotificationUtils.sendPushMessageReceivedBroadcast(context, notificationExtras, payload);
            return false;
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final BrazeNotificationPayload createPayload(@NotNull Context context, @NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Bundle notificationExtras, @NotNull Bundle brazeExtras) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
            Intrinsics.checkNotNullParameter((Object)notificationExtras, (String)"notificationExtras");
            Intrinsics.checkNotNullParameter((Object)brazeExtras, (String)"brazeExtras");
            return Constants.isAmazonDevice() ? new BrazeNotificationPayload(notificationExtras, BrazeNotificationPayload.Companion.getAttachedBrazeExtras(notificationExtras), context, appConfigurationProvider) : new BrazeNotificationPayload(notificationExtras, brazeExtras, context, appConfigurationProvider);
        }

        @VisibleForTesting
        public final void logNotificationMetadata$android_sdk_ui_release(@NotNull Context context, @NotNull BrazeNotificationPayload payload) {
            block2: {
                String it;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                if (payload.isPushDeliveryEnabled()) {
                    String string = payload.getCampaignId();
                    if (string != null) {
                        it = string;
                        boolean bl = false;
                        long min = RangesKt.coerceAtLeast((long)payload.getFlushMinMinutes(), (long)0L);
                        long max = RangesKt.coerceAtLeast((long)payload.getFlushMaxMinutes(), (long)min);
                        long minToMillis = TimeUnit.MINUTES.toMillis(min);
                        long waitTimeMs = max > min ? Random.Default.nextLong(minToMillis, TimeUnit.MINUTES.toMillis(max)) : minToMillis;
                        BrazeInternal.INSTANCE.logPushDelivery(context, it, waitTimeMs);
                    }
                }
                String string = payload.getCampaignId();
                if (string == null) break block2;
                it = string;
                boolean bl = false;
                BrazeInternal.INSTANCE.logPushCampaign(context, it);
            }
        }

        @JvmStatic
        @JvmOverloads
        public final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            com.braze.push.BrazePushReceiver$Companion.handleReceivedIntent$default(this, context, intent, false, 4, null);
        }

        private static final String handlePush$performWork$lambda$0(Intent $intent) {
            return "Received broadcast message. Message: " + $intent;
        }

        private static final String handlePush$performWork$lambda$1(Intent $intent) {
            return "Push action is null. Not handling intent: " + $intent;
        }

        private static final String handlePush$performWork$lambda$2() {
            return "Received a message not sent from Braze. Ignoring the message.";
        }

        /*
         * Enabled aggressive block sorting
         */
        private static final void handlePush$performWork(String action, Context applicationContext, Intent $intent, Context $context) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> Companion.handlePush$performWork$lambda$0($intent), (int)6, null);
            CharSequence charSequence = action;
            if (charSequence == null || charSequence.length() == 0) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> Companion.handlePush$performWork$lambda$1($intent), (int)6, null);
                return;
            }
            Intrinsics.checkNotNull((Object)applicationContext);
            BrazeInternal.applyPendingRuntimeConfiguration((Context)applicationContext);
            charSequence = action;
            if (charSequence != null) {
                int n = -1;
                switch (((String)charSequence).hashCode()) {
                    case 1740454061: {
                        if (!((String)charSequence).equals(BrazePushReceiver.HMS_PUSH_SERVICE_ROUTING_ACTION)) break;
                        n = 1;
                        break;
                    }
                    case -559929808: {
                        if (!((String)charSequence).equals("com.braze.action.BRAZE_PUSH_DELETED")) break;
                        n = 2;
                        break;
                    }
                    case 34673601: {
                        if (!((String)charSequence).equals("com.braze.action.BRAZE_STORY_CLICKED")) break;
                        n = 3;
                        break;
                    }
                    case -743092218: {
                        if (!((String)charSequence).equals(BrazePushReceiver.ADM_REGISTRATION_INTENT_ACTION)) break;
                        n = 4;
                        break;
                    }
                    case -2147185193: {
                        if (!((String)charSequence).equals("com.braze.action.CANCEL_NOTIFICATION")) break;
                        n = 5;
                        break;
                    }
                    case 1060266838: {
                        if (!((String)charSequence).equals(BrazePushReceiver.ADM_RECEIVE_INTENT_ACTION)) break;
                        n = 1;
                        break;
                    }
                    case -711830027: {
                        if (!((String)charSequence).equals("com.braze.action.STORY_TRAVERSE")) break;
                        n = 1;
                        break;
                    }
                    case -1799205286: {
                        if (!((String)charSequence).equals("com.braze.action.BRAZE_ACTION_CLICKED")) break;
                        n = 6;
                        break;
                    }
                    case -1584985748: {
                        if (!((String)charSequence).equals(BrazePushReceiver.FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION)) break;
                        n = 1;
                        break;
                    }
                    case -1249868226: {
                        if (!((String)charSequence).equals("com.braze.action.BRAZE_PUSH_CLICKED")) break;
                        n = 7;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Companion.handlePushNotificationPayload(applicationContext, $intent);
                        return;
                    }
                    case 4: {
                        Companion.handleAdmRegistrationEventIfEnabled(new BrazeConfigurationProvider(applicationContext), applicationContext, $intent);
                        return;
                    }
                    case 5: {
                        BrazeNotificationUtils.handleCancelNotificationAction(applicationContext, $intent);
                        return;
                    }
                    case 2: {
                        BrazeNotificationUtils.handleNotificationDeleted(applicationContext, $intent);
                        return;
                    }
                    case 3: {
                        BrazeNotificationUtils.handlePushStoryPageClicked($context, $intent);
                        return;
                    }
                    case 6: {
                        BrazeNotificationActionUtils.handleNotificationActionClicked($context, $intent);
                        return;
                    }
                    case 7: {
                        BrazeNotificationUtils.handleNotificationOpened($context, $intent);
                        return;
                    }
                }
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, Companion::handlePush$performWork$lambda$2, (int)6, null);
        }

        private static final String handlePush$lambda$3(String $action, Intent $intent) {
            return "Caught exception while performing the push notification handling work. Action: " + $action + " Intent: " + $intent;
        }

        private static final String handleAdmRegistrationEventIfEnabled$lambda$4(Intent $intent) {
            return "Received ADM registration. Message: " + $intent;
        }

        private static final String handleAdmRegistrationEventIfEnabled$lambda$5() {
            return "ADM enabled in braze.xml. Continuing to process ADM registration intent.";
        }

        private static final String handleAdmRegistrationEventIfEnabled$lambda$6() {
            return "ADM not enabled in braze.xml. Ignoring ADM registration intent. Note: you must set com_braze_push_adm_messaging_registration_enabled to true in your braze.xml to enable ADM.";
        }

        private static final String handleAdmRegistrationIntent$lambda$7(String $error, String $errorDescription) {
            return "Error during ADM registration: " + $error + " description: " + $errorDescription;
        }

        private static final String handleAdmRegistrationIntent$lambda$8(String $registrationId) {
            return "Registering for ADM messages with registrationId: " + $registrationId;
        }

        private static final String handleAdmRegistrationIntent$lambda$9(String $unregistered) {
            return "The device was un-registered from ADM: " + $unregistered;
        }

        private static final String handleAdmRegistrationIntent$lambda$10() {
            return "The ADM registration intent is missing error information, registration id, and unregistration confirmation. Ignoring.";
        }

        private static final String handlePushNotificationPayload$lambda$11() {
            return "Not handling non-Braze push message.";
        }

        private static final String handlePushNotificationPayload$lambda$12(int $totalDeleted) {
            return "Firebase messaging 'total_deleted' reports " + $totalDeleted + " messages.";
        }

        private static final String handlePushNotificationPayload$lambda$13(Bundle $notificationExtras) {
            return "Push message payload received: " + $notificationExtras;
        }

        private static final String handlePushNotificationPayload$lambda$14() {
            return "Push message is uninstall tracking push. Doing nothing. Not forwarding this notification to broadcast receivers.";
        }

        private static final String handlePushNotificationPayload$lambda$16$lambda$15(String $it) {
            return "Push with identifier '" + $it + "' has already been seen. Not displaying or forwarding push.";
        }

        private static final String handlePushNotificationPayload$lambda$17() {
            return "Bypassing push display due to test in-app message presence and eager test in-app message display configuration setting.";
        }

        private static final String handlePushNotificationPayload$lambda$18() {
            return "Received visible push notification";
        }

        private static final String handlePushNotificationPayload$lambda$19() {
            return "Push stories not supported on Amazon devices.";
        }

        private static final String handlePushNotificationPayload$lambda$20() {
            return "Received the initial Push Story notification.";
        }

        private static final String handlePushNotificationPayload$lambda$21(BrazeNotificationPayload $payload) {
            return "Creating notification with payload:\n" + $payload;
        }

        private static final String handlePushNotificationPayload$lambda$22() {
            return "Notification created by notification factory was null. Not displaying notification.";
        }

        private static final String handlePushNotificationPayload$lambda$23(NotificationManagerCompat $notificationManager) {
            return "Value of notificationManager.areNotificationsEnabled() = " + $notificationManager.areNotificationsEnabled();
        }

        private static final String handlePushNotificationPayload$lambda$24() {
            return "POST_NOTIFICATIONS permission has not been granted. Not posting notification.";
        }

        private static final String handlePushNotificationPayload$lambda$26() {
            return "Received silent push notification";
        }

        public static final /* synthetic */ void access$handlePush(Companion $this, Context context, Intent intent) {
            $this.handlePush(context, intent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

