/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ListFragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.braze.Braze;
import com.braze.IBraze;
import com.braze.enums.CardCategory;
import com.braze.events.FeedUpdatedEvent;
import com.braze.events.IEventSubscriber;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.ui.R;
import com.braze.ui.adapters.BrazeListAdapter;
import java.util.ArrayList;
import java.util.EnumSet;

public class BrazeXamarinFormsFeedFragment
extends ListFragment
implements SwipeRefreshLayout.OnRefreshListener {
    private static final String TAG = BrazeLogger.getBrazeLogTag(BrazeXamarinFormsFeedFragment.class);
    private static final int NETWORK_PROBLEM_WARNING_MS = 5000;
    private static final int MAX_FEED_TTL_SECONDS = 60;
    private static final long AUTO_HIDE_REFRESH_INDICATOR_DELAY_MS = 2500L;
    private final Handler mMainThreadLooper = new Handler(Looper.getMainLooper());
    private final Runnable mShowNetworkError = new Runnable(){

        @Override
        public void run() {
            if (BrazeXamarinFormsFeedFragment.this.mLoadingSpinner != null) {
                BrazeXamarinFormsFeedFragment.this.mLoadingSpinner.setVisibility(8);
            }
            if (BrazeXamarinFormsFeedFragment.this.mNetworkErrorLayout != null) {
                BrazeXamarinFormsFeedFragment.this.mNetworkErrorLayout.setVisibility(0);
            }
        }
    };
    private IBraze mBraze;
    private IEventSubscriber<FeedUpdatedEvent> mFeedUpdatedSubscriber;
    private BrazeListAdapter mAdapter;
    private LinearLayout mNetworkErrorLayout;
    private LinearLayout mEmptyFeedLayout;
    private ProgressBar mLoadingSpinner;
    private RelativeLayout mFeedRootLayout;
    private boolean mSkipCardImpressionsReset;
    private EnumSet<CardCategory> mCategories;
    private SwipeRefreshLayout mFeedSwipeLayout;
    private int previousVisibleHeadCardIndex;
    private int currentCardIndexAtBottomOfScreen;
    private GestureDetector mGestureDetector;
    private View mTransparentFullBoundsContainerView;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mBraze = Braze.getInstance((Context)context);
        if (this.mAdapter == null) {
            this.mAdapter = new BrazeListAdapter(context, R.id.tag, new ArrayList<Card>());
            this.mCategories = CardCategory.getAllCategories();
        }
        this.setRetainInstance(true);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new FeedGestureListener());
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup container, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.com_braze_feed, container, false);
        this.mNetworkErrorLayout = (LinearLayout)view.findViewById(R.id.com_braze_feed_network_error);
        this.mLoadingSpinner = (ProgressBar)view.findViewById(R.id.com_braze_feed_loading_spinner);
        this.mEmptyFeedLayout = (LinearLayout)view.findViewById(R.id.com_braze_feed_empty_feed);
        this.mFeedRootLayout = (RelativeLayout)view.findViewById(R.id.com_braze_feed_root);
        this.mFeedSwipeLayout = (SwipeRefreshLayout)view.findViewById(R.id.braze_feed_swipe_container);
        this.mFeedSwipeLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.mFeedSwipeLayout.setEnabled(false);
        this.mFeedSwipeLayout.setColorSchemeResources(new int[]{R.color.com_braze_newsfeed_swipe_refresh_color_1, R.color.com_braze_newsfeed_swipe_refresh_color_2, R.color.com_braze_newsfeed_swipe_refresh_color_3, R.color.com_braze_newsfeed_swipe_refresh_color_4});
        this.mTransparentFullBoundsContainerView = view.findViewById(R.id.com_braze_feed_transparent_full_bounds_container_view);
        return view;
    }

    @SuppressLint(value={"InflateParams"})
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.mSkipCardImpressionsReset) {
            this.mSkipCardImpressionsReset = false;
        } else {
            this.mAdapter.resetCardImpressionTracker();
            BrazeLogger.d((String)TAG, (String)"Resetting card impressions.");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        ListView listView = this.getListView();
        listView.addHeaderView(inflater.inflate(R.layout.com_braze_feed_header, null));
        listView.addFooterView(inflater.inflate(R.layout.com_braze_feed_footer, null));
        this.mFeedRootLayout.setOnTouchListener((view, motionEvent) -> this.mGestureDetector.onTouchEvent(motionEvent));
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
            }

            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                BrazeXamarinFormsFeedFragment.this.mFeedSwipeLayout.setEnabled(firstVisibleItem == 0);
                if (visibleItemCount == 0) {
                    return;
                }
                int currentVisibleHeadCardIndex = firstVisibleItem - 1;
                if (currentVisibleHeadCardIndex > BrazeXamarinFormsFeedFragment.this.previousVisibleHeadCardIndex) {
                    BrazeXamarinFormsFeedFragment.this.mAdapter.batchSetCardsToRead(BrazeXamarinFormsFeedFragment.this.previousVisibleHeadCardIndex, currentVisibleHeadCardIndex);
                }
                BrazeXamarinFormsFeedFragment.this.previousVisibleHeadCardIndex = currentVisibleHeadCardIndex;
                BrazeXamarinFormsFeedFragment.this.currentCardIndexAtBottomOfScreen = firstVisibleItem + visibleItemCount;
            }
        });
        this.mTransparentFullBoundsContainerView.setOnTouchListener((view, motionEvent) -> view.getVisibility() == 0);
        this.mBraze.removeSingleSubscription(this.mFeedUpdatedSubscriber, FeedUpdatedEvent.class);
        this.mFeedUpdatedSubscriber = event -> {
            Activity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            activity.runOnUiThread(() -> {
                BrazeLogger.d((String)TAG, (String)("Updating feed views in response to FeedUpdatedEvent: " + event));
                this.mMainThreadLooper.removeCallbacks(this.mShowNetworkError);
                this.mNetworkErrorLayout.setVisibility(8);
                if (event.getCardCount(this.mCategories) == 0) {
                    listView.setVisibility(8);
                    this.mAdapter.clear();
                } else {
                    this.mEmptyFeedLayout.setVisibility(8);
                    this.mLoadingSpinner.setVisibility(8);
                    this.mTransparentFullBoundsContainerView.setVisibility(8);
                }
                if (event.isFromOfflineStorage() && (event.lastUpdatedInSecondsFromEpoch() + 60L) * 1000L < DateTimeUtils.nowInMilliseconds()) {
                    BrazeLogger.i((String)TAG, (String)"Feed received was older than the max time to live of 60 seconds, displaying it for now, but requesting an updated view from the server.");
                    this.mBraze.requestFeedRefresh();
                    if (event.getCardCount(this.mCategories) == 0) {
                        BrazeLogger.d((String)TAG, (String)"Old feed was empty, putting up a network spinner and registering the network error message on a delay of 5000ms.");
                        this.mEmptyFeedLayout.setVisibility(8);
                        this.mLoadingSpinner.setVisibility(0);
                        this.mTransparentFullBoundsContainerView.setVisibility(0);
                        this.mMainThreadLooper.postDelayed(this.mShowNetworkError, 5000L);
                        return;
                    }
                }
                if (event.getCardCount(this.mCategories) == 0) {
                    this.mLoadingSpinner.setVisibility(8);
                    this.mEmptyFeedLayout.setVisibility(0);
                    this.mTransparentFullBoundsContainerView.setVisibility(0);
                } else {
                    this.mAdapter.replaceFeed(event.getFeedCards(this.mCategories));
                    listView.setVisibility(0);
                }
                this.mFeedSwipeLayout.setRefreshing(false);
            });
        };
        this.mBraze.subscribeToFeedUpdates(this.mFeedUpdatedSubscriber);
        listView.setAdapter((ListAdapter)this.mAdapter);
        this.mBraze.requestFeedRefreshFromCache();
    }

    public void onResume() {
        super.onResume();
        Braze.getInstance((Context)this.getActivity()).logFeedDisplayed();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mBraze.removeSingleSubscription(this.mFeedUpdatedSubscriber, FeedUpdatedEvent.class);
        this.setOnScreenCardsToRead();
    }

    public void onPause() {
        super.onPause();
        this.setOnScreenCardsToRead();
    }

    private void setOnScreenCardsToRead() {
        this.mAdapter.batchSetCardsToRead(this.previousVisibleHeadCardIndex, this.currentCardIndexAtBottomOfScreen);
    }

    public void onDetach() {
        super.onDetach();
        this.setListAdapter(null);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.isVisible()) {
            this.mSkipCardImpressionsReset = true;
        }
    }

    public EnumSet<CardCategory> getCategories() {
        return this.mCategories;
    }

    public void setCategory(CardCategory category) {
        this.setCategories(EnumSet.of(category));
    }

    public void setCategories(EnumSet<CardCategory> categories) {
        if (categories == null) {
            BrazeLogger.i((String)TAG, (String)"The categories passed into setCategories are null, BrazeFeedFragment is going to display all the cards in cache.");
            this.mCategories = CardCategory.getAllCategories();
        } else {
            if (categories.isEmpty()) {
                BrazeLogger.w((String)TAG, (String)"The categories set had no elements and have been ignored. Please pass a valid EnumSet of CardCategory.");
                return;
            }
            if (categories.equals(this.mCategories)) {
                return;
            }
            this.mCategories = categories;
        }
        if (this.mBraze != null) {
            this.mBraze.requestFeedRefreshFromCache();
        }
    }

    public void onRefresh() {
        this.mBraze.requestFeedRefresh();
        this.mMainThreadLooper.postDelayed(() -> this.mFeedSwipeLayout.setRefreshing(false), 2500L);
    }

    public class FeedGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float dx, float dy) {
            BrazeXamarinFormsFeedFragment.this.getListView().smoothScrollBy((int)dy, 0);
            return true;
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float velocityX, float velocityY) {
            long deltaTimeMillis = (motionEvent2.getEventTime() - motionEvent.getEventTime()) * 2L;
            int scrollDistance = (int)(velocityY * (float)deltaTimeMillis / 1000.0f);
            BrazeXamarinFormsFeedFragment.this.getListView().smoothScrollBy(-scrollDistance, (int)(deltaTimeMillis * 2L));
            return true;
        }
    }
}

