/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui;

import android.content.Context;
import android.webkit.JavascriptInterface;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.models.outgoing.BrazeProperties;
import com.braze.support.BrazeLogger;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH'J\b\u0010\f\u001a\u00020\tH'J\u001a\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010\u0010\u001a\u00020\tH\u0007J\u001c\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0007J6\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/braze/ui/JavascriptInterfaceBase;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "logButtonClick", "", "buttonId", "", "logClick", "changeUser", "userId", "sdkAuthSignature", "requestImmediateDataFlush", "logCustomEventWithJSON", "eventName", "propertiesJSON", "logPurchaseWithJSON", "productId", "price", "currencyCode", "quantity", "parseProperties", "Lcom/braze/models/outgoing/BrazeProperties;", "android-sdk-ui_release"})
public abstract class JavascriptInterfaceBase {
    @NotNull
    private final Context context;

    public JavascriptInterfaceBase(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @JavascriptInterface
    public abstract void logButtonClick(@Nullable String var1);

    @JavascriptInterface
    public abstract void logClick();

    @JavascriptInterface
    public final void changeUser(@NotNull String userId, @Nullable String sdkAuthSignature) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Braze.Companion.getInstance(this.context).changeUser(userId, sdkAuthSignature);
    }

    @JavascriptInterface
    public final void requestImmediateDataFlush() {
        Braze.Companion.getInstance(this.context).requestImmediateDataFlush();
    }

    @JavascriptInterface
    public final void logCustomEventWithJSON(@Nullable String eventName, @Nullable String propertiesJSON) {
        BrazeProperties brazeProperties = this.parseProperties(propertiesJSON);
        Braze.Companion.getInstance(this.context).logCustomEvent(eventName, brazeProperties);
    }

    @JavascriptInterface
    public final void logPurchaseWithJSON(@Nullable String productId, @NotNull String price, @Nullable String currencyCode, @NotNull String quantity, @Nullable String propertiesJSON) {
        Intrinsics.checkNotNullParameter((Object)price, (String)"price");
        Intrinsics.checkNotNullParameter((Object)quantity, (String)"quantity");
        BrazeProperties brazeProperties = this.parseProperties(propertiesJSON);
        Double priceValue = StringsKt.toDoubleOrNull((String)price);
        if (priceValue == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> JavascriptInterfaceBase.logPurchaseWithJSON$lambda$0(price), (int)6, null);
            return;
        }
        Integer quantityValue = StringsKt.toIntOrNull((String)quantity);
        if (quantityValue == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> JavascriptInterfaceBase.logPurchaseWithJSON$lambda$1(quantity), (int)6, null);
            return;
        }
        Braze.Companion.getInstance(this.context).logPurchase(productId, currencyCode, new BigDecimal(priceValue.toString()), quantityValue.intValue(), brazeProperties);
    }

    @VisibleForTesting
    @Nullable
    public final BrazeProperties parseProperties(@Nullable String propertiesJSON) {
        try {
            if (propertiesJSON != null && !Intrinsics.areEqual((Object)propertiesJSON, (Object)"undefined") && !Intrinsics.areEqual((Object)propertiesJSON, (Object)"null")) {
                return new BrazeProperties(new JSONObject(propertiesJSON));
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> JavascriptInterfaceBase.parseProperties$lambda$2(propertiesJSON), (int)4, null);
        }
        return null;
    }

    private static final String logPurchaseWithJSON$lambda$0(String $price) {
        return "Failed to parse logPurchaseWithJSON price value '" + $price + '\'';
    }

    private static final String logPurchaseWithJSON$lambda$1(String $quantity) {
        return "Failed to parse logPurchaseWithJSON quantity value '" + $quantity + '\'';
    }

    private static final String parseProperties$lambda$2(String $propertiesJSON) {
        return "Failed to parse properties JSON String: " + $propertiesJSON;
    }
}

