/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.contentcards.adapters;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.contentcards.handlers.IContentCardsViewBindingHandler;
import com.braze.ui.contentcards.listeners.IContentCardsActionListener;
import com.braze.ui.contentcards.managers.BrazeContentCardsManager;
import com.braze.ui.contentcards.recycler.ItemTouchHelperAdapter;
import com.braze.ui.contentcards.view.ContentCardViewHolder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\r\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00018B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0014\u0010-\u001a\u00020 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\u0015J\u0006\u0010/\u001a\u00020 J\u000e\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u001eJ\u0012\u00102\u001a\u0004\u0018\u00010\n2\u0006\u00103\u001a\u00020\u001eH\u0007J\u0010\u00104\u001a\u00020'2\u0006\u00101\u001a\u00020\u001eH\u0007J\u0012\u00105\u001a\u00020 2\b\u00106\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u00107\u001a\u00020'2\u0006\u00103\u001a\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00069"}, d2={"Lcom/braze/ui/contentcards/adapters/ContentCardAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/braze/ui/contentcards/view/ContentCardViewHolder;", "Lcom/braze/ui/contentcards/recycler/ItemTouchHelperAdapter;", "context", "Landroid/content/Context;", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "cardData", "", "Lcom/braze/models/cards/Card;", "contentCardsViewBindingHandler", "Lcom/braze/ui/contentcards/handlers/IContentCardsViewBindingHandler;", "<init>", "(Landroid/content/Context;Landroidx/recyclerview/widget/LinearLayoutManager;Ljava/util/List;Lcom/braze/ui/contentcards/handlers/IContentCardsViewBindingHandler;)V", "handler", "Landroid/os/Handler;", "impressedCardIdsInternal", "", "", "impressedCardIds", "", "getImpressedCardIds", "()Ljava/util/List;", "setImpressedCardIds", "(Ljava/util/List;)V", "onCreateViewHolder", "viewGroup", "Landroid/view/ViewGroup;", "viewType", "", "onBindViewHolder", "", "viewHolder", "position", "getItemViewType", "getItemCount", "onItemDismiss", "isItemDismissable", "", "onViewAttachedToWindow", "holder", "onViewDetachedFromWindow", "getItemId", "", "replaceCards", "newCardData", "markOnScreenCardsAsRead", "isControlCardAtPosition", "adapterPosition", "getCardAtIndex", "index", "isAdapterPositionOnScreen", "logImpression", "card", "isInvalidIndex", "CardListDiffCallback", "android-sdk-ui_release"})
public class ContentCardAdapter
extends RecyclerView.Adapter<ContentCardViewHolder>
implements ItemTouchHelperAdapter {
    @NotNull
    private final Context context;
    @NotNull
    private final LinearLayoutManager layoutManager;
    @NotNull
    private final List<Card> cardData;
    @NotNull
    private final IContentCardsViewBindingHandler contentCardsViewBindingHandler;
    @NotNull
    private final Handler handler;
    @NotNull
    private Set<String> impressedCardIdsInternal;

    public ContentCardAdapter(@NotNull Context context, @NotNull LinearLayoutManager layoutManager, @NotNull List<Card> cardData, @NotNull IContentCardsViewBindingHandler contentCardsViewBindingHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)layoutManager, (String)"layoutManager");
        Intrinsics.checkNotNullParameter(cardData, (String)"cardData");
        Intrinsics.checkNotNullParameter((Object)contentCardsViewBindingHandler, (String)"contentCardsViewBindingHandler");
        this.context = context;
        this.layoutManager = layoutManager;
        this.cardData = cardData;
        this.contentCardsViewBindingHandler = contentCardsViewBindingHandler;
        this.handler = new Handler(Looper.getMainLooper());
        this.impressedCardIdsInternal = new LinkedHashSet();
        this.setHasStableIds(true);
    }

    @NotNull
    public final List<String> getImpressedCardIds() {
        return CollectionsKt.toList((Iterable)this.impressedCardIdsInternal);
    }

    public final void setImpressedCardIds(@NotNull List<String> impressedCardIds) {
        Intrinsics.checkNotNullParameter(impressedCardIds, (String)"impressedCardIds");
        this.impressedCardIdsInternal = CollectionsKt.toMutableSet((Iterable)impressedCardIds);
    }

    @NotNull
    public ContentCardViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int viewType) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        return this.contentCardsViewBindingHandler.onCreateViewHolder(this.context, this.cardData, viewGroup, viewType);
    }

    public void onBindViewHolder(@NotNull ContentCardViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        this.contentCardsViewBindingHandler.onBindViewHolder(this.context, this.cardData, viewHolder, position);
    }

    public int getItemViewType(int position) {
        return this.contentCardsViewBindingHandler.getItemViewType(this.context, this.cardData, position);
    }

    public int getItemCount() {
        return this.cardData.size();
    }

    @Override
    public void onItemDismiss(int position) {
        block1: {
            if (this.isInvalidIndex(position)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> ContentCardAdapter.onItemDismiss$lambda$0(position, this), (int)7, null);
                return;
            }
            Card removedCard = this.cardData.remove(position);
            removedCard.setDismissed(true);
            this.notifyItemRemoved(position);
            IContentCardsActionListener iContentCardsActionListener = BrazeContentCardsManager.Companion.getInstance().getContentCardsActionListener();
            if (iContentCardsActionListener == null) break block1;
            iContentCardsActionListener.onContentCardDismissed(this.context, removedCard);
        }
    }

    @Override
    public boolean isItemDismissable(int position) {
        return this.cardData.isEmpty() || this.isInvalidIndex(position) ? false : this.cardData.get(position).isDismissibleByUser();
    }

    public void onViewAttachedToWindow(@NotNull ContentCardViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        if (this.cardData.isEmpty()) {
            return;
        }
        int adapterPosition = holder.getBindingAdapterPosition();
        if (adapterPosition == -1 || !this.isAdapterPositionOnScreen(adapterPosition)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> ContentCardAdapter.onViewAttachedToWindow$lambda$1(adapterPosition), (int)6, null);
            return;
        }
        this.logImpression(this.getCardAtIndex(adapterPosition));
    }

    public void onViewDetachedFromWindow(@NotNull ContentCardViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        if (this.cardData.isEmpty()) {
            return;
        }
        int adapterPosition = holder.getBindingAdapterPosition();
        if (adapterPosition == -1 || !this.isAdapterPositionOnScreen(adapterPosition)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> ContentCardAdapter.onViewDetachedFromWindow$lambda$2(adapterPosition), (int)6, null);
            return;
        }
        Card card = this.getCardAtIndex(adapterPosition);
        if (card == null) {
            return;
        }
        Card cardAtPosition = card;
        if (!cardAtPosition.isIndicatorHighlighted()) {
            cardAtPosition.setIndicatorHighlighted(true);
            this.handler.post(() -> ContentCardAdapter.onViewDetachedFromWindow$lambda$3(this, adapterPosition));
        }
    }

    public long getItemId(int position) {
        Card card = this.getCardAtIndex(position);
        Object object = card;
        return object != null && (object = object.getId()) != null ? (long)((String)object).hashCode() : 0L;
    }

    public final synchronized void replaceCards(@NotNull List<? extends Card> newCardData) {
        Intrinsics.checkNotNullParameter(newCardData, (String)"newCardData");
        CardListDiffCallback diffCallback = new CardListDiffCallback(this.cardData, newCardData);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(...)");
        DiffUtil.DiffResult diffResult2 = diffResult;
        this.cardData.clear();
        this.cardData.addAll((Collection<Card>)newCardData);
        diffResult2.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    public final void markOnScreenCardsAsRead() {
        if (this.cardData.isEmpty()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, ContentCardAdapter::markOnScreenCardsAsRead$lambda$4, (int)7, null);
            return;
        }
        int firstVisibleIndex = this.layoutManager.findFirstVisibleItemPosition();
        int lastVisibleIndex = this.layoutManager.findLastVisibleItemPosition();
        if (firstVisibleIndex < 0 || lastVisibleIndex < 0) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> ContentCardAdapter.markOnScreenCardsAsRead$lambda$5(firstVisibleIndex, lastVisibleIndex), (int)7, null);
            return;
        }
        int i = firstVisibleIndex;
        if (i <= lastVisibleIndex) {
            while (true) {
                Card card;
                if ((card = this.getCardAtIndex(i)) != null) {
                    card.setIndicatorHighlighted(true);
                }
                if (i == lastVisibleIndex) break;
                ++i;
            }
        }
        this.handler.post(() -> ContentCardAdapter.markOnScreenCardsAsRead$lambda$6(lastVisibleIndex, firstVisibleIndex, this));
    }

    public final boolean isControlCardAtPosition(int adapterPosition) {
        Card card = this.getCardAtIndex(adapterPosition);
        return card != null && card.isControl();
    }

    @VisibleForTesting
    @Nullable
    public final Card getCardAtIndex(int index) {
        if (this.isInvalidIndex(index)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> ContentCardAdapter.getCardAtIndex$lambda$7(index, this), (int)7, null);
            return null;
        }
        return this.cardData.get(index);
    }

    @VisibleForTesting
    public final boolean isAdapterPositionOnScreen(int adapterPosition) {
        int firstItemPosition = Math.min(this.layoutManager.findFirstVisibleItemPosition(), this.layoutManager.findFirstCompletelyVisibleItemPosition());
        int lastItemPosition = Math.max(this.layoutManager.findLastVisibleItemPosition(), this.layoutManager.findLastCompletelyVisibleItemPosition());
        return firstItemPosition <= adapterPosition ? adapterPosition <= lastItemPosition : false;
    }

    @VisibleForTesting
    public final void logImpression(@Nullable Card card) {
        if (card == null) {
            return;
        }
        if (!this.impressedCardIdsInternal.contains(card.getId())) {
            card.logImpression();
            this.impressedCardIdsInternal.add(card.getId());
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> ContentCardAdapter.logImpression$lambda$8(card), (int)6, null);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> ContentCardAdapter.logImpression$lambda$9(card), (int)6, null);
        }
        if (!card.getViewed()) {
            card.setViewed(true);
        }
    }

    private final boolean isInvalidIndex(int index) {
        return index < 0 || index >= this.cardData.size();
    }

    private static final String onItemDismiss$lambda$0(int $position, ContentCardAdapter this$0) {
        return "Cannot dismiss card at index: " + $position + " in cards list of size: " + this$0.cardData.size();
    }

    private static final String onViewAttachedToWindow$lambda$1(int $adapterPosition) {
        return "The card at position " + $adapterPosition + " isn't on screen or does not have a valid adapter position. Not logging impression.";
    }

    private static final String onViewDetachedFromWindow$lambda$2(int $adapterPosition) {
        return "The card at position " + $adapterPosition + " isn't on screen or does not have a valid adapter position. Not marking as read.";
    }

    private static final void onViewDetachedFromWindow$lambda$3(ContentCardAdapter this$0, int $adapterPosition) {
        this$0.notifyItemChanged($adapterPosition);
    }

    private static final String markOnScreenCardsAsRead$lambda$4() {
        return "Card list is empty. Not marking on-screen cards as read.";
    }

    private static final String markOnScreenCardsAsRead$lambda$5(int $firstVisibleIndex, int $lastVisibleIndex) {
        return "Not marking all on-screen cards as read. Either the first or last index is negative. First visible: " + $firstVisibleIndex + " . Last visible: " + $lastVisibleIndex;
    }

    private static final void markOnScreenCardsAsRead$lambda$6(int $lastVisibleIndex, int $firstVisibleIndex, ContentCardAdapter this$0) {
        int itemsChangedCount = $lastVisibleIndex - $firstVisibleIndex + 1;
        this$0.notifyItemRangeChanged($firstVisibleIndex, itemsChangedCount);
    }

    private static final String getCardAtIndex$lambda$7(int $index, ContentCardAdapter this$0) {
        return "Cannot return card at index: " + $index + " in cards list of size: " + this$0.cardData.size();
    }

    private static final String logImpression$lambda$8(Card $card) {
        return "Logged impression for card " + $card.getId();
    }

    private static final String logImpression$lambda$9(Card $card) {
        return "Already counted impression for card " + $card.getId();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/braze/ui/contentcards/adapters/ContentCardAdapter$CardListDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldCards", "", "Lcom/braze/models/cards/Card;", "newCards", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getOldListSize", "", "getNewListSize", "areItemsTheSame", "", "oldItemPosition", "newItemPosition", "areContentsTheSame", "doItemsShareIds", "android-sdk-ui_release"})
    private static final class CardListDiffCallback
    extends DiffUtil.Callback {
        @NotNull
        private final List<Card> oldCards;
        @NotNull
        private final List<Card> newCards;

        public CardListDiffCallback(@NotNull List<? extends Card> oldCards, @NotNull List<? extends Card> newCards) {
            Intrinsics.checkNotNullParameter(oldCards, (String)"oldCards");
            Intrinsics.checkNotNullParameter(newCards, (String)"newCards");
            this.oldCards = oldCards;
            this.newCards = newCards;
        }

        public int getOldListSize() {
            return this.oldCards.size();
        }

        public int getNewListSize() {
            return this.newCards.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return this.doItemsShareIds(oldItemPosition, newItemPosition);
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return this.doItemsShareIds(oldItemPosition, newItemPosition);
        }

        private final boolean doItemsShareIds(int oldItemPosition, int newItemPosition) {
            return Intrinsics.areEqual((Object)this.oldCards.get(oldItemPosition).getId(), (Object)this.newCards.get(newItemPosition).getId());
        }
    }
}

