/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.contentcards.handlers;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.ViewGroup;
import androidx.annotation.VisibleForTesting;
import com.braze.enums.CardType;
import com.braze.models.cards.Card;
import com.braze.ui.contentcards.handlers.IContentCardsViewBindingHandler;
import com.braze.ui.contentcards.view.BaseContentCardView;
import com.braze.ui.contentcards.view.CaptionedImageContentCardView;
import com.braze.ui.contentcards.view.ContentCardViewHolder;
import com.braze.ui.contentcards.view.DefaultContentCardView;
import com.braze.ui.contentcards.view.ImageOnlyContentCardView;
import com.braze.ui.contentcards.view.ShortNewsContentCardView;
import com.braze.ui.contentcards.view.TextAnnouncementContentCardView;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J&\u0010\u0017\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u001c\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0007J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/braze/ui/contentcards/handlers/DefaultContentCardsViewBindingHandler;", "Lcom/braze/ui/contentcards/handlers/IContentCardsViewBindingHandler;", "<init>", "()V", "contentCardViewCache", "", "Lcom/braze/enums/CardType;", "Lcom/braze/ui/contentcards/view/BaseContentCardView;", "onCreateViewHolder", "Lcom/braze/ui/contentcards/view/ContentCardViewHolder;", "context", "Landroid/content/Context;", "cards", "", "Lcom/braze/models/cards/Card;", "viewGroup", "Landroid/view/ViewGroup;", "viewType", "", "onBindViewHolder", "", "viewHolder", "adapterPosition", "getItemViewType", "getContentCardsViewFromCache", "cardType", "describeContents", "writeToParcel", "dest", "Landroid/os/Parcel;", "flags", "Companion", "android-sdk-ui_release"})
public class DefaultContentCardsViewBindingHandler
implements IContentCardsViewBindingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<CardType, BaseContentCardView<?>> contentCardViewCache = new LinkedHashMap();
    @JvmField
    @NotNull
    public static final Parcelable.Creator<DefaultContentCardsViewBindingHandler> CREATOR = (Parcelable.Creator)new Parcelable.Creator<DefaultContentCardsViewBindingHandler>(){

        public DefaultContentCardsViewBindingHandler createFromParcel(Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new DefaultContentCardsViewBindingHandler();
        }

        public DefaultContentCardsViewBindingHandler[] newArray(int size) {
            return new DefaultContentCardsViewBindingHandler[size];
        }
    };

    @Override
    @NotNull
    public ContentCardViewHolder onCreateViewHolder(@NotNull Context context, @NotNull List<? extends Card> cards, @NotNull ViewGroup viewGroup, int viewType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(cards, (String)"cards");
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        CardType cardType = CardType.Companion.fromValue(viewType);
        return this.getContentCardsViewFromCache(context, cardType).createViewHolder(viewGroup);
    }

    @Override
    public void onBindViewHolder(@NotNull Context context, @NotNull List<? extends Card> cards, @NotNull ContentCardViewHolder viewHolder, int adapterPosition) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(cards, (String)"cards");
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        if (adapterPosition < 0 || adapterPosition >= cards.size()) {
            return;
        }
        Card cardAtPosition = cards.get(adapterPosition);
        BaseContentCardView<?> contentCardView = this.getContentCardsViewFromCache(context, cardAtPosition.getCardType());
        contentCardView.bindViewHolder(viewHolder, cardAtPosition);
    }

    @Override
    public int getItemViewType(@NotNull Context context, @NotNull List<? extends Card> cards, int adapterPosition) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(cards, (String)"cards");
        if (adapterPosition < 0 || adapterPosition >= cards.size()) {
            return -1;
        }
        Card card = cards.get(adapterPosition);
        return card.getCardType().getValue();
    }

    @VisibleForTesting
    @NotNull
    public final BaseContentCardView<?> getContentCardsViewFromCache(@NotNull Context context, @NotNull CardType cardType) {
        BaseContentCardView baseContentCardView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cardType, (String)"cardType");
        if (!this.contentCardViewCache.containsKey(cardType) || this.contentCardViewCache.get(cardType) == null) {
            BaseContentCardView baseContentCardView2;
            switch (WhenMappings.$EnumSwitchMapping$0[cardType.ordinal()]) {
                case 1: {
                    baseContentCardView2 = new ImageOnlyContentCardView(context);
                    break;
                }
                case 2: {
                    baseContentCardView2 = new CaptionedImageContentCardView(context);
                    break;
                }
                case 3: {
                    baseContentCardView2 = new ShortNewsContentCardView(context);
                    break;
                }
                case 4: {
                    baseContentCardView2 = new TextAnnouncementContentCardView(context);
                    break;
                }
                default: {
                    baseContentCardView2 = new DefaultContentCardView(context);
                }
            }
            BaseContentCardView contentCardView = baseContentCardView2;
            this.contentCardViewCache.put(cardType, contentCardView);
        }
        if ((baseContentCardView = this.contentCardViewCache.get(cardType)) == null) {
            baseContentCardView = new DefaultContentCardView(context);
        }
        return baseContentCardView;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/braze/ui/contentcards/handlers/DefaultContentCardsViewBindingHandler$Companion;", "", "<init>", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/braze/ui/contentcards/handlers/DefaultContentCardsViewBindingHandler;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CardType.values().length];
            try {
                nArray[CardType.IMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.CAPTIONED_IMAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.SHORT_NEWS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.TEXT_ANNOUNCEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

