/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.actions;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.braze.BrazeInternal;
import com.braze.IBrazeDeeplinkHandler;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.Channel;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.BrazeWebViewActivity;
import com.braze.ui.actions.IAction;
import com.braze.ui.actions.brazeactions.BrazeActionParser;
import com.braze.ui.support.UriUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\"\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\"\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\"\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0014J\"\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0004J\"\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0005J5\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0007\u00a2\u0006\u0002\u0010*R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/braze/ui/actions/UriAction;", "Lcom/braze/ui/actions/IAction;", "uri", "Landroid/net/Uri;", "extras", "Landroid/os/Bundle;", "useWebView", "", "channel", "Lcom/braze/enums/Channel;", "<init>", "(Landroid/net/Uri;Landroid/os/Bundle;ZLcom/braze/enums/Channel;)V", "original", "(Lcom/braze/ui/actions/UriAction;)V", "getExtras", "()Landroid/os/Bundle;", "getChannel", "()Lcom/braze/enums/Channel;", "getUri", "()Landroid/net/Uri;", "setUri", "(Landroid/net/Uri;)V", "getUseWebView", "()Z", "setUseWebView", "(Z)V", "execute", "", "context", "Landroid/content/Context;", "openUriWithWebViewActivity", "openUriWithActionView", "openUriWithWebViewActivityFromPush", "openUriWithActionViewFromPush", "getWebViewActivityIntent", "Landroid/content/Intent;", "getActionViewIntent", "getIntentArrayWithConfiguredBackStack", "", "targetIntent", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "(Landroid/content/Context;Landroid/os/Bundle;Landroid/content/Intent;Lcom/braze/configuration/BrazeConfigurationProvider;)[Landroid/content/Intent;", "android-sdk-ui_release"})
public class UriAction
implements IAction {
    @Nullable
    private final Bundle extras;
    @NotNull
    private final Channel channel;
    @NotNull
    private Uri uri;
    private boolean useWebView;

    @Nullable
    public final Bundle getExtras() {
        return this.extras;
    }

    @Override
    @NotNull
    public final Channel getChannel() {
        return this.channel;
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    public final void setUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"<set-?>");
        this.uri = uri;
    }

    public final boolean getUseWebView() {
        return this.useWebView;
    }

    public final void setUseWebView(boolean bl) {
        this.useWebView = bl;
    }

    public UriAction(@NotNull Uri uri, @Nullable Bundle extras, boolean useWebView, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.uri = uri;
        this.extras = extras;
        this.useWebView = useWebView;
        this.channel = channel;
    }

    public UriAction(@NotNull UriAction original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.uri = original.uri;
        this.extras = original.extras;
        this.useWebView = original.useWebView;
        this.channel = original.channel;
    }

    @Override
    public void execute(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (BrazeFileUtils.isLocalUri((Uri)this.uri)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> UriAction.execute$lambda$0(this), (int)7, null);
            return;
        }
        if (BrazeActionParser.INSTANCE.isBrazeActionUri(this.uri)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> UriAction.execute$lambda$1(this), (int)6, null);
            BrazeActionParser.INSTANCE.execute(context, this.uri, this.channel);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> UriAction.execute$lambda$2(this), (int)7, null);
            if (this.useWebView && CollectionsKt.contains((Iterable)BrazeFileUtils.REMOTE_SCHEMES, (Object)this.uri.getScheme())) {
                if (this.channel == Channel.PUSH) {
                    this.openUriWithWebViewActivityFromPush(context, this.uri, this.extras);
                } else {
                    this.openUriWithWebViewActivity(context, this.uri, this.extras);
                }
            } else if (this.channel == Channel.PUSH) {
                this.openUriWithActionViewFromPush(context, this.uri, this.extras);
            } else {
                this.openUriWithActionView(context, this.uri, this.extras);
            }
        }
    }

    protected void openUriWithWebViewActivity(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = this.getWebViewActivityIntent(context, uri, extras);
        intent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_OPEN_WITH_WEBVIEW_ACTIVITY));
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, UriAction::openUriWithWebViewActivity$lambda$3, (int)4, null);
        }
    }

    protected void openUriWithActionView(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = this.getActionViewIntent(context, uri, extras);
        intent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_OPEN_WITH_ACTION_VIEW));
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> UriAction.openUriWithActionView$lambda$4(uri, extras), (int)4, null);
        }
    }

    protected void openUriWithWebViewActivityFromPush(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
        try {
            Intent webViewIntent = this.getWebViewActivityIntent(context, uri, extras);
            context.startActivities(this.getIntentArrayWithConfiguredBackStack(context, extras, webViewIntent, configurationProvider));
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, UriAction::openUriWithWebViewActivityFromPush$lambda$5, (int)4, null);
        }
    }

    protected void openUriWithActionViewFromPush(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
        try {
            Intent uriIntent = this.getActionViewIntent(context, uri, extras);
            context.startActivities(this.getIntentArrayWithConfiguredBackStack(context, extras, uriIntent, configurationProvider));
        }
        catch (ActivityNotFoundException e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, (Throwable)e, (boolean)false, () -> UriAction.openUriWithActionViewFromPush$lambda$6(uri), (int)4, null);
        }
    }

    @NotNull
    protected final Intent getWebViewActivityIntent(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intent webViewActivityIntent;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BrazeConfigurationProvider configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
        String customWebViewActivityClassName = configurationProvider.getCustomHtmlWebViewActivityClassName();
        CharSequence charSequence = customWebViewActivityClassName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && UriUtils.isActivityRegisteredInManifest(context, customWebViewActivityClassName)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> UriAction.getWebViewActivityIntent$lambda$7(customWebViewActivityClassName), (int)7, null);
            charSequence = new Intent().setClassName(context, customWebViewActivityClassName);
            Intrinsics.checkNotNull((Object)charSequence);
            object = charSequence;
        } else {
            object = webViewActivityIntent = new Intent(context, BrazeWebViewActivity.class);
        }
        if (extras != null) {
            webViewActivityIntent.putExtras(extras);
        }
        webViewActivityIntent.putExtra("url", uri.toString());
        return webViewActivityIntent;
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    @NotNull
    protected final Intent getActionViewIntent(@NotNull Context context, @NotNull Uri uri, @Nullable Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        if (extras != null) {
            intent.putExtras(extras);
        }
        List list = Build.VERSION.SDK_INT >= 33 ? context.getPackageManager().queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of((long)0L)) : context.getPackageManager().queryIntentActivities(intent, 0);
        Intrinsics.checkNotNull((Object)list);
        List resolveInfos = list;
        if (resolveInfos.size() > 1) {
            for (ResolveInfo resolveInfo : resolveInfos) {
                if (!Intrinsics.areEqual((Object)resolveInfo.activityInfo.packageName, (Object)context.getPackageName())) continue;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, () -> UriAction.getActionViewIntent$lambda$8(resolveInfo), (int)7, null);
                intent.setPackage(resolveInfo.activityInfo.packageName);
                break;
            }
        }
        return intent;
    }

    @VisibleForTesting
    @NotNull
    public final Intent[] getIntentArrayWithConfiguredBackStack(@NotNull Context context, @Nullable Bundle extras, @NotNull Intent targetIntent, @NotNull BrazeConfigurationProvider configurationProvider) {
        Intent[] intentArray;
        Intent[] intentArray2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetIntent, (String)"targetIntent");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        Intent rootIntent = null;
        if (configurationProvider.isPushDeepLinkBackStackActivityEnabled()) {
            String activityClass = configurationProvider.getPushDeepLinkBackStackActivityClassName();
            CharSequence charSequence = activityClass;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, UriAction::getIntentArrayWithConfiguredBackStack$lambda$9, (int)6, null);
                rootIntent = UriUtils.getMainActivityIntent(context, extras);
            } else if (UriUtils.isActivityRegisteredInManifest(context, activityClass)) {
                Intent intent;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> UriAction.getIntentArrayWithConfiguredBackStack$lambda$10(activityClass), (int)6, null);
                Bundle bundle = extras;
                if (bundle != null) {
                    Bundle it = bundle;
                    boolean bl = false;
                    intent = new Intent().setClassName(context, activityClass).setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_BACK_STACK_GET_ROOT_INTENT)).putExtras(it);
                } else {
                    intent = null;
                }
                rootIntent = intent;
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> UriAction.getIntentArrayWithConfiguredBackStack$lambda$12(activityClass), (int)6, null);
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, UriAction::getIntentArrayWithConfiguredBackStack$lambda$13, (int)6, null);
        }
        if (rootIntent == null) {
            targetIntent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_ACTION_BACK_STACK_ONLY_GET_TARGET_INTENT));
            intentArray2 = new Intent[]{targetIntent};
            intentArray = intentArray2;
        } else {
            intentArray2 = new Intent[]{rootIntent, targetIntent};
            intentArray = intentArray2;
        }
        return intentArray;
    }

    private static final String execute$lambda$0(UriAction this$0) {
        return "Not executing local Uri: " + this$0.uri;
    }

    private static final String execute$lambda$1(UriAction this$0) {
        return "Executing BrazeActions uri:\n'" + this$0.uri + '\'';
    }

    private static final String execute$lambda$2(UriAction this$0) {
        return "Executing Uri action from channel " + this$0.channel + ": " + this$0.uri + ". UseWebView: " + this$0.useWebView + ". Extras: " + this$0.extras;
    }

    private static final String openUriWithWebViewActivity$lambda$3() {
        return "BrazeWebViewActivity not opened successfully.";
    }

    private static final String openUriWithActionView$lambda$4(Uri $uri, Bundle $extras) {
        return "Failed to handle uri " + $uri + " with extras: " + $extras;
    }

    private static final String openUriWithWebViewActivityFromPush$lambda$5() {
        return "Braze WebView Activity not opened successfully.";
    }

    private static final String openUriWithActionViewFromPush$lambda$6(Uri $uri) {
        return "Could not find appropriate activity to open for deep link " + $uri;
    }

    private static final String getWebViewActivityIntent$lambda$7(String $customWebViewActivityClassName) {
        return "Launching custom WebView Activity with class name: " + $customWebViewActivityClassName;
    }

    private static final String getActionViewIntent$lambda$8(ResolveInfo $resolveInfo) {
        return "Setting deep link intent package to " + $resolveInfo.activityInfo.packageName + '.';
    }

    private static final String getIntentArrayWithConfiguredBackStack$lambda$9() {
        return "Adding main activity intent to back stack while opening uri from push";
    }

    private static final String getIntentArrayWithConfiguredBackStack$lambda$10(String $activityClass) {
        return "Adding custom back stack activity while opening uri from push: " + $activityClass;
    }

    private static final String getIntentArrayWithConfiguredBackStack$lambda$12(String $activityClass) {
        return "Not adding unregistered activity to the back stack while opening uri from push: " + $activityClass;
    }

    private static final String getIntentArrayWithConfiguredBackStack$lambda$13() {
        return "Not adding back stack activity while opening uri from push due to disabled configuration setting.";
    }
}

