/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.views;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.view.WindowInsetsCompat;
import com.braze.enums.inappmessage.ImageStyle;
import com.braze.models.inappmessage.IInAppMessageImmersive;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.inappmessage.config.BrazeInAppMessageParams;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import com.braze.ui.inappmessage.views.IInAppMessageImageView;
import com.braze.ui.inappmessage.views.InAppMessageImageView;
import com.braze.ui.inappmessage.views.InAppMessageImmersiveBaseView;
import com.braze.ui.support.ViewUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020#H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u0013012\u0006\u00102\u001a\u00020#H\u0016J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020\u000bH\u0016J\u0010\u00105\u001a\u00020)2\u0006\u00106\u001a\u000207H\u0016J \u00108\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020\u0013H\u0002J\u0018\u0010=\u001a\u00020)2\u0006\u0010;\u001a\u0002072\u0006\u0010>\u001a\u00020\u0013H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u0016\u0010 \u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%\u00a8\u0006?"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageFullView;", "Lcom/braze/ui/inappmessage/views/InAppMessageImmersiveBaseView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "inAppMessageImageView", "Lcom/braze/ui/inappmessage/views/InAppMessageImageView;", "isGraphic", "", "messageTextView", "Landroid/widget/TextView;", "getMessageTextView", "()Landroid/widget/TextView;", "messageHeaderTextView", "getMessageHeaderTextView", "frameView", "Landroid/view/View;", "getFrameView", "()Landroid/view/View;", "messageCloseButtonView", "getMessageCloseButtonView", "messageClickableView", "getMessageClickableView", "messageImageView", "Landroid/widget/ImageView;", "getMessageImageView", "()Landroid/widget/ImageView;", "messageIconView", "getMessageIconView", "messageBackgroundObject", "getMessageBackgroundObject", "longEdge", "", "getLongEdge", "()I", "shortEdge", "getShortEdge", "createAppropriateViews", "", "activity", "Landroid/app/Activity;", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessageImmersive;", "setMessageBackgroundColor", "color", "getMessageButtonViews", "", "numButtons", "resetMessageMargins", "imageRetrievalSuccessful", "applyWindowInsets", "insets", "Landroidx/core/view/WindowInsetsCompat;", "setInAppMessageImageViewAttributes", "Lcom/braze/ui/inappmessage/views/IInAppMessageImageView;", "applyDisplayCutoutMarginsToCloseButton", "windowInsets", "closeButtonView", "applyDisplayCutoutMarginsToContentArea", "contentAreaView", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nInAppMessageFullView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppMessageFullView.kt\ncom/braze/ui/inappmessage/views/InAppMessageFullView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public class InAppMessageFullView
extends InAppMessageImmersiveBaseView {
    @Nullable
    private InAppMessageImageView inAppMessageImageView;
    private boolean isGraphic;

    public InAppMessageFullView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @Nullable
    public TextView getMessageTextView() {
        return (TextView)this.findViewById(R.id.com_braze_inappmessage_full_message);
    }

    @Override
    @Nullable
    public TextView getMessageHeaderTextView() {
        return (TextView)this.findViewById(R.id.com_braze_inappmessage_full_header_text);
    }

    @Override
    @Nullable
    public View getFrameView() {
        return this.findViewById(R.id.com_braze_inappmessage_full_frame);
    }

    @Override
    @Nullable
    public View getMessageCloseButtonView() {
        return this.findViewById(R.id.com_braze_inappmessage_full_close_button);
    }

    @Override
    @Nullable
    public View getMessageClickableView() {
        return this.findViewById(R.id.com_braze_inappmessage_full);
    }

    @Override
    @Nullable
    public ImageView getMessageImageView() {
        return this.inAppMessageImageView;
    }

    @Override
    @Nullable
    public TextView getMessageIconView() {
        return null;
    }

    @Nullable
    public View getMessageBackgroundObject() {
        return this.findViewById(R.id.com_braze_inappmessage_full);
    }

    public int getLongEdge() {
        View inAppMessageFullView = this.findViewById(R.id.com_braze_inappmessage_full);
        return inAppMessageFullView.getLayoutParams().height;
    }

    public int getShortEdge() {
        View inAppMessageFullView = this.findViewById(R.id.com_braze_inappmessage_full);
        return inAppMessageFullView.getLayoutParams().width;
    }

    public void createAppropriateViews(@NotNull Activity activity, @NotNull IInAppMessageImmersive inAppMessage, boolean isGraphic) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        InAppMessageImageView inAppMessageImageView = this.inAppMessageImageView = (InAppMessageImageView)this.findViewById(R.id.com_braze_inappmessage_full_imageview);
        if (inAppMessageImageView != null) {
            InAppMessageImageView it = inAppMessageImageView;
            boolean bl = false;
            this.setInAppMessageImageViewAttributes(activity, inAppMessage, it);
        }
        this.isGraphic = isGraphic;
    }

    @Override
    public void setMessageBackgroundColor(int color2) {
        View msgBackgroundObject;
        View view = msgBackgroundObject = this.getMessageBackgroundObject();
        if ((view != null ? view.getBackground() : null) instanceof GradientDrawable) {
            InAppMessageViewUtils.setViewBackgroundColorFilter(msgBackgroundObject, color2);
        } else if (this.isGraphic) {
            super.setMessageBackgroundColor(color2);
        } else {
            View view2 = this.findViewById(R.id.com_braze_inappmessage_full_all_content_parent);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
            InAppMessageViewUtils.setViewBackgroundColor(view2, color2);
            View view3 = this.findViewById(R.id.com_braze_inappmessage_full_text_and_button_content_parent);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
            InAppMessageViewUtils.setViewBackgroundColor(view3, color2);
        }
    }

    @Override
    @NotNull
    public List<View> getMessageButtonViews(int numButtons) {
        List buttonViews = new ArrayList();
        switch (numButtons) {
            case 1: {
                View singleButton;
                View singleButtonParent = this.findViewById(R.id.com_braze_inappmessage_full_button_layout_single);
                if (singleButtonParent != null) {
                    singleButtonParent.setVisibility(0);
                }
                if ((singleButton = this.findViewById(R.id.com_braze_inappmessage_full_button_single_one)) == null) break;
                buttonViews.add(singleButton);
                break;
            }
            case 2: {
                View dualButtonParent = this.findViewById(R.id.com_braze_inappmessage_full_button_layout_dual);
                if (dualButtonParent != null) {
                    dualButtonParent.setVisibility(0);
                }
                View dualButton1 = this.findViewById(R.id.com_braze_inappmessage_full_button_dual_one);
                View dualButton2 = this.findViewById(R.id.com_braze_inappmessage_full_button_dual_two);
                if (dualButton1 != null) {
                    buttonViews.add(dualButton1);
                }
                if (dualButton2 == null) break;
                buttonViews.add(dualButton2);
            }
        }
        return buttonViews;
    }

    @Override
    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        block0: {
            super.resetMessageMargins(imageRetrievalSuccessful);
            View view = this.getMessageClickableView();
            if (view == null) break block0;
            View msgClickableView = view;
            boolean bl = false;
            View scrollViewChild = this.findViewById(R.id.com_braze_inappmessage_full_text_layout);
            scrollViewChild.setOnClickListener(arg_0 -> InAppMessageFullView.resetMessageMargins$lambda$3$lambda$2(this, msgClickableView, arg_0));
        }
    }

    @Override
    public void applyWindowInsets(@NotNull WindowInsetsCompat insets) {
        block3: {
            View contentArea;
            View it;
            block2: {
                View dualButtonParent;
                View singleButtonParent;
                Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
                super.applyWindowInsets(insets);
                View view = this.getMessageCloseButtonView();
                if (view != null) {
                    it = view;
                    boolean bl = false;
                    this.applyDisplayCutoutMarginsToCloseButton(insets, it);
                }
                if (!this.isGraphic) break block2;
                View view2 = singleButtonParent = this.findViewById(R.id.com_braze_inappmessage_full_button_layout_single);
                boolean bl = view2 != null ? view2.getVisibility() == 0 : false;
                if (bl) {
                    this.applyDisplayCutoutMarginsToContentArea(insets, singleButtonParent);
                    return;
                }
                View view3 = dualButtonParent = this.findViewById(R.id.com_braze_inappmessage_full_button_layout_dual);
                boolean bl2 = view3 != null ? view3.getVisibility() == 0 : false;
                if (!bl2) break block3;
                this.applyDisplayCutoutMarginsToContentArea(insets, dualButtonParent);
                break block3;
            }
            View view = contentArea = this.findViewById(R.id.com_braze_inappmessage_full_text_and_button_content_parent);
            if (view == null) break block3;
            it = view;
            boolean bl = false;
            this.applyDisplayCutoutMarginsToContentArea(insets, it);
        }
    }

    private final void setInAppMessageImageViewAttributes(Activity activity, IInAppMessageImmersive inAppMessage, IInAppMessageImageView inAppMessageImageView) {
        inAppMessageImageView.setInAppMessageImageCropType(inAppMessage.getCropType());
        inAppMessageImageView.setAltImageText(inAppMessage.getAltImageText());
        if (ViewUtils.isRunningOnTablet(activity)) {
            float radiusInPx = (float)ViewUtils.convertDpToPixels((Context)activity, BrazeInAppMessageParams.getModalizedImageRadiusDp());
            if (inAppMessage.getImageStyle() == ImageStyle.GRAPHIC) {
                inAppMessageImageView.setCornersRadiusPx(radiusInPx);
            } else {
                inAppMessageImageView.setCornersRadiiPx(radiusInPx, radiusInPx, 0.0f, 0.0f);
            }
        } else {
            inAppMessageImageView.setCornersRadiusPx(0.0f);
        }
    }

    private final void applyDisplayCutoutMarginsToCloseButton(WindowInsetsCompat windowInsets, View closeButtonView) {
        if (closeButtonView.getLayoutParams() == null || !(closeButtonView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, InAppMessageFullView::applyDisplayCutoutMarginsToCloseButton$lambda$6, (int)7, null);
            return;
        }
        ViewGroup.LayoutParams layoutParams = closeButtonView.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
        layoutParams2.setMargins(ViewUtils.getMaxSafeLeftInset(windowInsets) + layoutParams2.leftMargin, ViewUtils.getMaxSafeTopInset(windowInsets) + layoutParams2.topMargin, ViewUtils.getMaxSafeRightInset(windowInsets) + layoutParams2.rightMargin, ViewUtils.getMaxSafeBottomInset(windowInsets) + layoutParams2.bottomMargin);
    }

    private final void applyDisplayCutoutMarginsToContentArea(WindowInsetsCompat windowInsets, View contentAreaView) {
        if (!(contentAreaView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, InAppMessageFullView::applyDisplayCutoutMarginsToContentArea$lambda$7, (int)7, null);
            return;
        }
        ViewGroup.LayoutParams layoutParams = contentAreaView.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
        layoutParams2.setMargins(ViewUtils.getMaxSafeLeftInset(windowInsets) + layoutParams2.leftMargin, layoutParams2.topMargin, ViewUtils.getMaxSafeRightInset(windowInsets) + layoutParams2.rightMargin, ViewUtils.getMaxSafeBottomInset(windowInsets) + layoutParams2.bottomMargin);
    }

    private static final String resetMessageMargins$lambda$3$lambda$2$lambda$1() {
        return "Passing scrollView click event to message clickable view.";
    }

    private static final void resetMessageMargins$lambda$3$lambda$2(InAppMessageFullView this$0, View $msgClickableView, View it) {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (boolean)false, InAppMessageFullView::resetMessageMargins$lambda$3$lambda$2$lambda$1, (int)7, null);
        $msgClickableView.performClick();
    }

    private static final String applyDisplayCutoutMarginsToCloseButton$lambda$6() {
        return "Close button layout params are null or not of the expected class. Not applying window insets.";
    }

    private static final String applyDisplayCutoutMarginsToContentArea$lambda$7() {
        return "Content area layout params are null or not of the expected class. Not applying window insets.";
    }
}

