/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.support;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.braze.IBrazeDeeplinkHandler;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003*\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"TAG", "", "getQueryParameters", "", "Landroid/net/Uri;", "getMainActivityIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "extras", "Landroid/os/Bundle;", "isActivityRegisteredInManifest", "", "className", "android-sdk-ui_release"})
@JvmName(name="UriUtils")
@SourceDebugExtension(value={"SMAP\nUriUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriUtils.kt\ncom/braze/ui/support/UriUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n774#2:87\n865#2,2:88\n*S KotlinDebug\n*F\n+ 1 UriUtils.kt\ncom/braze/ui/support/UriUtils\n*L\n43#1:87\n43#1:88,2\n*E\n"})
public final class UriUtils {
    @NotNull
    private static final String TAG = BrazeLogger.INSTANCE.getBrazeLogTag("UriUtils");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getQueryParameters(@NotNull Uri $this$getQueryParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$getQueryParameters, (String)"<this>");
        Ref.ObjectRef uri = new Ref.ObjectRef();
        uri.element = $this$getQueryParameters;
        String encodedQuery = ((Uri)uri.element).getEncodedQuery();
        if (encodedQuery == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> UriUtils.getQueryParameters$lambda$0(uri), (int)12, null);
            return MapsKt.emptyMap();
        }
        Map parameterValues = new LinkedHashMap();
        try {
            void $this$filterTo$iv$iv;
            if (((Uri)uri.element).isOpaque()) {
                uri.element = Uri.parse((String)"://").buildUpon().encodedQuery(encodedQuery).build();
            }
            Set set = ((Uri)uri.element).getQueryParameterNames();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getQueryParameterNames(...)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List queryParameterNames = (List)destination$iv$iv;
            for (String queryParameterKey : queryParameterNames) {
                String queryParameterValue = ((Uri)uri.element).getQueryParameter(queryParameterKey);
                CharSequence charSequence = queryParameterValue;
                if (charSequence == null || charSequence.length() == 0) continue;
                parameterValues.put(queryParameterKey, queryParameterValue);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> UriUtils.getQueryParameters$lambda$2(uri), (int)8, null);
        }
        return parameterValues;
    }

    @Nullable
    public static final Intent getMainActivityIntent(@NotNull Context context, @Nullable Bundle extras) {
        Intent startActivityIntent;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = startActivityIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (intent != null) {
                intent.setFlags(BrazeDeeplinkHandler.Companion.getInstance().getIntentFlags(IBrazeDeeplinkHandler.IntentFlagPurpose.URI_UTILS_GET_MAIN_ACTIVITY_INTENT));
            }
            if (extras == null) break block2;
            Intent intent2 = startActivityIntent;
            if (intent2 != null) {
                intent2.putExtras(extras);
            }
        }
        return startActivityIntent;
    }

    public static /* synthetic */ Intent getMainActivityIntent$default(Context context, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = null;
        }
        return UriUtils.getMainActivityIntent(context, bundle);
    }

    public static final boolean isActivityRegisteredInManifest(@NotNull Context context, @NotNull String className) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            ActivityInfo activityInfo = Build.VERSION.SDK_INT >= 33 ? context.getPackageManager().getActivityInfo(new ComponentName(context, className), PackageManager.ComponentInfoFlags.of((long)0L)) : context.getPackageManager().getActivityInfo(new ComponentName(context, className), 0);
            bl = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.W, (Throwable)e, (boolean)false, () -> UriUtils.isActivityRegisteredInManifest$lambda$3(className), (int)8, null);
            bl = false;
        }
        return bl;
    }

    private static final String getQueryParameters$lambda$0(Ref.ObjectRef $uri) {
        return "Encoded query is null for Uri: " + $uri.element + " Returning empty map for query parameters";
    }

    private static final String getQueryParameters$lambda$2(Ref.ObjectRef $uri) {
        return "Failed to map the query parameters of Uri: " + $uri.element;
    }

    private static final String isActivityRegisteredInManifest$lambda$3(String $className) {
        return "Could not find activity info for class with name: " + $className;
    }
}

