/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.support;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.DisplayCutoutCompat;
import androidx.core.view.WindowInsetsCompat;
import com.braze.enums.inappmessage.Orientation;
import com.braze.support.BrazeLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\f\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u0006\u001a\n\u0010\u0007\u001a\u00020\u0005*\u00020\u0006\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006\u001a\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"TAG", "", "TABLET_SMALLEST_WIDTH_DP", "", "removeViewFromParent", "", "Landroid/view/View;", "setFocusableInTouchModeAndRequestFocus", "convertDpToPixels", "", "context", "Landroid/content/Context;", "valueInDp", "isRunningOnTablet", "", "Landroid/app/Activity;", "setActivityRequestedOrientation", "requestedOrientation", "setHeightOnViewLayoutParams", "view", "height", "isDeviceInNightMode", "isCurrentOrientationValid", "currentScreenOrientation", "preferredOrientation", "Lcom/braze/enums/inappmessage/Orientation;", "getMaxSafeLeftInset", "windowInsets", "Landroidx/core/view/WindowInsetsCompat;", "getMaxSafeRightInset", "getMaxSafeTopInset", "getMaxSafeBottomInset", "isDeviceNotInTouchMode", "getStatusBarHeight", "android-sdk-ui_release"})
@JvmName(name="ViewUtils")
public final class ViewUtils {
    @NotNull
    private static final String TAG = BrazeLogger.INSTANCE.getBrazeLogTag("ViewUtils");
    private static final int TABLET_SMALLEST_WIDTH_DP = 600;

    public static final void removeViewFromParent(@Nullable View $this$removeViewFromParent) {
        try {
            if ($this$removeViewFromParent == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, ViewUtils::removeViewFromParent$lambda$0, (int)12, null);
            }
            View view = $this$removeViewFromParent;
            if ((view != null ? view.getParent() : null) instanceof ViewGroup) {
                ViewParent viewParent = $this$removeViewFromParent.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
                ViewGroup parent = (ViewGroup)viewParent;
                parent.removeView($this$removeViewFromParent);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, () -> ViewUtils.removeViewFromParent$lambda$1($this$removeViewFromParent, parent), (int)12, null);
            }
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, ViewUtils::removeViewFromParent$lambda$2, (int)8, null);
        }
    }

    public static final void setFocusableInTouchModeAndRequestFocus(@NotNull View $this$setFocusableInTouchModeAndRequestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$setFocusableInTouchModeAndRequestFocus, (String)"<this>");
        try {
            $this$setFocusableInTouchModeAndRequestFocus.setFocusableInTouchMode(true);
            $this$setFocusableInTouchModeAndRequestFocus.requestFocus();
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, ViewUtils::setFocusableInTouchModeAndRequestFocus$lambda$3, (int)8, null);
        }
    }

    public static final double convertDpToPixels(@NotNull Context context, double valueInDp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        double density = context.getResources().getDisplayMetrics().density;
        return valueInDp * density;
    }

    public static final boolean isRunningOnTablet(@NotNull Activity $this$isRunningOnTablet) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunningOnTablet, (String)"<this>");
        return $this$isRunningOnTablet.getResources().getConfiguration().smallestScreenWidthDp >= 600;
    }

    public static final void setActivityRequestedOrientation(@NotNull Activity $this$setActivityRequestedOrientation, int requestedOrientation) {
        Intrinsics.checkNotNullParameter((Object)$this$setActivityRequestedOrientation, (String)"<this>");
        try {
            $this$setActivityRequestedOrientation.setRequestedOrientation(requestedOrientation);
        }
        catch (Exception e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> ViewUtils.setActivityRequestedOrientation$lambda$4(requestedOrientation, $this$setActivityRequestedOrientation), (int)8, null);
        }
    }

    public static final void setHeightOnViewLayoutParams(@NotNull View view, int height) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.height = height;
        view.setLayoutParams(layoutParams);
    }

    public static final boolean isDeviceInNightMode(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int nightModeFlags = context.getResources().getConfiguration().uiMode & 0x30;
        return nightModeFlags == 32;
    }

    public static final boolean isCurrentOrientationValid(int currentScreenOrientation, @NotNull Orientation preferredOrientation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)preferredOrientation, (String)"preferredOrientation");
        if (currentScreenOrientation == 2 && preferredOrientation == Orientation.LANDSCAPE) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, ViewUtils::isCurrentOrientationValid$lambda$5, (int)12, null);
            bl = true;
        } else if (currentScreenOrientation == 1 && preferredOrientation == Orientation.PORTRAIT) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, ViewUtils::isCurrentOrientationValid$lambda$6, (int)12, null);
            bl = true;
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, () -> ViewUtils.isCurrentOrientationValid$lambda$7(currentScreenOrientation, preferredOrientation), (int)12, null);
            bl = false;
        }
        return bl;
    }

    public static final int getMaxSafeLeftInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetLeft() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left;
        return Math.max(n, n2);
    }

    public static final int getMaxSafeRightInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetRight() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right;
        return Math.max(n, n2);
    }

    public static final int getMaxSafeTopInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetTop() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top;
        return Math.max(n, n2);
    }

    public static final int getMaxSafeBottomInset(@NotNull WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        DisplayCutoutCompat displayCutoutCompat = windowInsets.getDisplayCutout();
        int n = displayCutoutCompat != null ? displayCutoutCompat.getSafeInsetBottom() : 0;
        int n2 = windowInsets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom;
        return Math.max(n, n2);
    }

    public static final boolean isDeviceNotInTouchMode(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return !view.isInTouchMode();
    }

    public static final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return resourceId > 0 ? context.getResources().getDimensionPixelSize(resourceId) : 0;
    }

    private static final String removeViewFromParent$lambda$0() {
        return "View passed in is null. Not removing from parent.";
    }

    private static final String removeViewFromParent$lambda$1(View $this_removeViewFromParent, ViewGroup $parent) {
        return "Removed view: " + $this_removeViewFromParent + "\nfrom parent: " + $parent;
    }

    private static final String removeViewFromParent$lambda$2() {
        return "Caught exception while removing view from parent.";
    }

    private static final String setFocusableInTouchModeAndRequestFocus$lambda$3() {
        return "Caught exception while setting view to focusable in touch mode and requesting focus.";
    }

    private static final String setActivityRequestedOrientation$lambda$4(int $requestedOrientation, Activity $this_setActivityRequestedOrientation) {
        return "Failed to set requested orientation " + $requestedOrientation + " for activity class: " + $this_setActivityRequestedOrientation.getLocalClassName();
    }

    private static final String isCurrentOrientationValid$lambda$5() {
        return "Current and preferred orientation are landscape.";
    }

    private static final String isCurrentOrientationValid$lambda$6() {
        return "Current and preferred orientation are portrait.";
    }

    private static final String isCurrentOrientationValid$lambda$7(int $currentScreenOrientation, Orientation $preferredOrientation) {
        return "Current orientation " + $currentScreenOrientation + " and preferred orientation " + $preferredOrientation + " don't match";
    }
}

