/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Bundle;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.VisibleForTesting;
import androidx.webkit.WebViewAssetLoader;
import com.braze.BrazeInternal;
import com.braze.coroutine.BrazeCoroutineScope;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.outgoing.BrazeProperties;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.ui.banners.listeners.IBannerWebViewClientListener;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import com.braze.ui.inappmessage.listeners.IWebViewClientStateListener;
import com.braze.ui.support.UriUtils;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 82\u00020\u0001:\u000278BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020\rH\u0016J\u0010\u0010)\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010*\u001a\u00020'H\u0002J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020\rH\u0017J\u0010\u0010,\u001a\u00020'2\b\u0010-\u001a\u0004\u0018\u00010\u0015J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\rH\u0002J \u0010/\u001a\u00020'2\u0006\u0010(\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u00105\u001a\u000206H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/braze/ui/BrazeWebViewClient;", "Landroid/webkit/WebViewClient;", "context", "Landroid/content/Context;", "type", "Lcom/braze/ui/BrazeWebViewClient$Type;", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "inAppMessageWebViewClientListener", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageWebViewClientListener;", "bannerWebViewClientListener", "Lcom/braze/ui/banners/listeners/IBannerWebViewClientListener;", "assetDirectoryUrl", "", "<init>", "(Landroid/content/Context;Lcom/braze/ui/BrazeWebViewClient$Type;Lcom/braze/models/inappmessage/IInAppMessage;Lcom/braze/ui/inappmessage/listeners/IInAppMessageWebViewClientListener;Lcom/braze/ui/banners/listeners/IBannerWebViewClientListener;Ljava/lang/String;)V", "getContext", "()Landroid/content/Context;", "getType", "()Lcom/braze/ui/BrazeWebViewClient$Type;", "webViewClientStateListener", "Lcom/braze/ui/inappmessage/listeners/IWebViewClientStateListener;", "hasPageFinishedLoading", "", "hasCalledPageFinishedOnListener", "Ljava/util/concurrent/atomic/AtomicBoolean;", "markPageFinishedJob", "Lkotlinx/coroutines/Job;", "maxOnPageFinishedWaitTimeMs", "", "assetLoader", "Landroidx/webkit/WebViewAssetLoader;", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "view", "Landroid/webkit/WebView;", "request", "Landroid/webkit/WebResourceRequest;", "onPageFinished", "", "url", "appendBridgeJavascript", "markPageFinished", "shouldOverrideUrlLoading", "setWebViewClientStateListener", "listener", "handleUrlOverride", "handleQueryAction", "uri", "Landroid/net/Uri;", "queryBundle", "Landroid/os/Bundle;", "onRenderProcessGone", "detail", "Landroid/webkit/RenderProcessGoneDetail;", "Type", "Companion", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nBrazeWebViewClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeWebViewClient.kt\ncom/braze/ui/BrazeWebViewClient\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,313:1\n29#2:314\n*S KotlinDebug\n*F\n+ 1 BrazeWebViewClient.kt\ncom/braze/ui/BrazeWebViewClient\n*L\n185#1:314\n*E\n"})
public class BrazeWebViewClient
extends WebViewClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Type type;
    @Nullable
    private final IInAppMessage inAppMessage;
    @Nullable
    private final IInAppMessageWebViewClientListener inAppMessageWebViewClientListener;
    @Nullable
    private final IBannerWebViewClientListener bannerWebViewClientListener;
    @Nullable
    private IWebViewClientStateListener webViewClientStateListener;
    private boolean hasPageFinishedLoading;
    @NotNull
    private final AtomicBoolean hasCalledPageFinishedOnListener;
    @Nullable
    private Job markPageFinishedJob;
    private final int maxOnPageFinishedWaitTimeMs;
    @NotNull
    private final WebViewAssetLoader assetLoader;
    @NotNull
    public static final String BRIDGE_JS_FILE = "braze-html-bridge.js";
    @NotNull
    public static final String JAVASCRIPT_PREFIX = "javascript:";
    @NotNull
    private static final String BRAZE_SCHEME = "appboy";
    @NotNull
    private static final String AUTHORITY_NAME_CLOSE = "close";
    @NotNull
    private static final String AUTHORITY_NAME_CUSTOM_EVENT = "customEvent";
    @NotNull
    private static final String BRAZE_CUSTOM_EVENT_NAME_KEY = "name";
    @NotNull
    public static final String QUERY_NAME_BUTTON_ID = "abButtonId";
    @NotNull
    public static final String QUERY_NAME_EXTERNAL_OPEN = "abExternalOpen";
    @NotNull
    public static final String QUERY_NAME_DEEPLINK = "abDeepLink";

    public BrazeWebViewClient(@NotNull Context context, @NotNull Type type, @Nullable IInAppMessage inAppMessage, @Nullable IInAppMessageWebViewClientListener inAppMessageWebViewClientListener, @Nullable IBannerWebViewClientListener bannerWebViewClientListener, @Nullable String assetDirectoryUrl) {
        WebViewAssetLoader webViewAssetLoader;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.context = context;
        this.type = type;
        this.inAppMessage = inAppMessage;
        this.inAppMessageWebViewClientListener = inAppMessageWebViewClientListener;
        this.bannerWebViewClientListener = bannerWebViewClientListener;
        this.hasCalledPageFinishedOnListener = new AtomicBoolean(false);
        this.maxOnPageFinishedWaitTimeMs = BrazeInternal.INSTANCE.getConfigurationProvider(this.context).getInAppMessageWebViewClientOnPageFinishedMaxWaitMs();
        if (assetDirectoryUrl != null) {
            webViewAssetLoader = new WebViewAssetLoader.Builder().setDomain("iamcache.braze").addPathHandler("/", (WebViewAssetLoader.PathHandler)new WebViewAssetLoader.InternalStoragePathHandler(this.context, new File(assetDirectoryUrl))).build();
        } else {
            File triggerAssetsDir = new File(this.context.getCacheDir(), "ab_triggers");
            webViewAssetLoader = new WebViewAssetLoader.Builder().setDomain("iamcache.braze").addPathHandler("/ab_triggers/", (WebViewAssetLoader.PathHandler)new WebViewAssetLoader.InternalStoragePathHandler(this.context, triggerAssetsDir)).build();
        }
        WebViewAssetLoader webViewAssetLoader2 = webViewAssetLoader;
        Intrinsics.checkNotNull((Object)webViewAssetLoader2);
        this.assetLoader = webViewAssetLoader2;
    }

    public /* synthetic */ BrazeWebViewClient(Context context, Type type, IInAppMessage iInAppMessage, IInAppMessageWebViewClientListener iInAppMessageWebViewClientListener, IBannerWebViewClientListener iBannerWebViewClientListener, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            iInAppMessage = null;
        }
        if ((n & 8) != 0) {
            iInAppMessageWebViewClientListener = null;
        }
        if ((n & 0x10) != 0) {
            iBannerWebViewClientListener = null;
        }
        if ((n & 0x20) != 0) {
            string = null;
        }
        this(context, type, iInAppMessage, iInAppMessageWebViewClientListener, iBannerWebViewClientListener, string);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @Nullable WebResourceRequest request) {
        WebResourceResponse webResourceResponse;
        WebResourceRequest webResourceRequest = request;
        if (webResourceRequest != null) {
            WebResourceRequest it = webResourceRequest;
            boolean bl = false;
            webResourceResponse = this.assetLoader.shouldInterceptRequest(request.getUrl());
        } else {
            webResourceResponse = null;
        }
        return webResourceResponse;
    }

    public void onPageFinished(@NotNull WebView view, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super.onPageFinished(view, url);
        this.appendBridgeJavascript(view);
        IWebViewClientStateListener iWebViewClientStateListener = this.webViewClientStateListener;
        if (iWebViewClientStateListener != null) {
            IWebViewClientStateListener stateListener = iWebViewClientStateListener;
            boolean bl = false;
            if (this.hasCalledPageFinishedOnListener.compareAndSet(false, true)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeWebViewClient::onPageFinished$lambda$2$lambda$1, (int)6, null);
                stateListener.onPageFinished();
            }
        }
        this.hasPageFinishedLoading = true;
        Job job = this.markPageFinishedJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.markPageFinishedJob = null;
    }

    private final void appendBridgeJavascript(WebView view) {
        String string;
        try {
            AssetManager assetManager = this.context.getAssets();
            Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
            string = BrazeFileUtils.getAssetFileStringContents((AssetManager)assetManager, (String)BRIDGE_JS_FILE);
        }
        catch (Exception e) {
            if (this.type == Type.IN_APP_MESSAGE) {
                BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(false);
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, () -> BrazeWebViewClient.appendBridgeJavascript$lambda$3(this), (int)4, null);
            return;
        }
        String javascriptString = string;
        view.loadUrl(JAVASCRIPT_PREFIX + javascriptString);
    }

    private final void markPageFinished() {
        block1: {
            IWebViewClientStateListener iWebViewClientStateListener = this.webViewClientStateListener;
            if (iWebViewClientStateListener == null) break block1;
            IWebViewClientStateListener stateListener = iWebViewClientStateListener;
            boolean bl = false;
            if (this.hasCalledPageFinishedOnListener.compareAndSet(false, true)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, BrazeWebViewClient::markPageFinished$lambda$5$lambda$4, (int)6, null);
                stateListener.onPageFinished();
            }
        }
    }

    public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.handleUrlOverride(string);
    }

    @Deprecated(message="Deprecated in API 24")
    public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.handleUrlOverride(url);
    }

    public final void setWebViewClientStateListener(@Nullable IWebViewClientStateListener listener) {
        if (listener != null && this.hasPageFinishedLoading && this.hasCalledPageFinishedOnListener.compareAndSet(false, true)) {
            listener.onPageFinished();
        } else {
            this.markPageFinishedJob = BrazeCoroutineScope.launchDelayed$default((BrazeCoroutineScope)BrazeCoroutineScope.INSTANCE, (Number)this.maxOnPageFinishedWaitTimeMs, null, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ BrazeWebViewClient this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ BrazeWebViewClient this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            BrazeWebViewClient.access$markPageFinished(this.this$0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        this.webViewClientStateListener = listener;
    }

    private final boolean handleUrlOverride(String url) {
        String logMessage;
        String string = this.type == Type.IN_APP_MESSAGE && this.inAppMessageWebViewClientListener == null ? "BrazeWebViewClient was given null IInAppMessageWebViewClientListener listener. Returning true." : (this.type == Type.BANNER && this.bannerWebViewClientListener == null ? "BrazeWebViewClient was given null IBannerWebViewClientListener listener. Returning true." : (logMessage = StringsKt.isBlank((CharSequence)url) ? "BrazeWebViewClient.shouldOverrideUrlLoading was given blank url. Returning true." : null));
        if (logMessage != null) {
            String it = logMessage;
            boolean bl = false;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, () -> BrazeWebViewClient.handleUrlOverride$lambda$7$lambda$6(it), (int)6, null);
            return true;
        }
        String $this$toUri$iv = url;
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Bundle queryBundle = Companion.getBundleFromUrl(url);
        if (uri.getScheme() != null && Intrinsics.areEqual((Object)uri.getScheme(), (Object)BRAZE_SCHEME)) {
            this.handleQueryAction(url, uri, queryBundle);
            return true;
        }
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (boolean)false, () -> BrazeWebViewClient.handleUrlOverride$lambda$8(uri), (int)7, null);
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                IInAppMessage iInAppMessage = this.inAppMessage;
                if (iInAppMessage != null) {
                    IInAppMessage it = iInAppMessage;
                    boolean bl = false;
                    IInAppMessageWebViewClientListener iInAppMessageWebViewClientListener = this.inAppMessageWebViewClientListener;
                    if (iInAppMessageWebViewClientListener != null) {
                        iInAppMessageWebViewClientListener.onOtherUrlAction(it, url, queryBundle);
                    }
                }
                break;
            }
            case 2: {
                IBannerWebViewClientListener iBannerWebViewClientListener = this.bannerWebViewClientListener;
                if (iBannerWebViewClientListener != null) {
                    iBannerWebViewClientListener.onOtherUrlAction(this.context, url, queryBundle);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final void handleQueryAction(String url, Uri uri, Bundle queryBundle) {
        v0 = var4_4 = uri.getAuthority();
        if (v0 == null) ** GOTO lbl11
        switch (v0.hashCode()) {
            case -1801488983: {
                if (var4_4.equals("customEvent")) break;
                ** break;
            }
            case 94756344: {
                if (!var4_4.equals("close")) {
                    ** break;
                }
                ** GOTO lbl13
            }
lbl11:
            // 1 sources

            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleQueryAction$lambda$10(android.net.Uri ), ()Ljava/lang/String;)((Uri)uri), (int)7, null);
            ** break;
lbl13:
            // 1 sources

            if (this.type == Type.IN_APP_MESSAGE) {
                v1 = this.inAppMessage;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-BrazeWebViewClient$handleQueryAction$2 = false;
                    v2 = this.inAppMessageWebViewClientListener;
                    if (v2 != null) {
                        v2.onCloseAction(it, url, queryBundle);
                        ** break;
                    }
                }
            } else {
                if (this.type != Type.BANNER) ** break;
                v3 = this.bannerWebViewClientListener;
                if (v3 != null) {
                    v3.onCloseAction(this.context, url, queryBundle);
                    ** break;
                }
            }
            ** break;
        }
        if (this.type == Type.IN_APP_MESSAGE) {
            v4 = this.inAppMessage;
            if (v4 != null) {
                it = v4;
                $i$a$-let-BrazeWebViewClient$handleQueryAction$3 = false;
                v5 = this.inAppMessageWebViewClientListener;
                if (v5 != null) {
                    v5.onCustomEventAction(it, url, queryBundle);
                }
            }
        } else {
            if (this.type != Type.BANNER) ** break;
            v6 = this.bannerWebViewClientListener;
            if (v6 != null) {
                v6.onCustomEventAction(this.context, url, queryBundle);
                ** break;
            }
        }
    }

    public boolean onRenderProcessGone(@NotNull WebView view, @NotNull RenderProcessGoneDetail detail) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, BrazeWebViewClient::onRenderProcessGone$lambda$13, (int)6, null);
        return true;
    }

    private static final String onPageFinished$lambda$2$lambda$1() {
        return "Page has finished loading. Calling onPageFinished on listener";
    }

    private static final String appendBridgeJavascript$lambda$3(BrazeWebViewClient this$0) {
        return "Failed to get HTML " + this$0.type.name() + " javascript additions";
    }

    private static final String markPageFinished$lambda$5$lambda$4() {
        return "Page may not have finished loading, but max wait time has expired. Calling onPageFinished on listener.";
    }

    private static final String handleUrlOverride$lambda$7$lambda$6(String $it) {
        return $it;
    }

    private static final String handleUrlOverride$lambda$8(Uri $uri) {
        return "Uri scheme was null or not an appboy url. Uri: " + $uri;
    }

    private static final String handleQueryAction$lambda$10(Uri $uri) {
        return "Uri authority was null. Uri: " + $uri;
    }

    private static final String onRenderProcessGone$lambda$13() {
        return "The webview rendering process crashed, returning true";
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final Bundle getBundleFromUrl(@NotNull String url) {
        return Companion.getBundleFromUrl(url);
    }

    @JvmStatic
    @Nullable
    public static final String parseCustomEventNameFromQueryBundle(@NotNull Bundle queryBundle) {
        return Companion.parseCustomEventNameFromQueryBundle(queryBundle);
    }

    @JvmStatic
    @NotNull
    public static final BrazeProperties parsePropertiesFromQueryBundle(@NotNull Bundle queryBundle) {
        return Companion.parsePropertiesFromQueryBundle(queryBundle);
    }

    public static final /* synthetic */ void access$markPageFinished(BrazeWebViewClient $this) {
        $this.markPageFinished();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/braze/ui/BrazeWebViewClient$Companion;", "", "<init>", "()V", "BRIDGE_JS_FILE", "", "JAVASCRIPT_PREFIX", "BRAZE_SCHEME", "AUTHORITY_NAME_CLOSE", "AUTHORITY_NAME_CUSTOM_EVENT", "BRAZE_CUSTOM_EVENT_NAME_KEY", "QUERY_NAME_BUTTON_ID", "QUERY_NAME_EXTERNAL_OPEN", "QUERY_NAME_DEEPLINK", "getBundleFromUrl", "Landroid/os/Bundle;", "url", "parseCustomEventNameFromQueryBundle", "queryBundle", "parsePropertiesFromQueryBundle", "Lcom/braze/models/outgoing/BrazeProperties;", "android-sdk-ui_release"})
    @SourceDebugExtension(value={"SMAP\nBrazeWebViewClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeWebViewClient.kt\ncom/braze/ui/BrazeWebViewClient$Companion\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,313:1\n29#2:314\n216#3,2:315\n*S KotlinDebug\n*F\n+ 1 BrazeWebViewClient.kt\ncom/braze/ui/BrazeWebViewClient$Companion\n*L\n285#1:314\n287#1:315,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final Bundle getBundleFromUrl(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Bundle queryBundle = new Bundle();
            if (StringsKt.isBlank((CharSequence)url)) {
                return queryBundle;
            }
            String $this$toUri$iv = url;
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Map<String, String> $this$forEach$iv = UriUtils.getQueryParameters(uri);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator2.next();
                boolean bl = false;
                queryBundle.putString(entry.getKey(), entry.getValue());
            }
            return queryBundle;
        }

        @JvmStatic
        @Nullable
        public final String parseCustomEventNameFromQueryBundle(@NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            return queryBundle.getString(BrazeWebViewClient.BRAZE_CUSTOM_EVENT_NAME_KEY);
        }

        @JvmStatic
        @NotNull
        public final BrazeProperties parsePropertiesFromQueryBundle(@NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeProperties customEventProperties = new BrazeProperties();
            for (String key : queryBundle.keySet()) {
                String propertyValue;
                CharSequence charSequence;
                if (Intrinsics.areEqual((Object)key, (Object)BrazeWebViewClient.BRAZE_CUSTOM_EVENT_NAME_KEY) || (charSequence = (CharSequence)(propertyValue = queryBundle.getString(key, null))) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                Intrinsics.checkNotNull((Object)key);
                customEventProperties.addProperty(key, (Object)propertyValue);
            }
            return customEventProperties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/braze/ui/BrazeWebViewClient$Type;", "", "<init>", "(Ljava/lang/String;I)V", "BANNER", "IN_APP_MESSAGE", "android-sdk-ui_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BANNER = new Type();
        public static final /* enum */ Type IN_APP_MESSAGE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.BANNER, Type.IN_APP_MESSAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.IN_APP_MESSAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.BANNER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

