/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.banners.listeners;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.enums.Channel;
import com.braze.models.outgoing.BrazeProperties;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.BrazeWebViewClient;
import com.braze.ui.actions.UriAction;
import com.braze.ui.banners.listeners.IBannerWebViewClientListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/braze/ui/banners/listeners/DefaultBannerWebViewClientListener;", "Lcom/braze/ui/banners/listeners/IBannerWebViewClientListener;", "<init>", "()V", "onCloseAction", "", "context", "Landroid/content/Context;", "url", "", "queryBundle", "Landroid/os/Bundle;", "onCustomEventAction", "onOtherUrlAction", "Companion", "android-sdk-ui_release"})
public class DefaultBannerWebViewClientListener
implements IBannerWebViewClientListener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void onCloseAction(@NotNull Context context, @NotNull String url, @NotNull Bundle queryBundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, DefaultBannerWebViewClientListener::onCloseAction$lambda$0, (int)6, null);
    }

    @Override
    public void onCustomEventAction(@NotNull Context context, @NotNull String url, @NotNull Bundle queryBundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultBannerWebViewClientListener::onCustomEventAction$lambda$1, (int)7, null);
        String customEventName = BrazeWebViewClient.Companion.parseCustomEventNameFromQueryBundle(queryBundle);
        CharSequence charSequence = customEventName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        BrazeProperties customEventProperties = BrazeWebViewClient.Companion.parsePropertiesFromQueryBundle(queryBundle);
        Braze.Companion.getInstance(context).logCustomEvent(customEventName, customEventProperties);
    }

    @Override
    public void onOtherUrlAction(@NotNull Context context, @NotNull String url, @NotNull Bundle queryBundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultBannerWebViewClientListener::onOtherUrlAction$lambda$2, (int)7, null);
        boolean useWebViewForWebLinks = Companion.parseUseWebViewFromQueryBundle(queryBundle);
        UriAction uriAction = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, queryBundle, useWebViewForWebLinks, Channel.BANNER);
        if (uriAction == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> DefaultBannerWebViewClientListener.onOtherUrlAction$lambda$3(url), (int)6, null);
            return;
        }
        Uri uri = uriAction.getUri();
        if (BrazeFileUtils.isLocalUri((Uri)uri)) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> DefaultBannerWebViewClientListener.onOtherUrlAction$lambda$4(uri, url), (int)6, null);
            return;
        }
        BrazeDeeplinkHandler.Companion.getInstance().gotoUri(context, uriAction);
    }

    private static final String onCloseAction$lambda$0() {
        return "Close action not available on Banners.";
    }

    private static final String onCustomEventAction$lambda$1() {
        return "DefaultBannerWebViewClientListener.onCustomEventAction called.";
    }

    private static final String onOtherUrlAction$lambda$2() {
        return "DefaultBannerWebViewClientListener.onOtherUrlAction called.";
    }

    private static final String onOtherUrlAction$lambda$3(String $url) {
        return "UriAction is null. Not passing any URI to BrazeDeeplinkHandler. Url: " + $url + '.';
    }

    private static final String onOtherUrlAction$lambda$4(Uri $uri, String $url) {
        return "Not passing local uri to BrazeDeeplinkHandler. Got local uri: " + $uri + " for url: " + $url + '.';
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean parseUseWebViewFromQueryBundle(@NotNull Bundle queryBundle) {
        return Companion.parseUseWebViewFromQueryBundle(queryBundle);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/braze/ui/banners/listeners/DefaultBannerWebViewClientListener$Companion;", "", "<init>", "()V", "parseUseWebViewFromQueryBundle", "", "queryBundle", "Landroid/os/Bundle;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean parseUseWebViewFromQueryBundle(@NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            boolean isAnyQueryFlagSet = false;
            boolean isDeepLinkFlagSet = false;
            if (queryBundle.containsKey("abDeepLink")) {
                isDeepLinkFlagSet = Boolean.parseBoolean(queryBundle.getString("abDeepLink"));
                isAnyQueryFlagSet = true;
            }
            boolean isExternalOpenFlagSet = false;
            if (queryBundle.containsKey("abExternalOpen")) {
                isExternalOpenFlagSet = Boolean.parseBoolean(queryBundle.getString("abExternalOpen"));
                isAnyQueryFlagSet = true;
            }
            boolean useWebViewForWebLinks = true;
            if (isAnyQueryFlagSet) {
                useWebViewForWebLinks = !isDeepLinkFlagSet && !isExternalOpenFlagSet;
            }
            return useWebViewForWebLinks;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

