/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.listeners;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.braze.Braze;
import com.braze.enums.Channel;
import com.braze.enums.inappmessage.MessageType;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageHtml;
import com.braze.models.outgoing.BrazeProperties;
import com.braze.support.BrazeFileUtils;
import com.braze.support.BrazeLogger;
import com.braze.support.BundleUtils;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.BrazeWebViewClient;
import com.braze.ui.actions.UriAction;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.listeners.IInAppMessageWebViewClientListener;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/braze/ui/inappmessage/listeners/DefaultInAppMessageWebViewClientListener;", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageWebViewClientListener;", "<init>", "()V", "inAppMessageManager", "Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "getInAppMessageManager", "()Lcom/braze/ui/inappmessage/BrazeInAppMessageManager;", "onCloseAction", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "url", "", "queryBundle", "Landroid/os/Bundle;", "onCustomEventAction", "onOtherUrlAction", "Companion", "android-sdk-ui_release"})
public class DefaultInAppMessageWebViewClientListener
implements IInAppMessageWebViewClientListener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final BrazeInAppMessageManager getInAppMessageManager() {
        return BrazeInAppMessageManager.Companion.getInstance();
    }

    @Override
    public void onCloseAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageWebViewClientListener::onCloseAction$lambda$0, (int)7, null);
        Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
        this.getInAppMessageManager().hideCurrentlyDisplayingInAppMessage(true);
        this.getInAppMessageManager().getHtmlInAppMessageActionListener().onCloseClicked(inAppMessage, url, queryBundle);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageWebViewClientListener::onCloseAction$lambda$1, (int)7, null);
    }

    @Override
    public void onCustomEventAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageWebViewClientListener::onCustomEventAction$lambda$2, (int)7, null);
            if (this.getInAppMessageManager().getActivity() == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, DefaultInAppMessageWebViewClientListener::onCustomEventAction$lambda$3, (int)6, null);
                return;
            }
            boolean wasHandled = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onCustomEventFired(inAppMessage, url, queryBundle);
            if (wasHandled) break block3;
            String customEventName = BrazeWebViewClient.Companion.parseCustomEventNameFromQueryBundle(queryBundle);
            CharSequence charSequence = customEventName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return;
            }
            BrazeProperties customEventProperties = BrazeWebViewClient.Companion.parsePropertiesFromQueryBundle(queryBundle);
            Activity activity = this.getInAppMessageManager().getActivity();
            if (activity != null) {
                Activity activity2 = activity;
                boolean bl = false;
                Braze.Companion.getInstance((Context)activity2).logCustomEvent(customEventName, customEventProperties);
            }
        }
    }

    @Override
    public void onOtherUrlAction(@NotNull IInAppMessage inAppMessage, @NotNull String url, @NotNull Bundle queryBundle) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, DefaultInAppMessageWebViewClientListener::onOtherUrlAction$lambda$5, (int)7, null);
            if (this.getInAppMessageManager().getActivity() == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> DefaultInAppMessageWebViewClientListener.onOtherUrlAction$lambda$6(url), (int)6, null);
                return;
            }
            Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
            boolean wasHandled = this.getInAppMessageManager().getHtmlInAppMessageActionListener().onOtherUrlAction(inAppMessage, url, queryBundle);
            if (wasHandled) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> DefaultInAppMessageWebViewClientListener.onOtherUrlAction$lambda$7(url), (int)6, null);
                return;
            }
            boolean useWebViewForWebLinks = Companion.parseUseWebViewFromQueryBundle(inAppMessage, queryBundle);
            Bundle inAppMessageBundle = BundleUtils.toBundle((Map)inAppMessage.getExtras());
            inAppMessageBundle.putAll(queryBundle);
            UriAction uriAction = BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, inAppMessageBundle, useWebViewForWebLinks, Channel.INAPP_MESSAGE);
            if (uriAction == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> DefaultInAppMessageWebViewClientListener.onOtherUrlAction$lambda$8(url), (int)6, null);
                return;
            }
            Uri uri = uriAction.getUri();
            if (BrazeFileUtils.isLocalUri((Uri)uri)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, () -> DefaultInAppMessageWebViewClientListener.onOtherUrlAction$lambda$9(uri, url), (int)6, null);
                return;
            }
            inAppMessage.setAnimateOut(false);
            this.getInAppMessageManager().hideCurrentlyDisplayingInAppMessage(false);
            Activity activity = this.getInAppMessageManager().getActivity();
            if (activity == null) break block4;
            Activity activity2 = activity;
            boolean bl = false;
            BrazeDeeplinkHandler.Companion.getInstance().gotoUri((Context)activity2, uriAction);
        }
    }

    private static final String onCloseAction$lambda$0() {
        return "IInAppMessageWebViewClientListener.onCloseAction called.";
    }

    private static final String onCloseAction$lambda$1() {
        return "IInAppMessageWebViewClientListener.onCloseAction finished.";
    }

    private static final String onCustomEventAction$lambda$2() {
        return "IInAppMessageWebViewClientListener.onCustomEventAction called.";
    }

    private static final String onCustomEventAction$lambda$3() {
        return "Can't perform custom event action because the activity is null.";
    }

    private static final String onOtherUrlAction$lambda$5() {
        return "IInAppMessageWebViewClientListener.onOtherUrlAction called.";
    }

    private static final String onOtherUrlAction$lambda$6(String $url) {
        return "Can't perform other url action because the cached activity is null. Url: " + $url;
    }

    private static final String onOtherUrlAction$lambda$7(String $url) {
        return "HTML message action listener handled url in onOtherUrlAction. Doing nothing further. Url: " + $url;
    }

    private static final String onOtherUrlAction$lambda$8(String $url) {
        return "UriAction is null. Not passing any URI to BrazeDeeplinkHandler. Url: " + $url;
    }

    private static final String onOtherUrlAction$lambda$9(Uri $uri, String $url) {
        return "Not passing local uri to BrazeDeeplinkHandler. Got local uri: " + $uri + " for url: " + $url;
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean parseUseWebViewFromQueryBundle(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
        return Companion.parseUseWebViewFromQueryBundle(inAppMessage, queryBundle);
    }

    @JvmStatic
    @VisibleForTesting
    public static final void logHtmlInAppMessageClick(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
        Companion.logHtmlInAppMessageClick(inAppMessage, queryBundle);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/braze/ui/inappmessage/listeners/DefaultInAppMessageWebViewClientListener$Companion;", "", "<init>", "()V", "parseUseWebViewFromQueryBundle", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "queryBundle", "Landroid/os/Bundle;", "logHtmlInAppMessageClick", "", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean parseUseWebViewFromQueryBundle(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            boolean isAnyQueryFlagSet = false;
            boolean isDeepLinkFlagSet = false;
            if (queryBundle.containsKey("abDeepLink")) {
                isDeepLinkFlagSet = Boolean.parseBoolean(queryBundle.getString("abDeepLink"));
                isAnyQueryFlagSet = true;
            }
            boolean isExternalOpenFlagSet = false;
            if (queryBundle.containsKey("abExternalOpen")) {
                isExternalOpenFlagSet = Boolean.parseBoolean(queryBundle.getString("abExternalOpen"));
                isAnyQueryFlagSet = true;
            }
            boolean useWebViewForWebLinks = inAppMessage.getOpenUriInWebView();
            if (isAnyQueryFlagSet) {
                useWebViewForWebLinks = !isDeepLinkFlagSet && !isExternalOpenFlagSet;
            }
            return useWebViewForWebLinks;
        }

        @JvmStatic
        @VisibleForTesting
        public final void logHtmlInAppMessageClick(@NotNull IInAppMessage inAppMessage, @NotNull Bundle queryBundle) {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            Intrinsics.checkNotNullParameter((Object)queryBundle, (String)"queryBundle");
            if (queryBundle.containsKey("abButtonId")) {
                IInAppMessageHtml inAppMessageHtml = (IInAppMessageHtml)inAppMessage;
                String string2 = queryBundle.getString("abButtonId");
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    inAppMessageHtml.logButtonClick(it);
                }
            } else if (inAppMessage.getMessageType() == MessageType.HTML_FULL) {
                inAppMessage.logClick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

