/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.braze.models.inappmessage.MessageButton;
import com.braze.ui.R;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0007J0\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u00a8\u0006\u001b"}, d2={"Lcom/braze/ui/inappmessage/utils/InAppMessageButtonViewUtils;", "", "<init>", "()V", "setButtons", "", "buttonViews", "", "Landroid/view/View;", "messageButtons", "Lcom/braze/models/inappmessage/MessageButton;", "setButton", "button", "Landroid/widget/Button;", "messageButton", "strokeWidth", "", "strokeFocusedWidth", "getDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "drawableId", "getButtonDrawable", "newStrokeWidth", "isFocused", "", "android-sdk-ui_release"})
public final class InAppMessageButtonViewUtils {
    @NotNull
    public static final InAppMessageButtonViewUtils INSTANCE = new InAppMessageButtonViewUtils();

    private InAppMessageButtonViewUtils() {
    }

    @JvmStatic
    public static final void setButtons(@NotNull List<? extends View> buttonViews, @NotNull List<? extends MessageButton> messageButtons) {
        Intrinsics.checkNotNullParameter(buttonViews, (String)"buttonViews");
        Intrinsics.checkNotNullParameter(messageButtons, (String)"messageButtons");
        int n = ((Collection)buttonViews).size();
        for (int i = 0; i < n; ++i) {
            View buttonView = buttonViews.get(i);
            MessageButton messageButton = messageButtons.get(i);
            int strokeWidth = buttonView.getContext().getResources().getDimensionPixelSize(R.dimen.com_braze_inappmessage_button_border_stroke);
            int strokeFocusedWidth = buttonView.getContext().getResources().getDimensionPixelSize(R.dimen.com_braze_inappmessage_button_border_stroke_focused);
            if (messageButtons.size() <= i) {
                buttonView.setVisibility(8);
                continue;
            }
            if (!(buttonView instanceof Button)) continue;
            InAppMessageButtonViewUtils.setButton((Button)buttonView, messageButton, strokeWidth, strokeFocusedWidth);
        }
    }

    @JvmStatic
    public static final void setButton(@NotNull Button button, @NotNull MessageButton messageButton, int strokeWidth, int strokeFocusedWidth) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)messageButton, (String)"messageButton");
        button.setText((CharSequence)messageButton.getText());
        button.setContentDescription((CharSequence)messageButton.getText());
        InAppMessageViewUtils.setTextViewColor((TextView)button, messageButton.getTextColor());
        StateListDrawable stateListDrawableBackground = new StateListDrawable();
        button.setStateListAnimator(null);
        Context context = button.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Drawable defaultButtonDrawable = InAppMessageButtonViewUtils.getButtonDrawable(context, messageButton, strokeWidth, strokeFocusedWidth, false);
        Context context2 = button.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        Drawable focusedButtonDrawable = InAppMessageButtonViewUtils.getButtonDrawable(context2, messageButton, strokeWidth, strokeFocusedWidth, true);
        int[] nArray = new int[]{16842908};
        stateListDrawableBackground.addState(nArray, focusedButtonDrawable);
        nArray = new int[]{16842910};
        stateListDrawableBackground.addState(nArray, defaultButtonDrawable);
        button.setBackground((Drawable)stateListDrawableBackground);
    }

    @JvmStatic
    @NotNull
    public static final Drawable getDrawable(@NotNull Context context, int drawableId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable2 = context.getResources().getDrawable(drawableId, null);
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    @JvmStatic
    @NotNull
    public static final Drawable getButtonDrawable(@NotNull Context context, @NotNull MessageButton messageButton, int newStrokeWidth, int strokeFocusedWidth, boolean isFocused) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)messageButton, (String)"messageButton");
        Drawable buttonDrawable = InAppMessageButtonViewUtils.getDrawable(context, R.drawable.com_braze_inappmessage_button_background);
        buttonDrawable.mutate();
        Intrinsics.checkNotNull((Object)buttonDrawable, (String)"null cannot be cast to non-null type android.graphics.drawable.RippleDrawable");
        Drawable drawable2 = ((RippleDrawable)buttonDrawable).findDrawableByLayerId(R.id.com_braze_inappmessage_button_background_ripple_internal_gradient);
        Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
        GradientDrawable backgroundFillGradientDrawable = (GradientDrawable)drawable2;
        int strokeWidth = newStrokeWidth;
        if (isFocused) {
            strokeWidth = strokeFocusedWidth;
        }
        backgroundFillGradientDrawable.setStroke(strokeWidth, messageButton.getBorderColor());
        backgroundFillGradientDrawable.setColor(messageButton.getBackgroundColor());
        return buttonDrawable;
    }
}

