/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage.views;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.window.BackEvent;
import androidx.core.view.WindowInsetsCompat;
import com.braze.enums.inappmessage.TextAlign;
import com.braze.models.inappmessage.IInAppMessageWithImage;
import com.braze.support.BrazeLogger;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import com.braze.ui.inappmessage.views.IInAppMessageBackEventListener;
import com.braze.ui.inappmessage.views.IInAppMessageView;
import com.braze.ui.support.ViewUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 =2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001=B\u001b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\u00020#2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%H\u0016J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\u000fH\u0016J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020#H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006>"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageBaseView;", "Landroid/widget/RelativeLayout;", "Lcom/braze/ui/inappmessage/views/IInAppMessageView;", "Lcom/braze/ui/inappmessage/views/IInAppMessageBackEventListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "messageClickableView", "Landroid/view/View;", "getMessageClickableView", "()Landroid/view/View;", "hasAppliedWindowInsets", "", "getHasAppliedWindowInsets", "()Z", "setHasAppliedWindowInsets", "(Z)V", "messageTextView", "Landroid/widget/TextView;", "getMessageTextView", "()Landroid/widget/TextView;", "messageImageView", "Landroid/widget/ImageView;", "getMessageImageView", "()Landroid/widget/ImageView;", "messageIconView", "getMessageIconView", "messageBackgroundObject", "", "getMessageBackgroundObject", "()Ljava/lang/Object;", "setMessageBackgroundColor", "", "color", "", "setMessageTextColor", "setMessageTextAlign", "textAlign", "Lcom/braze/enums/inappmessage/TextAlign;", "setMessage", "text", "", "setMessageImageView", "bitmap", "Landroid/graphics/Bitmap;", "setMessageIcon", "icon", "iconColor", "iconBackgroundColor", "resetMessageMargins", "imageRetrievalSuccessful", "applyWindowInsets", "insets", "Landroidx/core/view/WindowInsetsCompat;", "onBackProgressed", "backEvent", "Landroid/window/BackEvent;", "onBackCancelled", "Companion", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nInAppMessageBaseView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppMessageBaseView.kt\ncom/braze/ui/inappmessage/views/InAppMessageBaseView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public abstract class InAppMessageBaseView
extends RelativeLayout
implements IInAppMessageView,
IInAppMessageBackEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasAppliedWindowInsets;
    private static final float PREDICTIVE_BACK_MAX_SCALE_FACTOR = 0.85f;
    private static final int TRANSLATE_X_FACTOR = 2;
    private static final int TRANSLATE_Y_FACTOR = 8;

    public InAppMessageBaseView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @Nullable
    public View getMessageClickableView() {
        return (View)this;
    }

    @Override
    public boolean getHasAppliedWindowInsets() {
        return this.hasAppliedWindowInsets;
    }

    @Override
    public void setHasAppliedWindowInsets(boolean bl) {
        this.hasAppliedWindowInsets = bl;
    }

    @Nullable
    public abstract TextView getMessageTextView();

    @Nullable
    public abstract ImageView getMessageImageView();

    @Nullable
    public abstract TextView getMessageIconView();

    @Nullable
    public abstract Object getMessageBackgroundObject();

    public void setMessageBackgroundColor(int color2) {
        Object object = this.getMessageBackgroundObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.View");
        InAppMessageViewUtils.setViewBackgroundColor((View)object, color2);
    }

    public void setMessageTextColor(int color2) {
        block0: {
            TextView textView = this.getMessageTextView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            InAppMessageViewUtils.setTextViewColor(it, color2);
        }
    }

    public void setMessageTextAlign(@NotNull TextAlign textAlign) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            TextView textView = this.getMessageTextView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            InAppMessageViewUtils.setTextAlignment(it, textAlign);
        }
    }

    public void setMessage(@NotNull String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            TextView textView = this.getMessageTextView();
            if (textView == null) break block0;
            textView.setText((CharSequence)text);
        }
    }

    public void setMessageImageView(@NotNull Bitmap bitmap) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            ImageView imageView = this.getMessageImageView();
            if (imageView == null) break block0;
            ImageView it = imageView;
            boolean bl = false;
            InAppMessageViewUtils.setImage(bitmap, it);
        }
    }

    public void setMessageIcon(@NotNull String icon, int iconColor, int iconBackgroundColor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            TextView textView = this.getMessageIconView();
            if (textView == null) break block0;
            TextView it = textView;
            boolean bl = false;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            InAppMessageViewUtils.setIcon(context, icon, iconColor, iconBackgroundColor, it);
        }
    }

    public void resetMessageMargins(boolean imageRetrievalSuccessful) {
        Object object;
        ImageView imageView = this.getMessageImageView();
        if (imageView != null) {
            ImageView it = imageView;
            boolean bl = false;
            if (!imageRetrievalSuccessful) {
                ViewUtils.removeViewFromParent((View)it);
            } else {
                ViewUtils.removeViewFromParent((View)this.getMessageIconView());
            }
        }
        boolean bl = (object = this.getMessageIconView()) != null && (object = object.getText()) != null && (object = object.toString()) != null ? StringsKt.isBlank((CharSequence)((CharSequence)object)) : false;
        if (bl) {
            ViewUtils.removeViewFromParent((View)this.getMessageIconView());
        }
    }

    @Override
    public void applyWindowInsets(@NotNull WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        this.setHasAppliedWindowInsets(true);
    }

    @Override
    public void onBackProgressed(@NotNull BackEvent backEvent) {
        Intrinsics.checkNotNullParameter((Object)backEvent, (String)"backEvent");
        if (Build.VERSION.SDK_INT >= 34) {
            float originalWidth = this.getWidth();
            float originalHeight = this.getHeight();
            float scaledWidth = originalWidth * 0.85f;
            float scaledHeight = originalHeight * 0.85f;
            AnimatorSet animatorSet = new AnimatorSet();
            Animator[] animatorArray = new Animator[4];
            float[] fArray = new float[]{0.85f};
            animatorArray[0] = ObjectAnimator.ofFloat((Object)this, (String)"scaleX", (float[])fArray);
            fArray = new float[]{0.85f};
            animatorArray[1] = ObjectAnimator.ofFloat((Object)this, (String)"scaleY", (float[])fArray);
            fArray = new float[]{(originalWidth - scaledWidth) / (float)2};
            animatorArray[2] = ObjectAnimator.ofFloat((Object)this, (String)"translationX", (float[])fArray);
            fArray = new float[]{(originalHeight - scaledHeight) / (float)8};
            animatorArray[3] = ObjectAnimator.ofFloat((Object)this, (String)"translationY", (float[])fArray);
            animatorSet.playTogether(animatorArray);
            animatorSet.start();
        }
    }

    @Override
    public void onBackCancelled() {
        AnimatorSet animatorSet = new AnimatorSet();
        Animator[] animatorArray = new Animator[3];
        float[] fArray = new float[]{1.0f};
        animatorArray[0] = ObjectAnimator.ofFloat((Object)this, (String)"scaleX", (float[])fArray);
        fArray = new float[]{1.0f};
        animatorArray[1] = ObjectAnimator.ofFloat((Object)this, (String)"scaleY", (float[])fArray);
        fArray = new float[]{0.0f};
        animatorArray[2] = ObjectAnimator.ofFloat((Object)this, (String)"translationX", (float[])fArray);
        animatorSet.playTogether(animatorArray);
        animatorSet.start();
    }

    @JvmStatic
    @Nullable
    public static final String getAppropriateImageUrl(@NotNull IInAppMessageWithImage inAppMessage) {
        return Companion.getAppropriateImageUrl(inAppMessage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/braze/ui/inappmessage/views/InAppMessageBaseView$Companion;", "", "<init>", "()V", "PREDICTIVE_BACK_MAX_SCALE_FACTOR", "", "TRANSLATE_X_FACTOR", "", "TRANSLATE_Y_FACTOR", "getAppropriateImageUrl", "", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessageWithImage;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String getAppropriateImageUrl(@NotNull IInAppMessageWithImage inAppMessage) {
            Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
            String localImagePath = inAppMessage.getLocalImageUrl();
            CharSequence charSequence = localImagePath;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                File imageFile = new File(localImagePath);
                if (imageFile.exists()) {
                    return localImagePath;
                }
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.D, null, (boolean)false, () -> Companion.getAppropriateImageUrl$lambda$0(localImagePath), (int)6, null);
            }
            return inAppMessage.getRemoteImageUrl();
        }

        private static final String getAppropriateImageUrl$lambda$0(String $localImagePath) {
            return "Local bitmap file does not exist. Using remote url instead. Local path: " + $localImagePath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

