/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.support;

import android.annotation.SuppressLint;
import android.content.Context;
import android.webkit.WebSettings;
import androidx.webkit.WebSettingsCompat;
import androidx.webkit.WebViewFeature;
import com.braze.support.BrazeLogger;
import com.braze.ui.support.ViewUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"TAG", "", "setWebViewSettings", "", "settings", "Landroid/webkit/WebSettings;", "context", "Landroid/content/Context;", "android-sdk-ui_release"})
public final class WebViewUtilsKt {
    @NotNull
    private static final String TAG = BrazeLogger.INSTANCE.getBrazeLogTag("WebViewUtils");

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static final void setWebViewSettings(@NotNull WebSettings settings, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        settings.setJavaScriptEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        settings.setDisplayZoomControls(false);
        settings.setDomStorageEnabled(true);
        settings.setAllowFileAccess(false);
        try {
            if (WebViewFeature.isFeatureSupported((String)"FORCE_DARK") && ViewUtils.isDeviceInNightMode(context)) {
                WebSettingsCompat.setForceDark((WebSettings)settings, (int)2);
            }
            if (WebViewFeature.isFeatureSupported((String)"FORCE_DARK_STRATEGY")) {
                WebSettingsCompat.setForceDarkStrategy((WebSettings)settings, (int)1);
            }
        }
        catch (Throwable e) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (String)TAG, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, WebViewUtilsKt::setWebViewSettings$lambda$0, (int)8, null);
        }
    }

    private static final String setWebViewSettings$lambda$0() {
        return "Failed to set dark mode WebView settings.";
    }
}

