/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.BrazeViewBounds;
import com.braze.images.IBrazeImageLoader;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.actions.UriAction;
import com.braze.ui.contentcards.BrazeContentCardUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001#B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nJ&\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u0002J\"\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010!H\u0004J\"\u0010\"\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010!H$R\u0010\u0010\b\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00018\u00008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/braze/ui/widget/BaseCardView;", "T", "Lcom/braze/models/cards/Card;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "applicationContext", "classLogTag", "", "getClassLogTag", "()Ljava/lang/String;", "card", "Lcom/braze/models/cards/Card;", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "isUnreadIndicatorEnabled", "", "()Z", "setOptionalTextView", "", "view", "Landroid/widget/TextView;", "text", "setImageViewToUrl", "imageView", "Landroid/widget/ImageView;", "imageUrl", "placeholderAspectRatio", "", "handleCardClick", "cardAction", "Lcom/braze/ui/actions/IAction;", "isClickHandled", "Companion", "android-sdk-ui_release"})
public abstract class BaseCardView<T extends Card>
extends RelativeLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Context applicationContext;
    @NotNull
    private final String classLogTag;
    @JvmField
    @Nullable
    protected T card;
    @JvmField
    @NotNull
    protected BrazeConfigurationProvider configurationProvider;

    public BaseCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.applicationContext = context2;
        this.classLogTag = BrazeLogger.getBrazeLogTag(((Object)((Object)this)).getClass());
        this.configurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context);
    }

    @NotNull
    public final String getClassLogTag() {
        return this.classLogTag;
    }

    public final boolean isUnreadIndicatorEnabled() {
        return this.configurationProvider.isContentCardsUnreadVisualIndicatorEnabled();
    }

    public final void setOptionalTextView(@NotNull TextView view, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        CharSequence charSequence = text;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            view.setText((CharSequence)text);
            view.setVisibility(0);
        } else {
            view.setText((CharSequence)"");
            view.setVisibility(8);
        }
    }

    public final void setImageViewToUrl(@NotNull ImageView imageView, @NotNull String imageUrl, float placeholderAspectRatio, @NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (!Intrinsics.areEqual((Object)imageUrl, (Object)imageView.getTag(R.string.com_braze_image_resize_tag_key))) {
            ViewTreeObserver viewTreeObserver;
            if (!(placeholderAspectRatio == 0.0f) && (viewTreeObserver = imageView.getViewTreeObserver()).isAlive()) {
                viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(imageView, placeholderAspectRatio){
                    final /* synthetic */ ImageView $imageView;
                    final /* synthetic */ float $placeholderAspectRatio;
                    {
                        this.$imageView = $imageView;
                        this.$placeholderAspectRatio = $placeholderAspectRatio;
                    }

                    public boolean onPreDraw() {
                        this.$imageView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        int width = this.$imageView.getWidth();
                        this.$imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, (int)((float)width / this.$placeholderAspectRatio)));
                        return true;
                    }
                });
            }
            imageView.setImageResource(17170445);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            IBrazeImageLoader iBrazeImageLoader = Braze.Companion.getInstance(context).getImageLoader();
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            iBrazeImageLoader.renderUrlIntoCardView(context2, card, imageUrl, imageView, BrazeViewBounds.BASE_CARD_VIEW);
            imageView.setTag(R.string.com_braze_image_resize_tag_key, (Object)imageUrl);
        }
    }

    protected final void handleCardClick(@NotNull Context context, @NotNull Card card, @Nullable IAction cardAction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BaseCardView.handleCardClick$lambda$0(card), (int)6, null);
        card.setIndicatorHighlighted(true);
        if (!this.isClickHandled(context, card, cardAction)) {
            if (cardAction != null) {
                card.logClick();
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BaseCardView.handleCardClick$lambda$1(card), (int)6, null);
                if (cardAction instanceof UriAction) {
                    BrazeDeeplinkHandler.Companion.getInstance().gotoUri(context, (UriAction)cardAction);
                } else {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (boolean)false, () -> BaseCardView.handleCardClick$lambda$2(card), (int)7, null);
                    cardAction.execute(context);
                }
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, () -> BaseCardView.handleCardClick$lambda$3(card), (int)6, null);
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)((Object)this), null, null, (boolean)false, () -> BaseCardView.handleCardClick$lambda$4(card), (int)7, null);
            card.logClick();
        }
    }

    protected abstract boolean isClickHandled(@NotNull Context var1, @NotNull Card var2, @Nullable IAction var3);

    private static final String handleCardClick$lambda$0(Card $card) {
        return "Handling card click for card: " + $card;
    }

    private static final String handleCardClick$lambda$1(Card $card) {
        return "Card action is non-null. Attempting to perform action on card: " + $card.getId();
    }

    private static final String handleCardClick$lambda$2(Card $card) {
        return "Executing non uri action for click on card: " + $card.getId();
    }

    private static final String handleCardClick$lambda$3(Card $card) {
        return "Card action is null. Not performing any click action on card: " + $card.getId();
    }

    private static final String handleCardClick$lambda$4(Card $card) {
        return "Card click was handled by custom listener on card: " + $card.getId();
    }

    @JvmStatic
    @Nullable
    protected static final UriAction getUriActionForCard(@NotNull Card card) {
        return Companion.getUriActionForCard(card);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0005\u00a8\u0006\b"}, d2={"Lcom/braze/ui/widget/BaseCardView$Companion;", "", "<init>", "()V", "getUriActionForCard", "Lcom/braze/ui/actions/UriAction;", "card", "Lcom/braze/models/cards/Card;", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        protected final UriAction getUriActionForCard(@NotNull Card card) {
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            return BrazeContentCardUtils.INSTANCE.getUriActionForCard(card);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

