/*
 * Decompiled with CFR 0.152.
 */
package com.brettonw.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class Resolver {
    public static URL[] get(String groupId, String artifactId, String version, String repositoryUrl, File repositoryPath) throws DependencyResolutionException {
        if (version == null) {
            version = "RELEASE";
        }
        if (repositoryUrl == null) {
            repositoryUrl = "http://central.maven.org/maven2/";
        }
        if (repositoryPath == null) {
            repositoryPath = new File("m2");
        }
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator().addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class).addService(TransporterFactory.class, FileTransporterFactory.class).addService(TransporterFactory.class, HttpTransporterFactory.class);
        RepositorySystem system = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(repositoryPath);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        session.setUpdatePolicy("always");
        CollectRequest collectRequest = new CollectRequest();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "jar", version);
        collectRequest.setRoot(new Dependency((Artifact)artifact, "runtime"));
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>(1);
        repositories.add(new RemoteRepository.Builder("default", "default", repositoryUrl).build());
        collectRequest.setRepositories(repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}));
        List artifactResults = system.resolveDependencies((RepositorySystemSession)session, dependencyRequest).getArtifactResults();
        URL[] result = new URL[artifactResults.size()];
        int i = 0;
        for (ArtifactResult artifactResult : artifactResults) {
            File fileInRepository = artifactResult.getArtifact().getFile();
            try {
                result[i++] = fileInRepository.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }
}

