/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.testassist;

import com.browserstack.automate.testassist.EventType;
import com.browserstack.automate.testassist.RecordedData;
import com.browserstack.automate.testassist.TestSessionRecorder;
import com.browserstack.automate.testassist.UnitTestCase;
import com.browserstack.automate.testassist.WebDriverInstance;
import java.io.PrintStream;
import java.util.LinkedList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

@Aspect
public class AutomateAspects {
    private static final String TEST_FORMAT_HASH = "hash";
    private static final String TEST_FORMAT_NAME = "name";
    private static final String TEST_FORMAT = System.getProperty("browserstack.automate.test.format", "hash");
    private static final String OUTPUT_FORMAT = "browserstack:session:%s:test:%s";
    private TestSessionRecorder recorder = TestSessionRecorder.getInstance();
    private PrintStream outStream = System.out;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AutomateAspects ajc$perSingletonInstance;

    static {
        try {
            AutomateAspects.ajc$perSingletonInstance = new AutomateAspects();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(public org.openqa.selenium.remote.RemoteWebDriver.new(..))")
    public /* synthetic */ void webDriverConstructor() {
    }

    @Pointcut(value="execution(public void org.openqa.selenium.remote.RemoteWebDriver.quit())")
    public /* synthetic */ void webDriverQuit() {
    }

    @Pointcut(value="execution(@org.junit.Test * *(..))")
    public /* synthetic */ void junitTestCase() {
    }

    @Pointcut(value="execution(@org.testng.annotations.Test * *(..))")
    public /* synthetic */ void testngTestCase() {
    }

    @Before(value="junitTestCase() || testngTestCase()")
    public void beforeTestCase(JoinPoint joinPoint) {
        TestSessionRecorder.getInstance().recordClassHierarchy(joinPoint.getTarget());
        String testSignature = TestSessionRecorder.getSignature(joinPoint);
        UnitTestCase unitTestCase = new UnitTestCase(joinPoint, testSignature, this.recorder.getTestCaseIndex(joinPoint));
        this.recorder.getCapturedTestCases().add(unitTestCase);
        if (TestSessionRecorder.DEBUG) {
            System.out.println(">>> ADD TC: " + unitTestCase.data);
        }
        this.recorder.setLastEventType(EventType.TEST_START);
    }

    @After(value="junitTestCase() || testngTestCase()")
    public void afterTestCase(JoinPoint joinPoint) {
        String testSignature = TestSessionRecorder.getSignature(joinPoint);
        UnitTestCase tc = (UnitTestCase)this.recorder.findAndRemoveEvent(testSignature, this.recorder.getCapturedTestCases());
        if (tc != null) {
            String sessionId;
            if (TestSessionRecorder.DEBUG) {
                System.out.println(">>> REMOVE TC: " + tc.data);
            }
            if (this.recorder.getLastEventType() == EventType.WD_END) {
                sessionId = this.recorder.getLastSessionId();
            } else {
                LinkedList<WebDriverInstance> capturedWebDrivers = this.recorder.getCapturedWebDrivers();
                if (TestSessionRecorder.DEBUG) {
                    System.out.println(">>> REMOVE TC: capturedWebDrivers: " + capturedWebDrivers.size() + " | Thread: " + Thread.currentThread().getId());
                }
                sessionId = !capturedWebDrivers.isEmpty() ? capturedWebDrivers.getLast().data : TestSessionRecorder.getInstance().findSessionIdForClass(joinPoint.getTarget());
            }
            if (sessionId != null) {
                if (TestSessionRecorder.DEBUG) {
                    System.out.println(">>> REMOVE TC: sessionId: " + sessionId);
                }
                this.recorder.linkSessionIdToTestCase(sessionId, tc);
                String sessionInfo = String.format(OUTPUT_FORMAT, sessionId, TEST_FORMAT.equals(TEST_FORMAT_NAME) ? tc.getUniqueName() : tc.getTestHash());
                this.outStream.println(sessionInfo);
                this.recorder.setLastEventType(EventType.TEST_END);
            }
        }
    }

    @Before(value="webDriverConstructor()")
    public void beforeNewWebDriver(JoinPoint joinPoint) {
        Object[] constructorArgs;
        Object target = joinPoint.getTarget();
        if (target instanceof RemoteWebDriver && TestSessionRecorder.isBrowserStackWebDriver(joinPoint) && (constructorArgs = joinPoint.getArgs()).length > 1 && constructorArgs[1] instanceof DesiredCapabilities) {
            TestSessionRecorder.setBuild((DesiredCapabilities)constructorArgs[1]);
        }
    }

    @After(value="webDriverConstructor()")
    public void afterNewWebDriver(JoinPoint joinPoint) {
        Object target = joinPoint.getTarget();
        if (target instanceof RemoteWebDriver) {
            RemoteWebDriver webDriver = (RemoteWebDriver)target;
            WebDriverInstance webDriverInstance = new WebDriverInstance(webDriver);
            if (!TestSessionRecorder.isBrowserStackWebDriver(joinPoint) || this.recorder.isWebDriverCaptured(webDriverInstance)) {
                return;
            }
            this.recorder.captureWebDriver(webDriverInstance);
            this.recorder.setLastEventType(EventType.WD_START);
            TestSessionRecorder.getInstance().registerSessionIdForCurrentClass(webDriverInstance.data);
            if (TestSessionRecorder.DEBUG) {
                this.outStream.println(">>> ADD WD: " + webDriverInstance.data + " | " + this.recorder.getCapturedWebDrivers().size() + " | Thread: " + Thread.currentThread().getId());
            }
        }
    }

    @After(value="webDriverQuit()")
    public void afterWebDriverQuit(JoinPoint joinPoint) {
        Object target = joinPoint.getTarget();
        if (target instanceof RemoteWebDriver) {
            RecordedData webDriverInstance;
            String sessionId;
            RemoteWebDriver webDriver = (RemoteWebDriver)target;
            String string = sessionId = webDriver.getSessionId() != null ? webDriver.getSessionId().toString() : null;
            if (sessionId != null && (webDriverInstance = this.recorder.findAndRemoveEvent(sessionId, this.recorder.getCapturedWebDrivers())) != null) {
                if (TestSessionRecorder.DEBUG) {
                    System.out.println(">>> REMOVE WD: " + webDriverInstance.data);
                }
                this.recorder.setLastEventType(EventType.WD_END);
                this.recorder.setLastSessionId(webDriverInstance.data);
            }
        }
    }

    public static AutomateAspects aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.browserstack.automate.testassist.AutomateAspects", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

