/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.testassist;

import com.browserstack.automate.testassist.EventType;
import com.browserstack.automate.testassist.ProjectType;
import com.browserstack.automate.testassist.RecordedData;
import com.browserstack.automate.testassist.UnitTestCase;
import com.browserstack.automate.testassist.WebDriverInstance;
import com.browserstack.automate.testassist.XmlReporter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;

class TestSessionRecorder {
    static boolean DEBUG = System.getProperty("browserstack.automate.debug", "false").equals("true");
    private static final String HUB_BROWSERSTACK_COM = System.getProperty("browserstack.automate.hub", "browserstack.com");
    private static final String ENV_BROWSERSTACK_BUILD = "BROWSERSTACK_BUILD";
    private static final String BROWSERSTACK_CAPABILITY_BUILD = "build";
    private static final String OBJECT_CLASS_NAME = Object.class.getCanonicalName();
    private final Map<Long, LinkedList<UnitTestCase>> testCases = new ConcurrentHashMap<Long, LinkedList<UnitTestCase>>();
    private final Map<String, Long> testCaseIndices = new ConcurrentHashMap<String, Long>();
    private final Map<Long, LinkedList<WebDriverInstance>> webDrivers = new ConcurrentHashMap<Long, LinkedList<WebDriverInstance>>();
    private final Map<Long, EventType> lastEventType = new ConcurrentHashMap<Long, EventType>();
    private final Map<Long, String> lastSessionId = new ConcurrentHashMap<Long, String>();
    private final Map<String, String> sessionTestMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> clazzSessionMap = new ConcurrentHashMap<String, String>();
    private final Map<String, List<String>> clazzHierarchyMap = new ConcurrentHashMap<String, List<String>>();
    private final XmlReporter xmlReporter = new XmlReporter();
    private final Map<String, WebDriverInstance> sessionWebDriverInstanceMap = new ConcurrentHashMap<String, WebDriverInstance>();

    private TestSessionRecorder() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                block2: {
                    try {
                        TestSessionRecorder.this.xmlReporter.saveXML();
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block2;
                        System.out.println("[ERROR] Failed to save report");
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    static TestSessionRecorder getInstance() {
        return InstanceHolder.INSTANCE;
    }

    RecordedData findAndRemoveEvent(String key, LinkedList<? extends RecordedData> queue) {
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            RecordedData capturedEvent = (RecordedData)iterator.next();
            if (!capturedEvent.data.equals(key)) continue;
            if (DEBUG) {
                System.out.println(">>> REMOVE: " + capturedEvent.data + " | Count: " + this.testCases.size());
            }
            iterator.remove();
            return capturedEvent;
        }
        return null;
    }

    LinkedList<UnitTestCase> getCapturedTestCases() {
        long threadId = Thread.currentThread().getId();
        if (!this.testCases.containsKey(threadId)) {
            this.testCases.put(threadId, new LinkedList());
        }
        return this.testCases.get(threadId);
    }

    LinkedList<WebDriverInstance> getCapturedWebDrivers() {
        long threadId = Thread.currentThread().getId();
        if (!this.webDrivers.containsKey(threadId)) {
            this.webDrivers.put(threadId, new LinkedList());
        }
        return this.webDrivers.get(threadId);
    }

    void captureWebDriver(WebDriverInstance webDriverInstance) {
        long threadId = Thread.currentThread().getId();
        if (!this.webDrivers.containsKey(threadId)) {
            this.webDrivers.put(threadId, new LinkedList());
        }
        this.webDrivers.get(threadId).add(webDriverInstance);
        this.sessionWebDriverInstanceMap.put(webDriverInstance.data, webDriverInstance);
    }

    boolean isWebDriverCaptured(WebDriverInstance webDriverInstance) {
        long threadId = Thread.currentThread().getId();
        return this.webDrivers.containsKey(threadId) && this.webDrivers.get(threadId).contains(webDriverInstance);
    }

    EventType getLastEventType() {
        long threadId = Thread.currentThread().getId();
        if (this.lastEventType.containsKey(threadId)) {
            return this.lastEventType.get(threadId);
        }
        return EventType.UNKNOWN;
    }

    void linkSessionIdToTestCase(String sessionId, UnitTestCase testCase) {
        block4: {
            this.sessionTestMap.put(sessionId, testCase.data);
            String projectType = ProjectType.AUTOMATE.toString();
            if (this.sessionWebDriverInstanceMap.containsKey(sessionId)) {
                projectType = this.sessionWebDriverInstanceMap.get(sessionId).getProjectType().toString();
            }
            try {
                this.xmlReporter.appendTest(testCase, sessionId, projectType);
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                System.out.println("[ERROR] " + e.getMessage());
            }
        }
        if (DEBUG) {
            System.out.println(String.format(">>>> LINK: %s <=> %s <<<<", sessionId, testCase));
        }
    }

    Map<String, String> getSessionTestMap() {
        return this.sessionTestMap;
    }

    void setLastEventType(EventType eventType) {
        this.lastEventType.put(Thread.currentThread().getId(), eventType);
    }

    String getLastSessionId() {
        long threadId = Thread.currentThread().getId();
        return this.lastSessionId.containsKey(threadId) ? this.lastSessionId.get(threadId) : null;
    }

    void setLastSessionId(String sessionId) {
        this.lastSessionId.put(Thread.currentThread().getId(), sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long getTestCaseIndex(JoinPoint joinPoint) {
        Map<String, Long> map = this.testCaseIndices;
        synchronized (map) {
            String testCaseSignature = joinPoint.getSignature().toLongString();
            Long index = this.testCaseIndices.containsKey(testCaseSignature) ? this.testCaseIndices.get(testCaseSignature) : -1L;
            index = index + 1L;
            this.testCaseIndices.put(testCaseSignature, index);
            if (DEBUG) {
                System.out.println(String.format("%s => %d", testCaseSignature, index));
            }
            return index;
        }
    }

    String recordClassHierarchy(Object obj) {
        if (obj == null) {
            return null;
        }
        String clazzCanonicalName = obj.getClass().getCanonicalName();
        if (!this.clazzHierarchyMap.containsKey(clazzCanonicalName)) {
            Class<?> clazz = obj.getClass();
            ArrayList<String> clazzList = new ArrayList<String>();
            while (clazz != null) {
                if (clazz.getCanonicalName().equals(OBJECT_CLASS_NAME)) break;
                clazzList.add(clazz.getCanonicalName());
                clazz = clazz.getSuperclass();
            }
            this.clazzHierarchyMap.put(clazzCanonicalName, Collections.unmodifiableList(clazzList));
        }
        return clazzCanonicalName;
    }

    String findSessionIdForClass(Object obj) {
        if (obj == null || obj.getClass().getCanonicalName() == null) {
            return null;
        }
        for (String clazzName : this.clazzHierarchyMap.get(obj.getClass().getCanonicalName())) {
            if (!this.clazzSessionMap.containsKey(clazzName)) continue;
            return this.clazzSessionMap.get(clazzName);
        }
        return null;
    }

    void registerSessionIdForCurrentClass(String sessionId) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String clazzName = null;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement st = stackTraceElementArray[n2];
            if (st.isNativeMethod()) break;
            clazzName = st.getClassName();
            ++n2;
        }
        if (clazzName != null) {
            this.clazzSessionMap.put(clazzName, sessionId);
        }
    }

    static String getSignature(JoinPoint joinPoint) {
        return String.valueOf(joinPoint.getSignature().toString()) + "@" + joinPoint.getTarget().hashCode();
    }

    static void setBuild(DesiredCapabilities capabilities) {
        String buildTag;
        String build = (String)capabilities.getCapability(BROWSERSTACK_CAPABILITY_BUILD);
        if ((build == null || build.trim().length() == 0) && (buildTag = System.getenv(ENV_BROWSERSTACK_BUILD)) != null && buildTag.trim().length() > 0) {
            capabilities.setCapability(BROWSERSTACK_CAPABILITY_BUILD, buildTag.trim());
        }
    }

    static boolean isBrowserStackWebDriver(JoinPoint joinPoint) {
        Object[] constructorArgs = joinPoint.getArgs();
        if (constructorArgs.length > 0) {
            URL hubUrl = null;
            if (constructorArgs[0] instanceof URL) {
                hubUrl = (URL)constructorArgs[0];
            } else if (constructorArgs[0] instanceof HttpCommandExecutor) {
                hubUrl = ((HttpCommandExecutor)constructorArgs[0]).getAddressOfRemoteServer();
            }
            if (hubUrl != null && hubUrl.toString().contains(HUB_BROWSERSTACK_COM)) {
                return true;
            }
        }
        return false;
    }

    /* synthetic */ TestSessionRecorder(TestSessionRecorder testSessionRecorder) {
        this();
    }

    private static class InstanceHolder {
        private static final TestSessionRecorder INSTANCE = new TestSessionRecorder(null);

        private InstanceHolder() {
        }
    }
}

