/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.testassist;

import com.browserstack.automate.testassist.RecordedData;
import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.aspectj.lang.JoinPoint;

public class UnitTestCase
extends RecordedData {
    private static final String TESTCASE_FORMAT = "%s{%s}";
    final String packageName;
    final String className;
    final String testName;
    final Long testCaseIndex;

    UnitTestCase(JoinPoint value, String signature, Long testCaseIndex) {
        super(signature);
        this.testCaseIndex = testCaseIndex;
        Package aPackage = value.getSignature().getDeclaringType().getPackage();
        this.packageName = aPackage != null ? aPackage.getName() : "";
        this.className = value.getSignature().getDeclaringType().getSimpleName();
        this.testName = value.getSignature().getName();
    }

    String getTestHash() {
        String testHash;
        String fullTestName = UnitTestCase.getFullName(this);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(fullTestName.getBytes("utf8"));
            testHash = DatatypeConverter.printHexBinary((byte[])digest.digest()).toLowerCase();
        }
        catch (Exception exception) {
            testHash = DigestUtils.sha1Hex(fullTestName);
        }
        return String.format(TESTCASE_FORMAT, testHash, this.testCaseIndex);
    }

    String getUniqueName() {
        return String.format(TESTCASE_FORMAT, UnitTestCase.getFullName(this), this.testCaseIndex);
    }

    public String toString() {
        return this.getTestHash();
    }

    String getFullClassName() {
        return this.packageName != null && !this.packageName.trim().isEmpty() ? String.valueOf(this.packageName.trim()) + "." + this.className : this.className;
    }

    static String getFullName(UnitTestCase uc) {
        return String.valueOf(uc.getFullClassName()) + "." + uc.testName;
    }
}

