/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.testassist;

import com.browserstack.automate.testassist.ProjectType;
import com.browserstack.automate.testassist.RecordedData;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverInstance
extends RecordedData {
    private RemoteWebDriver webDriver;
    private ProjectType projectType;

    WebDriverInstance(RemoteWebDriver webDriver) {
        super(WebDriverInstance.getSignature(webDriver));
        this.webDriver = webDriver;
        this.projectType = this.getProjectType(webDriver);
    }

    private ProjectType getProjectType(RemoteWebDriver webDriver) {
        if (webDriver != null && webDriver.getCapabilities().asMap().get("bundleID") != null) {
            return ProjectType.APP_AUTOMATE;
        }
        return ProjectType.AUTOMATE;
    }

    static String getSignature(RemoteWebDriver webDriver) {
        return webDriver.getSessionId() != null ? webDriver.getSessionId().toString() : "" + Math.random() * 10000.0;
    }

    public RemoteWebDriver getWebDriver() {
        return this.webDriver;
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }
}

