/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.testassist;

import com.browserstack.automate.testassist.TestSessionRecorder;
import com.browserstack.automate.testassist.UnitTestCase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlReporter {
    private static final String DIR_REPORTS = "browserstack-reports";
    private static final String REPORT_FILE_PREFIX = "REPORT-";
    private static final String REPORT_FILE_EXTN = ".xml";
    private static final String DIR_TARGET = "target";
    private final Map<String, Document> reports;
    private final File targetDir;
    private final boolean isEnabled;

    public XmlReporter() {
        this(String.valueOf(System.getProperty("user.dir", ".")) + File.separator + DIR_TARGET);
    }

    public XmlReporter(String outputPath) {
        this.targetDir = new File(outputPath);
        this.isEnabled = this.targetDir.exists() && this.targetDir.isDirectory() && this.targetDir.canWrite();
        this.reports = new ConcurrentHashMap<String, Document>();
    }

    public synchronized void saveXML() throws Exception {
        if (!this.isEnabled) {
            System.out.println("[ERROR] Target directory missing or not writable: " + this.targetDir.getAbsolutePath());
            return;
        }
        for (Map.Entry<String, Document> entry : this.reports.entrySet()) {
            Document document = entry.getValue();
            if (document == null) continue;
            FileWriter fileWriter = null;
            try {
                try {
                    File destDir = new File(this.targetDir, DIR_REPORTS);
                    FileUtils.forceMkdir((File)destDir);
                    fileWriter = new FileWriter(new File(destDir, REPORT_FILE_PREFIX + entry.getKey() + REPORT_FILE_EXTN));
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(fileWriter);
                    transformer.transform(source, result);
                }
                catch (IOException e) {
                    if (TestSessionRecorder.DEBUG) {
                        System.out.println("[ERROR] Failed to save report for: " + entry.getKey());
                        e.printStackTrace();
                    }
                    IOUtils.closeQuietly(fileWriter);
                    continue;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    public void appendTest(UnitTestCase testCase, String sessionId, String projectType) throws Exception {
        Element testsElement;
        if (!this.isEnabled) {
            return;
        }
        Document document = this.reports.get(testCase.getFullClassName());
        if (document == null && (document = XmlReporter.initXML(testCase)) != null) {
            this.reports.put(testCase.getFullClassName(), document);
        }
        if (document != null && (testsElement = document.getDocumentElement()) != null) {
            Element test = document.createElement("testcase");
            test.setAttribute("name", testCase.testName);
            test.setAttribute("classname", testCase.getFullClassName());
            test.setAttribute("id", testCase.getUniqueName());
            test.setAttribute("index", "" + testCase.testCaseIndex);
            test.setAttribute("package", testCase.packageName);
            test.setAttribute("class", testCase.className);
            Element sessionNode = document.createElement("session");
            sessionNode.setTextContent(sessionId);
            test.appendChild(sessionNode);
            Element projectTypeNode = document.createElement("projectType");
            projectTypeNode.setTextContent(projectType);
            test.appendChild(projectTypeNode);
            testsElement.appendChild(test);
        }
    }

    private static Document initXML(UnitTestCase testCase) {
        DocumentBuilder docBuilder;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        Document doc = docBuilder.newDocument();
        Element testsElement = doc.createElement("testsuite");
        testsElement.setAttribute("name", testCase.getFullClassName());
        doc.appendChild(testsElement);
        return doc;
    }
}

