package com.browserstack.automate.testassist;

import org.apache.commons.codec.digest.DigestUtils;
import org.aspectj.lang.JoinPoint;

import javax.xml.bind.DatatypeConverter;
import java.security.MessageDigest;

/**
 * Defines a recorded test case.
 *
 * @author Shirish Kamath
 * @author Anirudha Khanna
 */
public class UnitTestCase extends RecordedData {
    private static final String TESTCASE_FORMAT = "%s{%s}";

    final String packageName;
    final String className;
    final String testName;
    final Long testCaseIndex;

    UnitTestCase(JoinPoint value, String signature, Long testCaseIndex) {
        super(signature);
        this.testCaseIndex = testCaseIndex;

        Package aPackage = value.getSignature().getDeclaringType().getPackage();
        this.packageName = (aPackage != null) ? aPackage.getName() : "";
        this.className = value.getSignature().getDeclaringType().getSimpleName();
        this.testName = value.getSignature().getName();
    }

    String getTestHash() {
        String fullTestName = getFullName(this);
        String testHash;

        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(fullTestName.getBytes("utf8"));
            testHash = DatatypeConverter.printHexBinary(digest.digest()).toLowerCase();
        } catch (Exception e) {
            testHash = DigestUtils.sha1Hex(fullTestName);
        }

        return String.format(TESTCASE_FORMAT, testHash, this.testCaseIndex);
    }

    String getUniqueName() {
        return String.format(TESTCASE_FORMAT, getFullName(this), this.testCaseIndex);
    }

    @Override
    public String toString() {
        return getTestHash();
    }

    String getFullClassName() {
        return (packageName != null && !packageName.trim().isEmpty()) ?
                (packageName.trim() + "." + className) : className;
    }

    static String getFullName(UnitTestCase uc) {
        return uc.getFullClassName() + "." + uc.testName;
    }
}