package com.browserstack.automate.testassist;

import org.openqa.selenium.remote.RemoteWebDriver;

/**
 * Stores sessionId associated with RemoteWebDriver.
 *
 * @author Shirish Kamath
 * @author Anirudha Khanna
 */
public class WebDriverInstance extends RecordedData {


    private RemoteWebDriver webDriver;
    private ProjectType projectType;

    WebDriverInstance(RemoteWebDriver webDriver) {
        super(getSignature(webDriver));
        this.webDriver = webDriver;

        this.projectType = getProjectType(webDriver);
    }

    private ProjectType getProjectType(RemoteWebDriver webDriver) {

        // app parameter is present only in case of app automate for time being.
        if (webDriver != null && webDriver.getCapabilities().asMap().get("bundleID") != null) {
            return ProjectType.APP_AUTOMATE;
        } else {
            // default AUTOMATE
            return ProjectType.AUTOMATE;
        }
    }

    static String getSignature(RemoteWebDriver webDriver) {
        return (webDriver.getSessionId() != null) ? webDriver.getSessionId().toString() : ("" + Math.random() * 10000);
    }

    public RemoteWebDriver getWebDriver() {
        return webDriver;
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }

}