package com.browserstack.automate.testassist;


/**
 * Stores data that uniquely identifies each implementation.
 *
 * @author Shirish Kamath
 * @author Anirudha Khanna
 */
public abstract class RecordedData {
    final String data;

    RecordedData(String data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        RecordedData recordedData = (RecordedData) o;
        return data != null ? data.equals(recordedData.data) : recordedData.data == null;
    }

    @Override
    public int hashCode() {
        return data != null ? data.hashCode() : 0;
    }
}
