/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm;

import com.browserup.bup.mitm.CertificateInfo;
import com.browserup.bup.mitm.CertificateInfoGenerator;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;

public class HostnameCertificateInfoGenerator
implements CertificateInfoGenerator {
    private static final String DEFAULT_IMPERSONATED_CERT_ORG = "Impersonated Certificate";
    private static final String DEFAULT_IMPERSONATED_CERT_ORG_UNIT = "LittleProxy MITM";

    @Override
    public CertificateInfo generate(List<String> hostnames, X509Certificate originalCertificate) {
        if (hostnames == null || hostnames.size() < 1) {
            throw new IllegalArgumentException("Cannot create X.509 certificate without server hostname");
        }
        String commonName = hostnames.get(0);
        return new CertificateInfo().commonName(commonName).organization(DEFAULT_IMPERSONATED_CERT_ORG).organizationalUnit(DEFAULT_IMPERSONATED_CERT_ORG_UNIT).notBefore(this.getNotBefore()).notAfter(this.getNotAfter()).subjectAlternativeNames(hostnames);
    }

    protected Instant getNotBefore() {
        return ZonedDateTime.now().minusYears(1L).toInstant();
    }

    protected Instant getNotAfter() {
        return ZonedDateTime.now().plusYears(1L).toInstant();
    }
}

