/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console;

import com.bstek.urule.console.BaseServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.PermissionDeniedException;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.TransactionalInvoke;
import com.bstek.urule.console.database.manager.file.DirectoryManager;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.security.AuthenticationManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthAnonymous;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.security.entity.User;
import com.bstek.urule.console.type.RoleCategory;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.DynamicSpringConfigLoaderImpl;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ApiServletHandler
extends BaseServletHandler {
    protected static final String a = "/api";

    @Override
    public final void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.b(httpServletRequest);
        String string = httpServletRequest.getContextPath() + "/urule";
        String string2 = httpServletRequest.getRequestURI();
        String string3 = string2.substring(string.length());
        int n = string3.lastIndexOf("/");
        String string4 = string3.substring(n + 1, string3.length());
        this.a(string4, httpServletRequest, httpServletResponse);
    }

    public void info(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(DynamicSpringConfigLoaderImpl.getAuthInfo())) {
            stringBuilder.append("Authorized to " + DynamicSpringConfigLoaderImpl.getAuthInfo() + "\uff08\u6388\u6743\u7ed9\u3010" + DynamicSpringConfigLoaderImpl.getAuthInfo() + "\u3011\u4f7f\u7528\uff09");
        } else {
            stringBuilder.append("You are using a trial version,please purchase the commercial license.\uff08\u5f53\u524d\u4e3a\u8bd5\u7528\u7248\uff0c\u8bf7\u8d2d\u4e70\u5546\u4e1a\u6388\u6743\uff09");
        }
        this.a(httpServletResponse, stringBuilder.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void a(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Method method = this.getClass().getMethod(string, HttpServletRequest.class, HttpServletResponse.class);
        URuleAuthAnonymous uRuleAuthAnonymous = method.getAnnotation(URuleAuthAnonymous.class);
        if (uRuleAuthAnonymous != null) {
            this.a(method, httpServletRequest, httpServletResponse);
            return;
        }
        if (SecurityUtils.getLoginUser(httpServletRequest) == null) {
            throw new InfoException("\u8bf7\u5148\u767b\u5f55<br/>Please Login first! ");
        }
        User user = SecurityUtils.getLoginUser(httpServletRequest);
        URuleAuthorization uRuleAuthorization = method.getAnnotation(URuleAuthorization.class);
        if (uRuleAuthorization != null) {
            boolean bl = this.a(httpServletRequest, httpServletResponse, method, user, uRuleAuthorization);
            if (!bl) throw new PermissionDeniedException();
            this.a(method, httpServletRequest, httpServletResponse);
            return;
        } else {
            this.a(method, httpServletRequest, httpServletResponse);
        }
    }

    private boolean a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Method method, User user, URuleAuthorization uRuleAuthorization) {
        boolean bl = true;
        if (uRuleAuthorization.ruleFile() || uRuleAuthorization.ruleDir()) {
            Object object;
            String string = httpServletRequest.getParameter("id");
            String string2 = uRuleAuthorization.code();
            String string3 = "";
            if ("add".equals(string2.toLowerCase())) {
                string3 = httpServletRequest.getParameter("type");
            } else {
                object = null;
                if (uRuleAuthorization.ruleFile()) {
                    object = FileManager.ins.get(Long.parseLong(string));
                    ContextHolder.setProjectId(((RuleFile)object).getProjectId());
                } else {
                    object = DirectoryManager.ins.get(Long.parseLong(string));
                    if (object != null) {
                        ContextHolder.setProjectId(((RuleFile)object).getProjectId());
                    }
                }
                if (object == null) {
                    throw new RuleException("URule File Object " + string + " not exist.");
                }
                string3 = ((RuleFile)object).getType();
            }
            object = RuleFileType.getRuleFileType(string3);
            bl = AuthenticationManager.decide(user, RoleCategory.project, ((RuleFileType)((Object)object)).getModel(), uRuleAuthorization.code());
        } else {
            bl = AuthenticationManager.decide(user, RoleCategory.valueOf(uRuleAuthorization.authType()), uRuleAuthorization.model(), uRuleAuthorization.code());
        }
        return bl;
    }

    protected void a(TransactionalInvoke transactionalInvoke) throws Exception {
        Connection connection = JdbcUtils.getConnection();
        try {
            connection.setAutoCommit(false);
            transactionalInvoke.doTransactional();
            connection.commit();
        }
        catch (Exception exception) {
            connection.rollback();
            throw exception;
        }
        finally {
            connection.setAutoCommit(true);
            JdbcUtils.closeConnection(connection);
        }
    }

    private void a(Method method, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional == null) {
            method.invoke((Object)this, httpServletRequest, httpServletResponse);
        } else {
            Connection connection = JdbcUtils.getConnection();
            try {
                connection.setAutoCommit(false);
                method.invoke((Object)this, httpServletRequest, httpServletResponse);
                connection.commit();
            }
            catch (Exception exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
                JdbcUtils.closeConnection(connection);
            }
        }
    }
}

