/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console;

import com.bstek.urule.BigDecimalJsonSerializer;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.PermissionDeniedException;
import com.bstek.urule.console.ServletHandler;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.user.UserManager;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;

public abstract class BaseServletHandler
implements ServletHandler {
    protected static final String b = "utf-8";
    protected VelocityEngine c;
    protected final String d = "parameters";

    @Override
    public void init() {
        this.c = new VelocityEngine();
        this.c.setProperty("resource.loader", (Object)"class");
        this.c.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.c.setProperty("runtime.log.logsystem", (Object)new NullLogChute());
        this.c.init();
    }

    protected ObjectMapper a() {
        ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new StreamWriteFeature[]{StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN})).build();
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyy-MM-dd HH:mm:ss"));
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new BigDecimalJsonSerializer());
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    protected void b(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setHeader("Access-Control-Allow-Origin", "*");
        String string2 = this.a(httpServletRequest);
        if (string2 != null) {
            this.c(string2, httpServletRequest, httpServletResponse);
        } else {
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("contextPath", (Object)httpServletRequest.getContextPath());
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setCharacterEncoding(b);
            Template template = this.c.getTemplate("asserts/urule/html/" + string, b);
            PrintWriter printWriter = httpServletResponse.getWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
            printWriter.close();
        }
    }

    protected void c(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Method method = this.getClass().getMethod(string, HttpServletRequest.class, HttpServletResponse.class);
        method.invoke((Object)this, httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(HttpServletResponse httpServletResponse, Object object) throws ServletException, IOException {
        httpServletResponse.setContentType("text/json");
        httpServletResponse.setCharacterEncoding(b);
        JsonMapper.Builder builder = JsonMapper.builder();
        builder.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        ObjectMapper objectMapper = builder.build();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new BigDecimalJsonSerializer());
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            objectMapper.writeValue((OutputStream)servletOutputStream, object);
        }
        finally {
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }

    protected String a(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        String string = new String(byteArrayOutputStream.toByteArray());
        IOUtils.closeQuietly((OutputStream)printStream);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        string = string.replaceAll("\n", "<br>");
        if (stringBuilder.length() > 0) {
            stringBuilder.append("<br>");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected String a(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getContextPath() + "/urule";
        String string2 = httpServletRequest.getRequestURI();
        String string3 = string2.substring(string.length());
        int n = string3.indexOf("/", 0);
        if (n > -1) {
            String string4 = string3.substring(n + 1).trim();
            return string4.length() > 0 ? string4 : null;
        }
        return null;
    }

    protected void b(HttpServletRequest httpServletRequest) {
        User user;
        Object object;
        String string = httpServletRequest.getParameter("groupId");
        String string2 = httpServletRequest.getParameter("projectId");
        String string3 = httpServletRequest.getContextPath();
        String string4 = httpServletRequest.getRequestURI();
        if (string4.startsWith(string3)) {
            string4 = string4.substring(string3.length());
        }
        boolean bl = !string4.startsWith("/urule/api/group/add") && !string4.startsWith("/urule/api/project/add");
        ContextHolder.clear();
        if (StringUtils.isNotBlank(string2)) {
            if (bl) {
                if (StringUtils.isBlank(string)) {
                    object = ProjectManager.ins.get(Long.parseLong(string2));
                    if (object == null) {
                        throw new InfoException("ProjectId invalid!");
                    }
                    string = ((Project)object).getGroupId();
                }
                object = SecurityUtils.getLoginUsername(httpServletRequest);
                user = UserManager.ins.getProjectUser(Long.parseLong(string2), (String)object);
                if (user == null) {
                    throw new PermissionDeniedException("Permission denied for project [" + string2 + "]");
                }
            }
            ContextHolder.setProjectId(Long.parseLong(string2));
        }
        if (StringUtils.isNotBlank(string)) {
            if (bl && (user = UserManager.ins.getGroupUser(string, (String)(object = SecurityUtils.getLoginUsername(httpServletRequest)))) == null) {
                throw new PermissionDeniedException("Permission denied for team [" + string + "]");
            }
            ContextHolder.setGroupId(string);
        }
    }
}

