/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console;

import com.bstek.urule.builder.ParsePhaseHolder;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.HttpServletResponseWrapper;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.PageServletHandler;
import com.bstek.urule.console.PermissionDeniedException;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.ServletHandler;
import com.bstek.urule.console.admin.log.ProcessLog;
import com.bstek.urule.console.anonymous.AnonymousServletHandler;
import com.bstek.urule.console.config.bootstrap.BootstrapManager;
import com.bstek.urule.exception.RuleAssertException;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.rete.RuleDueException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class URuleServlet
extends HttpServlet {
    private static final long a = -532678553551034556L;
    private PageServletHandler b;
    private Map<String, ServletHandler> c = new HashMap<String, ServletHandler>();
    private Map<String, ServletHandler> d = new HashMap<String, ServletHandler>();

    public void init(ServletConfig servletConfig) throws ServletException {
        ServiceLoader<ServletHandler> serviceLoader = ServiceLoader.load(ServletHandler.class);
        for (ServletHandler servletHandler : serviceLoader) {
            servletHandler.init();
            String string = servletHandler.url();
            if (this.c.containsKey(string) && this.d.containsKey(string)) {
                throw new RuntimeException("Handler [" + string + "] not unique.");
            }
            if (servletHandler instanceof ApiServletHandler) {
                string = "/api" + string;
                this.c.put(string, servletHandler);
                continue;
            }
            if (servletHandler instanceof AnonymousServletHandler) {
                this.d.put(string, servletHandler);
                continue;
            }
            throw new RuleException("Unsupport ServletHandler :" + string);
        }
        this.b = new PageServletHandler();
        this.b.init();
        ProcessLog.init();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        String string2;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        Object object = httpServletResponse;
        object = new HttpServletResponseWrapper((HttpServletResponse)object);
        String string3 = httpServletRequest2.getRequestURI();
        String string4 = string2 = string3.startsWith(string = httpServletRequest2.getContextPath() + "/urule") ? string3.substring(string.length()) : string3;
        if (string2.length() < 1) {
            RequestHolder.setRequest(httpServletRequest2);
            RequestHolder.clean();
            return;
        }
        ServletHandler servletHandler = null;
        if (string2.startsWith("/api") || string2.startsWith("/rest")) {
            int n = string2.lastIndexOf("/");
            string2 = string2.substring(0, n);
        } else {
            int n = string2.indexOf("/");
            if (n == 0) {
                String string5 = string2.substring(1, string2.length());
                n = string5.indexOf("/") + 1;
            }
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
        }
        servletHandler = this.c.containsKey(string2) ? this.c.get(string2) : (this.d.containsKey(string2) ? this.d.get(string2) : this.b);
        if (BootstrapManager.get().needCheckBootstrapped(string3) && !BootstrapManager.get().isBootstrapped()) {
            object.sendRedirect(string + "/setup");
            return;
        }
        RequestHolder.setRequest(httpServletRequest2);
        this.doServletHandler(httpServletRequest2, (HttpServletResponse)object, servletHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doServletHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletHandler servletHandler) throws IOException, ServletException {
        try {
            servletHandler.execute(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            Throwable throwable = this.b(exception, stringBuilder);
            if (throwable instanceof RuleDueException) {
                httpServletResponse.setStatus(888);
                return;
            }
            httpServletResponse.setCharacterEncoding("UTF-8");
            String string = NullPointerException.class.getName();
            if (!(throwable instanceof NullPointerException)) {
                string = throwable.getMessage();
            }
            if (string == null) {
                string = NullPointerException.class.getName();
            }
            httpServletResponse.addHeader("errorMsg", URLEncoder.encode(string, "utf-8"));
            httpServletResponse.setStatus(500);
            String string2 = this.getErrorMsg(throwable);
            if (throwable instanceof PermissionDeniedException) {
                httpServletResponse.setContentType("text/html;charset=utf-8");
                httpServletResponse.setCharacterEncoding("utf-8");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.write("<h2>" + string2 + "</h2>");
                printWriter.flush();
                printWriter.close();
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = this.a(throwable, stringBuilder);
            hashMap.put("errorMsg", string2);
            hashMap.put("stack", string3);
            ObjectMapper objectMapper = JsonMapper.builder().build();
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                objectMapper.writeValue((OutputStream)servletOutputStream, hashMap);
            }
            finally {
                servletOutputStream.flush();
                servletOutputStream.close();
            }
            if (!(throwable instanceof RuleException) && !(throwable instanceof InfoException)) {
                throwable.printStackTrace();
            }
        }
        finally {
            ParsePhaseHolder.cleanParsePhase();
            RequestHolder.clean();
        }
    }

    protected String getErrorMsg(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null || string.contentEquals("")) {
            string = throwable.getClass().getName();
        }
        return string;
    }

    private String a(Throwable throwable, StringBuilder stringBuilder) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        String string = new String(byteArrayOutputStream.toByteArray());
        IOUtils.closeQuietly((OutputStream)printStream);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        string = string.replaceAll("\n", "<br>");
        if (stringBuilder.length() > 0) {
            stringBuilder.append("<br>");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private Throwable b(Throwable throwable, StringBuilder stringBuilder) {
        RuleAssertException ruleAssertException;
        String string;
        if (throwable instanceof RuleAssertException && (string = (ruleAssertException = (RuleAssertException)throwable).getTipMsg()) != null) {
            stringBuilder.append(string);
        }
        if (throwable.getCause() != null) {
            return this.b(throwable.getCause(), stringBuilder);
        }
        return throwable;
    }
}

