/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.batch;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.admin.batch.in.BatchImport;
import com.bstek.urule.console.admin.batch.out.BatchExport;
import com.bstek.urule.console.batch.BatchStatus;
import com.bstek.urule.console.batch.SchemeService;
import com.bstek.urule.console.batch.exception.BatchException;
import com.bstek.urule.console.batch.utils.JsonUtils;
import com.bstek.urule.console.batch.utils.StmtUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketData;
import com.bstek.urule.console.config.dialect.Dialect;
import com.bstek.urule.console.config.dialect.DialectResolver;
import com.bstek.urule.console.config.dialect.OrderLimitDialect;
import com.bstek.urule.console.database.manager.batch.BatchManager;
import com.bstek.urule.console.database.manager.batch.BatchQuery;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.PacketQuery;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.repository.DataSourceManager;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataProvider;
import com.bstek.urule.console.database.model.batch.DataParam;
import com.bstek.urule.console.database.model.datasource.DataSource;
import com.bstek.urule.console.database.model.datasource.Field;
import com.bstek.urule.console.database.model.datasource.FieldType;
import com.bstek.urule.console.database.service.repository.DataSourceHandlerManager;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.database.util.NamedSQLUtils;
import com.bstek.urule.console.database.util.ParsedSql;
import com.bstek.urule.console.editor.execute.JsonBuilder;
import com.bstek.urule.console.editor.execute.VariableCategoryNotFoundException;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.console.util.UploadFile;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.variable.Act;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchesServletHandler
extends ApiServletHandler {
    public static final String URL = "/batches";
    private static final Log e = LogFactory.getLog(StmtUtils.class);

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("data");
        String string2 = SecurityUtils.getLoginUsername(httpServletRequest);
        Batch batch = (Batch)this.a().readValue(string, Batch.class);
        SchemeService.ins.add(batch, string2);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("data");
        String string2 = SecurityUtils.getLoginUsername(httpServletRequest);
        Batch batch = (Batch)this.a().readValue(string, Batch.class);
        SchemeService.ins.update(batch, string2);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void updateRestConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("data");
        String string2 = SecurityUtils.getLoginUsername(httpServletRequest);
        Batch batch = (Batch)this.a().readValue(string, Batch.class);
        Batch batch2 = BatchManager.ins.get(batch.getId());
        batch2.setRestEnable(batch.isRestEnable());
        batch2.setRestSecurityEnable(batch.isRestSecurityEnable());
        batch2.setRestSecurityUser(batch.getRestSecurityUser());
        batch2.setRestSecurityPassword(batch.getRestSecurityPassword());
        batch2.setUpdateUser(string2);
        batch2.setUpdateDate(new Date(System.currentTimeMillis()));
        BatchManager.ins.update(batch2);
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        SchemeService.ins.remove(l);
    }

    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void enable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        SchemeService.ins.enable(l, SecurityUtils.getLoginUsername(httpServletRequest));
    }

    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void disable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        SchemeService.ins.disable(l, SecurityUtils.getLoginUsername(httpServletRequest));
    }

    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void stop(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        SchemeService.ins.stop(l, SecurityUtils.getLoginUsername(httpServletRequest));
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void get(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        Batch batch = SchemeService.ins.getBatchData(l);
        this.a(httpServletResponse, batch);
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void getProviderData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("providerId"));
        BatchDataProvider batchDataProvider = SchemeService.ins.getProviderData(l);
        this.a(httpServletResponse, batchDataProvider);
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void page(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        long l = ContextHolder.getProjectId();
        int n = Integer.parseInt(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.parseInt(httpServletRequest.getParameter("pageSize"));
        Page<Batch> page = new Page<Batch>(n, n2);
        BatchQuery batchQuery = BatchManager.ins.createQuery();
        String string7 = httpServletRequest.getParameter("name");
        if (StringUtils.isNotBlank(string7)) {
            batchQuery.nameLike(string7);
        }
        if (StringUtils.isNotBlank(string6 = httpServletRequest.getParameter("async"))) {
            batchQuery.async(Boolean.valueOf(string6));
        }
        if (StringUtils.isNotBlank(string5 = httpServletRequest.getParameter("enable"))) {
            batchQuery.enable(Boolean.valueOf(string5));
        }
        if (StringUtils.isNotBlank(string4 = httpServletRequest.getParameter("status"))) {
            batchQuery.status(BatchStatus.valueOf(string4));
        }
        if (StringUtils.isNotBlank(string3 = httpServletRequest.getParameter("id"))) {
            batchQuery.id(Long.valueOf(string3));
        }
        if (StringUtils.isNotBlank(string2 = httpServletRequest.getParameter("packetId"))) {
            batchQuery.packetId(Long.valueOf(string2));
        }
        if (StringUtils.isNotBlank(string = httpServletRequest.getParameter("createUser"))) {
            batchQuery.createUserLike(string);
        }
        batchQuery.projectId(l).page(page);
        this.a(httpServletResponse, page);
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void pagePacket(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        int n = Integer.parseInt(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.parseInt(httpServletRequest.getParameter("pageSize"));
        Page<Object> page = new Page(n, n2);
        PacketQuery packetQuery = PacketManager.ins.newQuery();
        String string = httpServletRequest.getParameter("name");
        if (StringUtils.isNotBlank(string)) {
            packetQuery.nameLike(string);
        }
        page = packetQuery.enable(true).projectId(l).paging(n, n2);
        this.a(httpServletResponse, page);
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void buildVariableCategorys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        PacketData packetData = PacketCache.ins.getPacket(Long.valueOf(httpServletRequest.getParameter("packetId")));
        if (packetData == null) {
            this.a(httpServletResponse, arrayList);
            return;
        }
        List list = packetData.getKnowledgePackageWrapper().getKnowledgePackage().getVariableCategories();
        for (VariableCategory variableCategory : list) {
            arrayList.add(variableCategory.getName());
        }
        this.a(httpServletResponse, arrayList);
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void buildVariables(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PacketData packetData = PacketCache.ins.getPacket(Long.valueOf(httpServletRequest.getParameter("packetId")));
        if (packetData == null) {
            this.a(httpServletResponse, new ArrayList());
            return;
        }
        List list = packetData.getKnowledgePackageWrapper().getKnowledgePackage().getVariableCategories();
        try {
            VariableCategory variableCategory = JsonBuilder.getInstance().findVariableCategory(list, httpServletRequest.getParameter("varName"));
            this.a(httpServletResponse, variableCategory.getVariables());
        }
        catch (VariableCategoryNotFoundException variableCategoryNotFoundException) {
            throw new VariableCategoryNotFoundException(variableCategoryNotFoundException.getMessage() + "\u8bf7\u786e\u4fdd\u5f53\u524d\u7248\u672c\u7684\u77e5\u8bc6\u5305\u4e2d\u5305\u542b\u8fd9\u4e2a\u53d8\u91cf\u5bf9\u8c61!");
        }
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void buildVariableTree(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ArrayList arrayList = new ArrayList();
        PacketData packetData = PacketCache.ins.getPacket(Long.valueOf(httpServletRequest.getParameter("packetId")));
        if (packetData == null) {
            this.a(httpServletResponse, arrayList);
            return;
        }
        List list = packetData.getKnowledgePackageWrapper().getKnowledgePackage().getVariableCategories();
        ArrayList<VariableCategory> arrayList2 = new ArrayList<VariableCategory>();
        for (VariableCategory variableCategory : list) {
            if (variableCategory.getAct() != Act.InOut && variableCategory.getAct() != Act.Out) continue;
            arrayList2.add(variableCategory);
        }
        this.a(httpServletResponse, arrayList2);
    }

    @URuleAuthorization(authType="project", code="view", model="batches")
    public void buildParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PacketData packetData = PacketCache.ins.getPacket(Long.valueOf(httpServletRequest.getParameter("packetId")));
        if (packetData == null) {
            throw new BatchException("\u77e5\u8bc6\u5305\u4e0d\u5b58\u5728!");
        }
        List list = packetData.getKnowledgePackageWrapper().getKnowledgePackage().getVariableCategories();
        VariableCategory variableCategory = null;
        for (VariableCategory variableCategory2 : list) {
            if (!"\u53c2\u6570".equals(variableCategory2.getName()) && !"\u53c2\u6570".equals(variableCategory2.getClazz())) continue;
            variableCategory = variableCategory2;
            break;
        }
        if (variableCategory != null) {
            this.a(httpServletResponse, variableCategory.getVariables());
        } else {
            this.a(httpServletResponse, new ArrayList());
        }
    }

    private boolean a(String string) {
        String string2 = string.toLowerCase();
        String string3 = "exec|execute|insert|delete|update|count|create|drop|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|exec|execute|table|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|";
        List<String> list = Arrays.asList(string3.split("\\|"));
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            if (!list.contains(string4)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @URuleAuthorization(authType="project", code="view", model="batches")
    public void getDatasourceExtInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Connection connection = null;
        javax.sql.DataSource dataSource = null;
        DataSource dataSource2 = null;
        try {
            String string = httpServletRequest.getParameter("id");
            String string2 = httpServletRequest.getParameter("isresolver");
            dataSource2 = DataSourceManager.ins.get(Long.parseLong(string));
            if (dataSource2 == null) {
                if ("true".equalsIgnoreCase(string2)) {
                    throw new Exception("DataResolver DataSource[" + string + "] is not defined!");
                }
                throw new Exception("DataProvider DataSource[" + string + "] is not defined!");
            }
            dataSource = DataSourceHandlerManager.newDataSource(dataSource2);
            connection = dataSource.getConnection();
            Dialect dialect = DialectResolver.resolveDialect(connection);
            hashMap.put("result", true);
            hashMap.put("orderLimit", false);
            if (dialect instanceof OrderLimitDialect) {
                hashMap.put("orderLimit", true);
            }
            hashMap.put("hive", dialect.getClass().getName().toLowerCase().indexOf("hive") > -1);
            this.a(connection);
        }
        catch (Throwable throwable) {
            this.a(connection);
            throw throwable;
        }
        this.a(httpServletResponse, hashMap);
    }

    private void a(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuleException((Exception)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @URuleAuthorization(authType="project", code="view", model="batches")
    public void buildFields(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("sql");
        String string2 = httpServletRequest.getParameter("tablename");
        if (StringUtils.isNotBlank(string)) {
            boolean bl = this.a(string = URLDecoder.decode(string, "utf-8"));
            if (bl) {
                return;
            }
        } else if (StringUtils.isNotBlank(string2)) {
            string = "select * from " + string2;
        }
        if (StringUtils.isBlank(string)) {
            return;
        }
        String string3 = httpServletRequest.getParameter("datasourceId");
        if (StringUtils.isBlank(string3)) {
            return;
        }
        String string4 = httpServletRequest.getParameter("inputParams");
        List list = new ArrayList();
        if (StringUtils.isNotBlank(string4)) {
            list = (List)JsonUtils.getObjectJsonMapper().readValue(string4, (TypeReference)new TypeReference<List<DataParam>>(){});
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        DataSource dataSource = DataSourceManager.ins.get(Long.parseLong(string3));
        if (dataSource == null) {
            this.a(httpServletResponse, arrayList);
            return;
        }
        javax.sql.DataSource dataSource2 = DataSourceHandlerManager.getDataSource(dataSource);
        Connection connection = dataSource2.getConnection();
        try {
            Object object;
            Object object2;
            Dialect dialect = DialectResolver.resolveDialect(connection);
            String string5 = dialect.getLimitString(string, 0, 1);
            if (dialect instanceof OrderLimitDialect) {
                string5 = string + " limit 1";
            }
            ParsedSql parsedSql = NamedSQLUtils.parseSql(string5);
            String string6 = JdbcUtils.getOriginSql(parsedSql.getOriginalSql());
            e.debug((Object)("builder fields sql:" + string6));
            PreparedStatement preparedStatement = connection.prepareStatement(string6);
            if (StringUtils.isBlank(string2)) {
                object2 = new ArrayList();
                for (String string7 : parsedSql.getParameterNames()) {
                    DataParam dataParam = null;
                    for (Object object3 : list) {
                        if (!string7.equalsIgnoreCase(((DataParam)object3).getName())) continue;
                        dataParam = object3;
                        break;
                    }
                    object = new DataParam();
                    ((DataParam)object).setName(string7);
                    if (dataParam != null) {
                        Object object3;
                        ((DataParam)object).setDataType(dataParam.getDataType());
                        object3 = ((DataParam)object).getDataType();
                        if ("String".equals(object3) || "Char".equals(object3)) {
                            ((DataParam)object).setValue("");
                        } else if ("Integer".equals(object3)) {
                            ((DataParam)object).setValue(new Integer(0));
                        } else if ("Long".equals(object3)) {
                            ((DataParam)object).setValue(new Long(0L));
                        } else if ("Float".equals(object3)) {
                            ((DataParam)object).setValue(new Float(0.0f));
                        } else if ("Double".equals(object3)) {
                            ((DataParam)object).setValue(new Double(0.0));
                        } else if ("BigDecimal".equals(object3)) {
                            ((DataParam)object).setValue(new BigDecimal(0));
                        } else if ("Boolean".equals(object3)) {
                            ((DataParam)object).setValue(false);
                        } else if ("Date".equals(object3)) {
                            ((DataParam)object).setValue(new Date());
                        } else if ("DateTime".equals(object3)) {
                            ((DataParam)object).setValue(new Timestamp(System.currentTimeMillis()));
                        }
                    }
                    object2.add(object);
                }
                StmtUtils.setStmtQueryParameters(parsedSql, (List<DataParam>)object2, preparedStatement);
            }
            object2 = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = object2.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                object = resultSetMetaData.getColumnLabel(i + 1);
                if (StringUtils.isBlank(object)) {
                    object = resultSetMetaData.getColumnName(i + 1);
                }
                if ((n2 = ((String)object).lastIndexOf(".")) > -1) {
                    object = ((String)object).substring(n2 + 1);
                }
                if ("rownum_".equals(object)) continue;
                int n3 = resultSetMetaData.getColumnType(i + 1);
                FieldType fieldType = JdbcUtils.buildJdbcFieldType(n3);
                arrayList.add(new Field((String)object, fieldType));
            }
            JdbcUtils.closeResultSet((ResultSet)object2);
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    throw new RuleException((Exception)sQLException);
                }
                catch (Throwable throwable) {
                    throw new RuleException(throwable.getMessage());
                }
            }
        }
        this.a(httpServletResponse, arrayList);
    }

    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void doExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = httpServletRequest.getParameter("type");
        ArrayList<Batch> arrayList = new ArrayList<Batch>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string2 = "batchs";
        if ("all".equals(string)) {
            object = BatchManager.ins.createQuery().projectId(ContextHolder.getProjectId()).list();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Batch batch = (Batch)iterator.next();
                Batch batch2 = SchemeService.ins.getBatchData(batch.getId());
                arrayList.add(batch2);
            }
        } else {
            object = httpServletRequest.getParameter("ids");
            if (StringUtils.isNotBlank(object)) {
                String[] stringArray = ((String)object).split(",");
                if (stringArray.length == 1) {
                    Batch batch = SchemeService.ins.getBatchData(Long.valueOf(stringArray[0].trim()));
                    string2 = batch.getName();
                    arrayList.add(batch);
                } else {
                    for (String string3 : stringArray) {
                        Batch batch = SchemeService.ins.getBatchData(Long.valueOf(string3));
                        arrayList.add(batch);
                    }
                }
            }
        }
        string2 = string2 + "-" + simpleDateFormat.format(new Date()) + ".batch.bak";
        httpServletResponse.setContentType("application/octet-stream;charset=ISO8859-1");
        string2 = new String(string2.getBytes("UTF-8"), "ISO8859-1");
        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string2 + "\"");
        object = httpServletResponse.getOutputStream();
        BatchExport.ins.doExport((OutputStream)object, arrayList);
        object.flush();
        object.close();
    }

    @Transactional
    @URuleAuthorization(authType="project", code="manager", model="batches")
    public void doImport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = Long.parseLong(httpServletRequest.getParameter("projectId"));
        Project project = ProjectManager.ins.get(l);
        UploadFile uploadFile = FileUtils.uploadFile(httpServletRequest);
        InputStream inputStream = uploadFile.getInputStream();
        BatchImport.ins.doImport(inputStream, project);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    @Override
    public String url() {
        return URL;
    }
}

