/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.batch.in;

import com.bstek.urule.Utils;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.batch.SchemeService;
import com.bstek.urule.console.database.manager.batch.BatchManager;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.batch.Batch;
import com.bstek.urule.console.database.model.batch.BatchDataProvider;
import com.bstek.urule.console.database.model.batch.BatchDataProviderField;
import com.bstek.urule.console.database.model.batch.BatchDataResolver;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItem;
import com.bstek.urule.console.database.model.batch.BatchDataResolverItemField;
import com.bstek.urule.console.database.model.batch.BatchUpdateMode;
import com.bstek.urule.console.database.model.batch.TranScope;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.entity.User;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.console.xml.DocumentHelper;
import com.bstek.urule.exception.RuleException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class BatchImport {
    public static final BatchImport ins = new BatchImport();

    public void doImport(InputStream inputStream, Project project) throws Exception {
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        String string = Utils.uncompress((byte[])byArray);
        Document document = DocumentHelper.parseText(string);
        Element element = document.getRootElement();
        if (!element.getName().contentEquals("batchs")) {
            throw new InfoException("\u6587\u4ef6\u4e0d\u5408\u6cd5\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2aURule Pro4+\u9879\u76ee\u5bfc\u51fa\u7684\u5907\u4efd\u6587\u4ef6");
        }
        this.doImport(element, project);
    }

    public void doImport(Element element, Project project) throws Exception {
        for (Object e : element.elements()) {
            if (!(e instanceof Element)) continue;
            Element element2 = (Element)e;
            Batch batch = new Batch();
            batch.setName(element2.attributeValue("name"));
            if (StringUtils.isBlank(batch.getName())) {
                throw new InfoException("\u6587\u4ef6\u4e0d\u5408\u6cd5\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2aURule Pro4+\u9879\u76ee\u5bfc\u51fa\u7684\u5907\u4efd\u6587\u4ef6");
            }
            String string = batch.getName();
            List<Batch> list = BatchManager.ins.createQuery().projectId(project.getId()).list();
            string = this.a(list, string);
            batch.setName(string);
            User user = SecurityUtils.getLoginUser(RequestHolder.getRequest());
            batch.setProjectId(project.getId());
            String string2 = this.a(element2, "desc");
            batch.setDesc(string2);
            batch.setSkipLimit(Integer.valueOf(element2.attributeValue("skip-limit")));
            batch.setAsync(Boolean.valueOf(element2.attributeValue("async")));
            batch.setCallbackUrl(element2.attributeValue("callback-url"));
            batch.setListener(element2.attributeValue("listener"));
            batch.setThreadMulti(Boolean.valueOf(element2.attributeValue("thread-multi")));
            batch.setThreadSize(Integer.valueOf(element2.attributeValue("thread-size")));
            batch.setThreadDataSize(Integer.valueOf(element2.attributeValue("thread-data-size")));
            batch.setPacketId(Long.valueOf(element2.attributeValue("packet-id")));
            batch.setProviderId(Long.valueOf(element2.attributeValue("provider-id")));
            batch.setResolverId(Long.valueOf(element2.attributeValue("resolver-id")));
            batch.setPacketInputData(this.a(element2, "packet-input-data"));
            batch.setRestEnable(Boolean.valueOf(element2.attributeValue("rest-enable")));
            batch.setRestSecurityEnable(Boolean.valueOf(element2.attributeValue("rest-security-enable")));
            batch.setRestSecurityUser(element2.attributeValue("rest-security-user"));
            batch.setRestSecurityPassword(element2.attributeValue("rest-security-password"));
            batch.setInputData(this.a(element2, "input-data"));
            for (Object e2 : element2.elements()) {
                Object object;
                if (!(e2 instanceof Element)) continue;
                Element element3 = (Element)e2;
                if (element3.getName().contentEquals("provider")) {
                    object = new BatchDataProvider();
                    batch.setDataProvider((BatchDataProvider)object);
                    this.a(element3, (BatchDataProvider)object);
                    continue;
                }
                if (!element3.getName().contentEquals("resolver")) continue;
                object = new BatchDataResolver();
                batch.setDataResolver((BatchDataResolver)object);
                this.a(element3, (BatchDataResolver)object);
            }
            SchemeService.ins.add(batch, user.getName());
        }
    }

    private String a(List<Batch> list, String string) {
        for (int i = 0; i < 10000; ++i) {
            String string2 = string;
            if (i > 0) {
                string2 = string2 + i;
            }
            boolean bl = false;
            for (Batch batch : list) {
                if (!batch.getName().contentEquals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            string = string2;
            break;
        }
        return string;
    }

    private boolean a(Element element, BatchDataProvider batchDataProvider) {
        batchDataProvider.setName(element.attributeValue("name"));
        batchDataProvider.setDatasourceId(Long.valueOf(element.attributeValue("datasource-id")));
        batchDataProvider.setListener(element.attributeValue("listener"));
        batchDataProvider.setDesc(this.a(element, "desc"));
        batchDataProvider.setInputData(this.a(element, "input-data"));
        batchDataProvider.setPacketVarName(element.attributeValue("packet-var-name"));
        batchDataProvider.setSupportsPaging(Boolean.valueOf(element.attributeValue("support-paging")));
        batchDataProvider.setPageSize(Integer.valueOf(element.attributeValue("page-size")));
        batchDataProvider.setPageSql(this.a(element, "page-sql"));
        batchDataProvider.setOrderField(element.attributeValue("order-field"));
        batchDataProvider.setOrderFieldParamName(element.attributeValue("order-field-param-name"));
        batchDataProvider.setPageLimitType(element.attributeValue("page-limit-type"));
        batchDataProvider.setCountSql(this.a(element, "count-sql"));
        batchDataProvider.setFilterData(this.a(element, "filter-data"));
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().contentEquals("field")) continue;
            this.b(element2, batchDataProvider);
        }
        return true;
    }

    private void b(Element element, BatchDataProvider batchDataProvider) {
        long l;
        BatchDataProviderField batchDataProviderField = new BatchDataProviderField();
        batchDataProvider.getFields().add(batchDataProviderField);
        batchDataProviderField.setSrcProperty(element.attributeValue("src-property"));
        batchDataProviderField.setDataType(element.attributeValue("data-type"));
        batchDataProviderField.setClassPath(element.attributeValue("classpath"));
        batchDataProviderField.setDestProperty(element.attributeValue("dest-property"));
        String string = element.attributeValue("provider-id");
        if (StringUtils.isNotBlank(string) && (l = Long.valueOf(string).longValue()) > 0L) {
            for (Object e : element.elements()) {
                Element element2;
                if (!(e instanceof Element) || !(element2 = (Element)e).getName().contentEquals("provider")) continue;
                BatchDataProvider batchDataProvider2 = new BatchDataProvider();
                batchDataProviderField.setDataProvider(batchDataProvider2);
                this.a(element2, batchDataProvider2);
            }
        }
    }

    private boolean a(Element element, BatchDataResolver batchDataResolver) {
        batchDataResolver.setName(element.attributeValue("name"));
        batchDataResolver.setListener(element.attributeValue("listener"));
        batchDataResolver.setTranScope(TranScope.valueOf(element.attributeValue("tran-scope")));
        batchDataResolver.setFilterData(this.a(element, "filter-data"));
        batchDataResolver.setDatasourceId(Long.valueOf(element.attributeValue("datasource-id")));
        batchDataResolver.setDesc(this.a(element, "desc"));
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().contentEquals("item")) continue;
            this.b(element2, batchDataResolver);
        }
        return true;
    }

    private void b(Element element, BatchDataResolver batchDataResolver) {
        BatchDataResolverItem batchDataResolverItem = new BatchDataResolverItem();
        batchDataResolver.getItems().add(batchDataResolverItem);
        batchDataResolverItem.setName(element.attributeValue("name"));
        batchDataResolverItem.setUpdateMode(BatchUpdateMode.valueOf(element.attributeValue("update-mode")));
        batchDataResolverItem.setTableName(element.attributeValue("table-name"));
        batchDataResolverItem.setFilterData(this.a(element, "filter-data"));
        batchDataResolverItem.setPartitionName(element.attributeValue("partition-name"));
        batchDataResolverItem.setPartitionValue(element.attributeValue("partition-value"));
        batchDataResolverItem.setCommitLimit(Integer.parseInt(element.attributeValue("commit-limit")));
        batchDataResolverItem.setDesc(this.a(element, "desc"));
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().contentEquals("field")) continue;
            this.a(element2, batchDataResolverItem);
        }
    }

    private void a(Element element, BatchDataResolverItem batchDataResolverItem) {
        BatchDataResolverItemField batchDataResolverItemField = new BatchDataResolverItemField();
        batchDataResolverItemField.setSrcProperty(element.attributeValue("src-property"));
        batchDataResolverItemField.setKey(Boolean.valueOf(element.attributeValue("key")));
        batchDataResolverItemField.setDataType(element.attributeValue("data-type"));
        batchDataResolverItemField.setDestProperty(element.attributeValue("dest-property"));
        batchDataResolverItem.getFields().add(batchDataResolverItemField);
    }

    private String a(Element element, String string) {
        String string2 = null;
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().contentEquals(string)) continue;
            string2 = element2.getText();
            break;
        }
        if (StringUtils.isNotBlank(string2)) {
            try {
                string2 = IOUtils.toString((byte[])Base64.getDecoder().decode(string2), (String)"utf-8");
            }
            catch (IOException iOException) {
                throw new RuleException((Exception)iOException);
            }
        }
        return string2;
    }
}

