/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.group;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.IllegalOperationException;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.ParameterInvaidException;
import com.bstek.urule.console.PermissionDeniedException;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.TransactionalInvoke;
import com.bstek.urule.console.admin.group.GroupUserVO;
import com.bstek.urule.console.admin.group.ProjectVO;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketCacheImpl;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.group.role.GroupRoleManager;
import com.bstek.urule.console.database.manager.group.user.UserQuery;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.project.ProjectQuery;
import com.bstek.urule.console.database.manager.report.PacketDeployVO;
import com.bstek.urule.console.database.manager.report.ReportGroupQuery;
import com.bstek.urule.console.database.manager.user.UserManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.GroupRole;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.group.GroupService;
import com.bstek.urule.console.database.service.group.role.GroupRoleService;
import com.bstek.urule.console.security.AuthenticationManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthAnonymous;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.GroupModule;
import com.bstek.urule.console.type.GroupRoleEnum;
import com.bstek.urule.console.type.ProjectModule;
import com.bstek.urule.console.type.RoleCategory;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;

public class GroupServletHandler
extends ApiServletHandler {
    public void list(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        this.a(httpServletResponse, GroupManager.ins.createQuery().list(string));
    }

    @Transactional
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Group group = (Group)this.a().readValue(httpServletRequest.getParameter("group"), Group.class);
        if (group.getId().length() < 3) {
            throw new InfoException("\u56e2\u961fID\u7684\u81f3\u5c113\u4e2a\u5b57\u7b26<br>Team id must be at least three characters");
        }
        group.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        GroupService.ins.add(group);
        List<Group> list = GroupManager.ins.createQuery().list(SecurityUtils.getLoginUsername(httpServletRequest));
        com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
        user.setGroups(list);
        this.a(httpServletResponse, group);
    }

    public void remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        final String string = httpServletRequest.getParameter("groupId");
        Group group = GroupManager.ins.get(string);
        if (!SecurityUtils.getLoginUsername(httpServletRequest).equals(group.getCreateUser())) {
            throw new PermissionDeniedException("Permission denied for team [" + string + "]");
        }
        this.a(new TransactionalInvoke(){

            @Override
            public void doTransactional() {
                GroupService.ins.remove(string);
            }
        });
        List<Group> list = GroupManager.ins.createQuery().list(SecurityUtils.getLoginUsername(httpServletRequest));
        com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
        user.setGroups(list);
        List<Map<String, Object>> list2 = ((PacketCacheImpl)PacketCache.ins).recacheAllPackets(string);
        this.a(httpServletResponse, list2);
    }

    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Group group;
        Group group2 = (Group)this.a().readValue(httpServletRequest.getParameter("group"), Group.class);
        if (group2.getId().equals(ContextHolder.getGroupId())) {
            group = GroupManager.ins.get(group2.getId());
            if (!SecurityUtils.getLoginUsername(httpServletRequest).equals(group2.getCreateUser())) {
                throw new PermissionDeniedException("Permission denied for team [" + group2.getId() + "]");
            }
        } else {
            throw new ParameterInvaidException();
        }
        group.setName(group2.getName());
        group.setDesc(group2.getDesc());
        group.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        GroupManager.ins.update(group);
        this.a(httpServletResponse, group);
    }

    public void get(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        Group group = GroupManager.ins.get(string);
        this.a(httpServletResponse, group);
    }

    @URuleAuthAnonymous
    public void freeCreate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.a(httpServletResponse, GroupService.ins.isFreeCreate(SecurityUtils.getLoginUsername(httpServletRequest)));
    }

    public void roles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        this.a(httpServletResponse, GroupRoleService.ins.loadRoles(string));
    }

    public void userRoles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        String string2 = httpServletRequest.getParameter("account");
        this.a(httpServletResponse, GroupRoleService.ins.loadUserRoles(string, string2));
    }

    @URuleAuthorization(authType="group", code="manager", model="permissions")
    public void addRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("roleName");
        if (!StringUtils.isNotBlank(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        GroupRole groupRole = new GroupRole();
        groupRole.setName(string);
        groupRole.setGroupId(ContextHolder.getGroupId());
        groupRole.setType("custom");
        GroupRoleService.ins.add(groupRole);
        this.a(httpServletResponse, groupRole);
        SystemLogUtils.addGroupOperationLog(GroupModule.permissions.name(), "manager", groupRole.getId(), "\u521b\u5efa\u4e86\u89d2\u8272[" + groupRole.getName() + "]");
    }

    @URuleAuthorization(authType="group", code="manager", model="permissions")
    public void renameRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        String string = httpServletRequest.getParameter("roleName");
        GroupRole groupRole = GroupRoleService.ins.get(l);
        if (!groupRole.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        String string2 = groupRole.getName();
        groupRole.setName(string);
        GroupRoleService.ins.update(groupRole);
        SystemLogUtils.addGroupOperationLog(GroupModule.permissions.name(), "manager", groupRole.getId(), "\u4fee\u6539\u89d2\u8272[" + string2 + "]\u7684\u540d\u79f0\u4e3a:" + string);
    }

    @URuleAuthorization(authType="group", code="manager", model="permissions")
    public void removeRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        GroupRole groupRole = GroupRoleManager.ins.get(l);
        if (!groupRole.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        GroupRoleService.ins.remove(l);
        SystemLogUtils.addGroupOperationLog(GroupModule.permissions.name(), "manager", groupRole.getId(), "\u5220\u9664\u89d2\u8272[" + groupRole.getName() + "]");
    }

    @URuleAuthorization(authType="group", model="members", code="add")
    @Transactional
    public void addUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        User user = (User)this.a().readValue(httpServletRequest.getParameter("user"), User.class);
        String string = user.getId();
        if (StringUtils.isNotBlank(ContextHolder.getGroupId()) && StringUtils.isNotBlank(string)) {
            Group group = GroupManager.ins.get(ContextHolder.getGroupId());
            if (string.equals(group.getCreateUser())) {
                throw new IllegalOperationException("\u8be5\u8d26\u53f7\u662f\u56e2\u961f\u7ba1\u7406\u5458,\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0!");
            }
            User user2 = UserManager.ins.get(string);
            if (user2 != null) {
                throw new IllegalOperationException("\u8be5\u8d26\u53f7\u4ee5\u5b58\u5728,\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0!");
            }
        } else {
            throw new ParameterInvaidException();
        }
        user.setEnable(true);
        user.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        UserManager.ins.add(user);
        GroupService.ins.addGroupUser(ContextHolder.getGroupId(), string);
        GroupRole groupRole = GroupRoleManager.ins.get(ContextHolder.getGroupId(), GroupRoleEnum.User.name());
        GroupRoleService.ins.addUserRole(ContextHolder.getGroupId(), string, groupRole.getId());
        SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "add", string, "\u6dfb\u52a0\u6210\u5458:" + string);
    }

    @URuleAuthorization(authType="group", model="members", code="add")
    @Transactional
    public void addUserByAccount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        if (StringUtils.isNotBlank(string) && StringUtils.isNotBlank(ContextHolder.getGroupId())) {
            Group group = GroupManager.ins.get(ContextHolder.getGroupId());
            if (string.equals(group.getCreateUser())) {
                throw new RuleException("\u4e0d\u80fd\u6dfb\u52a0\u56e2\u961f\u7ba1\u7406\u5458\u8d26\u53f7!<br>Illegal Operation! The account is group owner.");
            }
            User user = UserManager.ins.get(string);
            if (user == null) {
                throw new RuleException("\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728!<br>Account does not exist!");
            }
            User user2 = GroupManager.ins.getGroupUser(string, string);
            if (user2 != null) {
                throw new RuleException("\u8d26\u53f7\u5df2\u7ecf\u5728\u5f53\u524d\u56e2\u961f\u4e2d,\u65e0\u9700\u91cd\u590d\u52a0\u5165!<br>The account is already in the team!");
            }
        } else {
            throw new ParameterInvaidException();
        }
        GroupService.ins.addGroupUser(ContextHolder.getGroupId(), string);
        GroupRole groupRole = GroupRoleManager.ins.get(ContextHolder.getGroupId(), GroupRoleEnum.User.name());
        GroupRoleService.ins.addUserRole(ContextHolder.getGroupId(), string, groupRole.getId());
        SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "add", string, "\u6dfb\u52a0\u6210\u5458:" + string);
    }

    @URuleAuthorization(authType="group", model="members", code="remove")
    @Transactional
    public void removeUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        if (StringUtils.isNotBlank(string) && StringUtils.isNotBlank(ContextHolder.getGroupId())) {
            Group group = GroupManager.ins.get(ContextHolder.getGroupId());
            if (string.equals(group.getCreateUser())) {
                throw new IllegalOperationException("\u5f53\u524d\u8d26\u53f7\u662f\u56e2\u961f\u6240\u6709\u8005\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            }
        } else {
            throw new ParameterInvaidException();
        }
        GroupService.ins.removeGroupUser(ContextHolder.getGroupId(), string);
        SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "remove", string, "\u5220\u9664\u6210\u5458:" + string);
    }

    @Transactional
    public void removeUserSelf(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        if (StringUtils.isNotBlank(ContextHolder.getGroupId())) {
            Group group;
            string = SecurityUtils.getLoginUsername(httpServletRequest);
            if (string.equals((group = GroupManager.ins.get(ContextHolder.getGroupId())).getCreateUser())) {
                throw new IllegalOperationException("\u60a8\u662f\u5f53\u524d\u56e2\u961f\u62e5\u6709\u8005\uff0c\u65e0\u6cd5\u63a8\u51fa\u56e2\u961f\uff01");
            }
        } else {
            throw new ParameterInvaidException();
        }
        GroupService.ins.removeGroupUser(ContextHolder.getGroupId(), string);
        SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "remove", string, "\u5220\u9664\u6210\u5458:" + string);
    }

    @URuleAuthorization(authType="group", code="userrole", model="members")
    public void addUserRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        GroupRole groupRole = GroupRoleService.ins.get(l);
        if (!groupRole.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        GroupRoleService.ins.addUserRole(groupRole.getGroupId(), string, l);
        SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "userrole", string, "\u4e3a[" + string + "]\u6dfb\u52a0\u89d2\u8272[" + groupRole.getName() + "]");
    }

    @URuleAuthorization(authType="group", code="userrole", model="members")
    public void removeUserRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        GroupRole groupRole = GroupRoleService.ins.get(l);
        if (!groupRole.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        GroupRoleService.ins.removeUserRole(ContextHolder.getGroupId(), string, l);
        SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "userrole", string, "\u4e3a[" + string + "]\u5220\u9664\u89d2\u8272[" + groupRole.getName() + "]");
    }

    public void users(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        String string2 = httpServletRequest.getParameter("roleId");
        String string3 = httpServletRequest.getParameter("keyword");
        int n = Integer.parseInt(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.parseInt(httpServletRequest.getParameter("pageSize"));
        UserQuery userQuery = GroupManager.ins.createUserQuery();
        if (StringUtils.isNotBlank(string3)) {
            userQuery.idnameLike(string3);
        }
        if (StringUtils.isBlank(string2) || "-1".equals(string2)) {
            Page<User> page = userQuery.users(n, n2, string);
            this.a(string, page);
            this.a(httpServletResponse, page);
        } else {
            Page<User> page = userQuery.roleUsers(n, n2, string, Long.parseLong(string2));
            this.a(string, page);
            this.a(httpServletResponse, page);
        }
    }

    private void a(String string, Page<User> page) throws Exception {
        ArrayList<GroupUserVO> arrayList = new ArrayList<GroupUserVO>();
        List<?> list = page.getData();
        for (User user : list) {
            GroupUserVO groupUserVO = new GroupUserVO();
            groupUserVO.setId(user.getId());
            groupUserVO.setName(user.getName());
            groupUserVO.setCreateDate(user.getCreateDate());
            groupUserVO.setRoles(GroupRoleManager.ins.loadUserRoles(string, user.getId()));
            arrayList.add(groupUserVO);
        }
        page.setData(arrayList);
    }

    public void roleUsers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("roleId");
        String string2 = httpServletRequest.getParameter("groupId");
        this.a(httpServletResponse, GroupRoleManager.ins.loadRoleUsers(string2, Long.parseLong(string)));
    }

    public void projects(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.a(httpServletRequest, httpServletResponse, true);
    }

    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws Exception {
        String string = ContextHolder.getGroupId();
        String string2 = httpServletRequest.getParameter("keyword");
        String string3 = httpServletRequest.getParameter("type");
        String string4 = httpServletRequest.getParameter("sortByName");
        String string5 = httpServletRequest.getParameter("sortByAsc");
        ProjectQuery projectQuery = ProjectManager.ins.newQuery();
        String string6 = SecurityUtils.getLoginUsername(httpServletRequest);
        if (bl) {
            projectQuery.userId(string6);
        }
        if (StringUtils.isNotBlank(string2)) {
            projectQuery.nameLike(string2);
        }
        if (StringUtils.isNotBlank(string3)) {
            projectQuery.type(string3);
        }
        if (StringUtils.isNotBlank(string)) {
            projectQuery.groupId(string);
        }
        if (StringUtils.isNotBlank(string4) && StringUtils.isNotBlank(string5)) {
            if ("NAME_".equals(string4)) {
                projectQuery.orderbyName(string5);
            }
            if ("CREATE_DATE_".equals(string4)) {
                projectQuery.orderbyCreateDate(string5);
            }
        }
        List<Project> list = projectQuery.list();
        ArrayList<ProjectVO> arrayList = new ArrayList<ProjectVO>();
        com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
        List<Long> list2 = ProjectManager.ins.newQuery().groupId(string).userId(string6).listIds();
        for (Project project : list) {
            ProjectVO projectVO = new ProjectVO();
            BeanUtils.copyProperties((Object)projectVO, (Object)project);
            ContextHolder.setProjectId(project.getId());
            boolean bl2 = AuthenticationManager.decide(user, RoleCategory.group, GroupModule.projects.toString(), "remove");
            if (!bl2) {
                bl2 = AuthenticationManager.decide(user, RoleCategory.project, ProjectModule.project.toString(), "remove");
            }
            projectVO.setRemoveAble(bl2);
            bl2 = AuthenticationManager.decide(user, RoleCategory.group, GroupModule.projects.toString(), "export");
            if (!bl2) {
                bl2 = AuthenticationManager.decide(user, RoleCategory.project, ProjectModule.project.toString(), "export");
            }
            projectVO.setExportAble(bl2);
            if (list2.contains(project.getId())) {
                projectVO.setAccessable(true);
            }
            arrayList.add(projectVO);
        }
        this.a(httpServletResponse, arrayList);
    }

    public void projectList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.a(httpServletRequest, httpServletResponse, false);
    }

    public void countUserLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        List<LinkedHashMap<String, Object>> list = ReportGroupQuery.getUserLoginCountByDay(string, date, date2);
        this.a(httpServletResponse, list);
    }

    public void countRuleProjectCount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        List<LinkedHashMap<String, Object>> list = ReportGroupQuery.countProjectRuleFiles(string);
        this.a(httpServletResponse, list);
    }

    public void listPacketDeploys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        List<PacketDeployVO> list = ReportGroupQuery.listPacketDeploys(string);
        if (list.size() > 5) {
            this.a(httpServletResponse, list.subList(0, 5));
        } else {
            this.a(httpServletResponse, list);
        }
    }

    public void listUserProjects(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        List<LinkedHashMap<String, Object>> list = ReportGroupQuery.countUserCreateProjects(string);
        this.a(httpServletResponse, list);
    }

    public void getSummary(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        int n = ProjectManager.ins.newQuery().groupId(string).list().size();
        int n2 = ReportGroupQuery.countKnByGroupId(string);
        int n3 = ReportGroupQuery.countFileByGroupId(string);
        int n4 = ReportGroupQuery.countBatchByGroupId(string);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("projectCount", n);
        hashMap.put("packetCount", n2);
        hashMap.put("fileCount", n3);
        hashMap.put("batchCount", n4);
        this.a(httpServletResponse, hashMap);
    }

    @Override
    public String url() {
        return "/group";
    }
}

