/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.invite;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.IllegalOperationException;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.admin.RegisterInfo;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.invite.InviteManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.Invite;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.group.GroupService;
import com.bstek.urule.console.database.service.user.PersistUserService;
import com.bstek.urule.console.database.service.user.UserServiceImpl;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthAnonymous;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.GroupModule;
import com.bstek.urule.console.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InviteServletHandler
extends ApiServletHandler {
    private static final Log e = LogFactory.getLog(InviteServletHandler.class);

    @URuleAuthAnonymous
    public void group(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("key");
        Invite invite = InviteManager.ins.get(string);
        if (invite == null || System.currentTimeMillis() - invite.getExpirDate().getTime() > 1800000L) {
            throw new InfoException("\u94fe\u63a5\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6\u94fe\u63a5!");
        }
        Group group = GroupManager.ins.get(invite.getGroupId());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sendUser", invite.getCreateUser());
        hashMap.put("group", group);
        this.a(httpServletResponse, hashMap);
    }

    @URuleAuthorization(authType="group", code="join", model="members")
    public void url(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        Group group = GroupManager.ins.get(string);
        if (group == null) {
            throw new InfoException("\u56e2\u961f\u4e0d\u5b58\u5728.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis() + 1800000L);
            Invite invite = new Invite();
            invite.setGroupId(string);
            invite.setType("TIME");
            invite.setSecretKey(string2);
            invite.setExpirDate(timestamp);
            invite.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
            InviteManager.ins.add(invite);
            String string3 = httpServletRequest.getRequestURL().toString();
            String string4 = string3.substring(0, string3.length() - "api/invite/url".length()) + "invite?key=" + string2;
            hashMap.put("data", string4);
            SystemLogUtils.addGroupOperationLog(GroupModule.members.name(), "add", invite.getCreateUser(), "[" + invite.getCreateUser() + "]\u521b\u5efa\u9080\u8bf7\u94fe\u63a5");
        }
        catch (Exception exception) {
            throw new InfoException("\u9080\u8bf7\u94fe\u63a5\u751f\u6210\u5931\u8d25\uff01");
        }
        this.a(httpServletResponse, hashMap);
    }

    @URuleAuthAnonymous
    public void join(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("key");
        String string2 = httpServletRequest.getParameter("account");
        String string3 = httpServletRequest.getParameter("password");
        Invite invite = InviteManager.ins.get(string);
        if (invite == null || System.currentTimeMillis() - invite.getExpirDate().getTime() > 1800000L) {
            throw new InfoException("\u94fe\u63a5\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6\u94fe\u63a5!");
        }
        GroupService.ins.addGroupUser(invite.getGroupId(), string2);
        HashMap<String, com.bstek.urule.console.security.entity.User> hashMap = new HashMap<String, com.bstek.urule.console.security.entity.User>();
        try {
            SecurityUtils.getSecurityProvider().login(httpServletRequest, string2, string3);
            SystemLogUtils.addLoginLog(RequestHolder.getRequest());
            hashMap.put("user", SecurityUtils.getLoginUser(httpServletRequest));
            e.debug((Object)("\u767b\u5f55\u6210\u529f,\u767b\u5f55\u7528\u6237:" + string2));
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
        this.a(httpServletResponse, hashMap);
    }

    @Transactional
    @URuleAuthAnonymous
    public void register(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u52a8\u6001\u6ce8\u518c\u7528\u6237\uff01");
        }
        HashMap<String, com.bstek.urule.console.security.entity.User> hashMap = new HashMap<String, com.bstek.urule.console.security.entity.User>();
        RegisterInfo registerInfo = (RegisterInfo)this.a().readValue(httpServletRequest.getParameter("register"), RegisterInfo.class);
        String string = registerInfo.getSecretKey();
        String string2 = registerInfo.getAccount();
        if (StringUtils.isBlank(string)) {
            throw new InfoException("\u53c2\u6570\u4e0d\u5408\u6cd5.");
        }
        Invite invite = InviteManager.ins.get(string);
        if (null == invite) {
            throw new InfoException("\u53c2\u6570\u4e0d\u5408\u6cd5.");
        }
        if (System.currentTimeMillis() - invite.getExpirDate().getTime() > 1800000L) {
            throw new InfoException("\u94fe\u63a5\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6\u94fe\u63a5!");
        }
        User user = UserServiceManager.getUserService().get(string2);
        if (null != user) {
            throw new InfoException("\u7528\u6237" + string2 + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u8c03\u6574.");
        }
        if (string2.length() < 3) {
            throw new InfoException("\u8d26\u53f7\u7684\u81f3\u5c113\u4e2a\u5b57\u7b26<br>Account must be at least three characters");
        }
        if (registerInfo.getPassword().length() < 8) {
            throw new InfoException("\u5bc6\u7801\u7684\u81f3\u5c118\u4e2a\u5b57\u7b26<br>Password must be at least three characters");
        }
        user = new User();
        user.setId(registerInfo.getAccount());
        user.setEnable(true);
        user.setName(registerInfo.getUsername());
        user.setPassword(registerInfo.getPassword());
        ((UserServiceImpl)UserServiceManager.getUserService()).add(user);
        GroupService.ins.addGroupUser(invite.getGroupId(), registerInfo.getAccount());
        SecurityUtils.getSecurityProvider().login(httpServletRequest, registerInfo.getAccount(), registerInfo.getPassword());
        SystemLogUtils.addLoginLog(RequestHolder.getRequest());
        hashMap.put("user", SecurityUtils.getLoginUser(httpServletRequest));
        this.a(httpServletResponse, hashMap);
    }

    @Override
    public String url() {
        return "/invite";
    }
}

