/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.log;

import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.admin.log.URuleLogService;
import com.bstek.urule.console.database.model.KnowledgeLog;
import com.bstek.urule.console.database.model.LoginLog;
import com.bstek.urule.console.database.model.OperationLog;
import com.bstek.urule.console.database.model.URuleLog;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.util.IPUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class URuleLogServiceImpl
implements URuleLogService {
    private BlockingQueue<URuleLog> a = new LinkedBlockingQueue<URuleLog>(100000);

    @Override
    public URuleLog pollLog() {
        return (URuleLog)this.a.poll();
    }

    @Override
    public void putLog(URuleLog uRuleLog) throws InterruptedException {
        this.a.put(uRuleLog);
    }

    @Override
    public boolean isQueueEmpty() {
        return this.a.isEmpty();
    }

    @Override
    public OperationLog getOperationLog() {
        OperationLog operationLog = new OperationLog();
        operationLog.setUserId(SecurityUtils.getLoginUsername(RequestHolder.getRequest()));
        operationLog.setUsername(SecurityUtils.getLoginUser(RequestHolder.getRequest()).getDesc());
        return operationLog;
    }

    @Override
    public LoginLog getLoginLog() {
        LoginLog loginLog = new LoginLog();
        loginLog.setUserId(SecurityUtils.getLoginUsername(RequestHolder.getRequest()));
        loginLog.setUsername(SecurityUtils.getLoginUser(RequestHolder.getRequest()).getDesc());
        loginLog.setIp(IPUtils.getIpAddress(RequestHolder.getRequest()));
        loginLog.setUserAgent(RequestHolder.getRequest().getHeader("User-Agent"));
        return loginLog;
    }

    @Override
    public KnowledgeLog getKnowledgeLog() {
        KnowledgeLog knowledgeLog = new KnowledgeLog();
        knowledgeLog.setIp(IPUtils.getIpAddress(RequestHolder.getRequest()));
        knowledgeLog.setUserAgent(RequestHolder.getRequest().getHeader("User-Agent"));
        return knowledgeLog;
    }
}

