/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.permission;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.ParameterInvaidException;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.database.manager.authority.AuthorityService;
import com.bstek.urule.console.database.manager.group.role.GroupRoleManager;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.model.GroupRole;
import com.bstek.urule.console.database.model.ProjectRole;
import com.bstek.urule.console.database.model.Role;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.security.entity.Module;
import com.bstek.urule.console.security.entity.Permission;
import com.bstek.urule.console.security.entity.User;
import com.bstek.urule.console.type.GroupModule;
import com.bstek.urule.console.type.ProjectModule;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PermissionServletHandler
extends ApiServletHandler {
    @URuleAuthorization(authType="group", model="permissions", code="manager")
    public void groupStore(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        GroupRole groupRole = GroupRoleManager.ins.get(l);
        if (!groupRole.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        this.a(l, httpServletRequest);
        SystemLogUtils.addGroupOperationLog(GroupModule.permissions.name(), "manager", l, "\u4fee\u6539[" + groupRole.getName() + "]\u7684\u6743\u9650");
    }

    @URuleAuthorization(authType="project", model="permissions", code="manager")
    public void projectStore(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        ProjectRole projectRole = ProjectRoleManager.ins.get(l);
        if (projectRole.getProjectId() != ContextHolder.getProjectId().longValue()) {
            throw new ParameterInvaidException();
        }
        this.a(l, httpServletRequest);
        SystemLogUtils.addProjectOperationLog(ProjectModule.permissions.name(), "manager", projectRole.getId(), "\u4fee\u6539[" + projectRole.getName() + "]\u7684\u6743\u9650");
    }

    private void a(long l, HttpServletRequest httpServletRequest) throws Exception {
        List list = (List)this.a().readValue(httpServletRequest.getParameter("models"), (TypeReference)new TypeReference<List<Module>>(){});
        AuthorityService.ins.storePermissions(l, list);
    }

    @URuleAuthorization(authType="group", model="permissions", code="manager")
    public void groupModels(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        GroupRole groupRole = GroupRoleManager.ins.get(l);
        if (!groupRole.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        this.a(httpServletResponse, AuthorityService.ins.getGroupModels(groupRole));
    }

    @URuleAuthorization(authType="project", model="permissions", code="manager")
    public void projectModels(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        ProjectRole projectRole = ProjectRoleManager.ins.get(l);
        if (projectRole.getProjectId() != ContextHolder.getProjectId().longValue()) {
            throw new ParameterInvaidException();
        }
        this.a(httpServletResponse, AuthorityService.ins.getProjectModels(projectRole));
    }

    public void group(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        User user = SecurityUtils.getLoginUser(httpServletRequest);
        List<Role> list = GroupRoleManager.ins.loadUserRoles(string, user.getName());
        ArrayList<Module> arrayList = new ArrayList();
        for (Role role : list) {
            List<Module> list2 = AuthorityService.ins.getGroupModels(role);
            if (arrayList.size() == 0) {
                arrayList = list2;
                continue;
            }
            this.a(list2, arrayList);
        }
        this.a(httpServletResponse, arrayList);
    }

    public void project(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = ContextHolder.getProjectId();
        User user = SecurityUtils.getLoginUser(httpServletRequest);
        List<Role> list = ProjectRoleManager.ins.loadUserRoles(l, user.getName());
        ArrayList<Module> arrayList = new ArrayList();
        for (Role role : list) {
            List<Module> list2 = AuthorityService.ins.getProjectModels(role);
            if (arrayList.size() == 0) {
                arrayList = list2;
                continue;
            }
            this.a(list2, arrayList);
        }
        this.a(httpServletResponse, arrayList);
    }

    private void a(List<Module> list, List<Module> list2) {
        for (Module module : list2) {
            for (Module module2 : list) {
                if (!module.getCode().equals(module2.getCode())) continue;
                this.b(module2.getItems(), module.getItems());
            }
        }
    }

    private void b(List<Permission> list, List<Permission> list2) {
        for (Permission permission : list2) {
            for (Permission permission2 : list) {
                if (!permission.getCode().equals(permission2.getCode()) || !permission2.isChecked()) continue;
                permission.setChecked(true);
            }
        }
    }

    @Override
    public String url() {
        return "/permission";
    }
}

