/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.project;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.ParameterInvaidException;
import com.bstek.urule.console.PermissionDeniedException;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.TransactionalInvoke;
import com.bstek.urule.console.admin.group.GroupUserVO;
import com.bstek.urule.console.admin.group.ProjectVO;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.admin.project.ProjectRoleVO;
import com.bstek.urule.console.admin.project.in.ConfigInfo;
import com.bstek.urule.console.admin.project.in.ProjectImport;
import com.bstek.urule.console.admin.project.out.ProjectExport;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketCacheImpl;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyManager;
import com.bstek.urule.console.database.manager.packet.apply.PacketApplyQuery;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.manager.project.ProjectQuery;
import com.bstek.urule.console.database.manager.project.role.ProjectRoleManager;
import com.bstek.urule.console.database.manager.project.user.UserQuery;
import com.bstek.urule.console.database.manager.report.PacketDeployVO;
import com.bstek.urule.console.database.manager.report.ReportGroupQuery;
import com.bstek.urule.console.database.manager.report.ReportProjectQuery;
import com.bstek.urule.console.database.model.ApplyStatus;
import com.bstek.urule.console.database.model.ApplyType;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.PacketApply;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.ProjectRole;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.project.ProjectService;
import com.bstek.urule.console.database.service.project.role.ProjectRoleService;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.database.vo.RuleCommitVO;
import com.bstek.urule.console.database.vo.RuleDeployVO;
import com.bstek.urule.console.database.vo.RuleExecVO;
import com.bstek.urule.console.database.vo.UserCommitVO;
import com.bstek.urule.console.security.AuthenticationManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.console.type.GroupModule;
import com.bstek.urule.console.type.ProjectModule;
import com.bstek.urule.console.type.RoleCategory;
import com.bstek.urule.console.util.FileUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.console.util.UploadFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;

public class ProjectServletHandler
extends ApiServletHandler {
    public void doExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.valueOf(httpServletRequest.getParameter("projectId"));
        Project project = ProjectManager.ins.get(l);
        com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
        boolean bl = AuthenticationManager.decide(user, RoleCategory.group, GroupModule.projects.toString(), "export");
        if (!bl) {
            bl = AuthenticationManager.decide(user, RoleCategory.project, ProjectModule.project.toString(), "export");
        }
        if (!bl) {
            throw new PermissionDeniedException("Permission denied for project [" + l + "]");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string = project.getName() + "-" + simpleDateFormat.format(new Date()) + ".urule.bak";
        httpServletResponse.setContentType("application/octet-stream;charset=ISO8859-1");
        string = new String(string.getBytes("UTF-8"), "ISO8859-1");
        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string + "\"");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ProjectExport.ins.doExport((OutputStream)servletOutputStream, project);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    @Transactional
    @URuleAuthorization(authType="group", model="projects", code="import")
    public void doImport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("groupId");
        Group group = GroupManager.ins.get(string);
        UploadFile uploadFile = FileUtils.uploadFile(httpServletRequest);
        InputStream inputStream = uploadFile.getInputStream();
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setReplace(Boolean.parseBoolean(httpServletRequest.getParameter("replace")));
        configInfo.setNewPacketCode(Boolean.parseBoolean(httpServletRequest.getParameter("newPacketCode")));
        configInfo.setForceLock(Boolean.parseBoolean(httpServletRequest.getParameter("forceLock")));
        new ProjectImport().doImport(inputStream, group, configInfo);
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void list(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        String string2 = httpServletRequest.getParameter("keyword");
        String string3 = httpServletRequest.getParameter("type");
        String string4 = httpServletRequest.getParameter("sortByName");
        String string5 = httpServletRequest.getParameter("sortByAsc");
        ProjectQuery projectQuery = ProjectManager.ins.newQuery();
        String string6 = SecurityUtils.getLoginUsername(httpServletRequest);
        projectQuery.userId(string6);
        if (StringUtils.isNotBlank(string2)) {
            projectQuery.nameLike(string2);
        }
        if (StringUtils.isNotBlank(string3)) {
            projectQuery.type(string3);
        }
        if (StringUtils.isNotBlank(string)) {
            projectQuery.groupId(string);
        }
        if (StringUtils.isNotBlank(string4) && StringUtils.isNotBlank(string5)) {
            if ("NAME_".equals(string4)) {
                projectQuery.orderbyName(string5);
            }
            if ("CREATE_DATE_".equals(string4)) {
                projectQuery.orderbyCreateDate(string5);
            }
        }
        this.a(httpServletResponse, projectQuery.list());
    }

    public void get(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = ContextHolder.getProjectId();
        Project project = ProjectManager.ins.get(l);
        this.a(httpServletResponse, project);
    }

    @URuleAuthorization(authType="group", model="projects", code="add")
    @Transactional
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl;
        ProjectVO projectVO;
        Project project = (Project)this.a().readValue(httpServletRequest.getParameter("project"), Project.class);
        if (project.getGroupId().equals(ContextHolder.getGroupId())) {
            project.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
            ProjectService.ins.add(project);
            SystemLogUtils.addGroupOperationLog(GroupModule.projects.name(), "add", project.getId(), "\u521b\u5efa\u4e86\u9879\u76ee[" + project.getName() + "]");
            com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
            projectVO = new ProjectVO();
            BeanUtils.copyProperties((Object)projectVO, (Object)project);
            ContextHolder.setProjectId(project.getId());
            bl = AuthenticationManager.decide(user, RoleCategory.group, GroupModule.projects.toString(), "remove");
            if (!bl) {
                bl = AuthenticationManager.decide(user, RoleCategory.project, ProjectModule.project.toString(), "remove");
            }
            projectVO.setRemoveAble(bl);
            bl = AuthenticationManager.decide(user, RoleCategory.group, GroupModule.projects.toString(), "export");
            if (!bl) {
                bl = AuthenticationManager.decide(user, RoleCategory.project, ProjectModule.project.toString(), "export");
            }
        } else {
            throw new ParameterInvaidException();
        }
        projectVO.setExportAble(bl);
        this.a(httpServletResponse, projectVO);
    }

    public void reload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        List<Map<String, Object>> list = ((PacketCacheImpl)PacketCache.ins).recacheAllPackets(httpServletRequest.getParameter("groupId"));
        this.a(httpServletResponse, list);
    }

    @URuleAuthorization(authType="group", model="projects", code="update")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Project project = (Project)this.a().readValue(httpServletRequest.getParameter("project"), Project.class);
        if (project.getGroupId().equals(ContextHolder.getGroupId())) {
            Project project2 = ProjectManager.ins.get(project.getId());
            if (!project2.getType().equals(project.getType())) {
                throw new ParameterInvaidException();
            }
        } else {
            throw new ParameterInvaidException();
        }
        project.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        project.setUpdateDate(new Date());
        ProjectService.ins.update(project);
        SystemLogUtils.addGroupOperationLog(GroupModule.projects.name(), "update", project.getId(), "\u4fee\u6539\u9879\u76ee[" + project.getName() + "]");
        this.a(httpServletResponse, project);
    }

    public void remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        final Long l = ContextHolder.getProjectId();
        Project project = ProjectManager.ins.get(l);
        com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
        boolean bl = AuthenticationManager.decide(user, RoleCategory.group, GroupModule.projects.toString(), "remove");
        if (!bl) {
            bl = AuthenticationManager.decide(user, RoleCategory.project, ProjectModule.project.toString(), "remove");
        }
        if (!bl) {
            throw new PermissionDeniedException("Permission denied for project [" + l + "]");
        }
        if (!project.getGroupId().equals(ContextHolder.getGroupId())) {
            throw new ParameterInvaidException();
        }
        this.a(new TransactionalInvoke(){

            @Override
            public void doTransactional() {
                ProjectService.ins.remove(l);
                SystemLogUtils.addGroupOperationLog(GroupModule.projects.name(), "remove", l, "\u5220\u9664\u9879\u76ee[" + l + "]");
            }
        });
        List<Map<String, Object>> list = ((PacketCacheImpl)PacketCache.ins).recacheAllPackets(project.getGroupId());
        this.a(httpServletResponse, list);
    }

    public void roles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        this.a(httpServletResponse, ProjectRoleService.ins.loadRoles(l));
    }

    @URuleAuthorization(authType="project", model="members", code="userrole")
    public void addUserRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        ProjectRole projectRole = ProjectRoleManager.ins.get(l);
        if (projectRole.getProjectId() != ContextHolder.getProjectId().longValue()) {
            throw new ParameterInvaidException();
        }
        ProjectRoleService.ins.addUserRole(projectRole.getProjectId(), string, l);
        SystemLogUtils.addProjectOperationLog(ProjectModule.members.name(), "addUserRole", projectRole.getId(), "\u9879\u76ee\u89d2\u8272[" + projectRole.getName() + "]\u6dfb\u52a0\u6210\u5458:" + string);
    }

    @URuleAuthorization(authType="project", model="members", code="userrole")
    public void removeUserRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        ProjectRole projectRole = ProjectRoleManager.ins.get(l);
        if (projectRole.getProjectId() != ContextHolder.getProjectId().longValue()) {
            throw new ParameterInvaidException();
        }
        SystemLogUtils.addProjectOperationLog(ProjectModule.members.name(), "removeUserRole", projectRole.getId(), "\u9879\u76ee\u89d2\u8272[" + projectRole.getName() + "]\u5220\u9664\u6210\u5458:" + string);
        ProjectRoleService.ins.removeUserRole(string, l);
    }

    public void users(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = ContextHolder.getProjectId();
        String string = httpServletRequest.getParameter("roleId");
        String string2 = httpServletRequest.getParameter("keyword");
        int n = Integer.parseInt(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.parseInt(httpServletRequest.getParameter("pageSize"));
        UserQuery userQuery = ProjectManager.ins.createUserQuery();
        userQuery.idnameLike(string2);
        if (StringUtils.isBlank(string) || "-1".equals(string)) {
            Page<User> page = userQuery.users(n, n2, l);
            this.a(l, page);
            this.a(httpServletResponse, page);
        } else {
            Page<User> page = userQuery.roleUsers(n, n2, l, Long.parseLong(string));
            this.a(l, page);
            this.a(httpServletResponse, page);
        }
    }

    private void a(long l, Page<User> page) throws Exception {
        ArrayList<GroupUserVO> arrayList = new ArrayList<GroupUserVO>();
        List<?> list = page.getData();
        for (User user : list) {
            GroupUserVO groupUserVO = new GroupUserVO();
            groupUserVO.setId(user.getId());
            groupUserVO.setName(user.getName());
            groupUserVO.setCreateDate(user.getCreateDate());
            groupUserVO.setRoles(ProjectRoleManager.ins.loadUserRoles(l, user.getId()));
            arrayList.add(groupUserVO);
        }
        page.setData(arrayList);
    }

    public void userRoles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("account");
        List<ProjectRoleVO> list = ProjectRoleService.ins.loadUserRoles(ContextHolder.getProjectId(), string);
        this.a(httpServletResponse, list);
    }

    @URuleAuthorization(authType="project", model="members", code="add")
    public void addUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        if (StringUtils.isNotBlank(string)) {
            for (String string2 : string.split(",")) {
                if (!StringUtils.isNotBlank(string2)) continue;
                ProjectService.ins.addProjectuser(ContextHolder.getProjectId(), string2);
                User user = UserServiceManager.getUserService().get(string2);
                SystemLogUtils.addProjectOperationLog(ProjectModule.members.name(), "add", user.getId(), "\u6dfb\u52a0\u6210\u5458:" + string2);
            }
        }
    }

    @URuleAuthorization(authType="project", model="members", code="remove")
    public void removeUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("userId");
        if (StringUtils.isNotBlank(string)) {
            User user = UserServiceManager.getUserService().get(string);
            ProjectManager.ins.removeProjectUser(ContextHolder.getProjectId(), string);
            SystemLogUtils.addProjectOperationLog(ProjectModule.members.name(), "remove", user.getId(), "\u5220\u9664\u6210\u5458:" + string);
        }
    }

    @URuleAuthorization(authType="project", model="permissions", code="manager")
    public void addRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("roleName");
        if (ContextHolder.getProjectId() == null) {
            throw new ParameterInvaidException();
        }
        ProjectRole projectRole = new ProjectRole();
        projectRole.setName(string);
        projectRole.setProjectId(ContextHolder.getProjectId());
        projectRole.setType("custom");
        projectRole.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        ProjectRoleService.ins.add(projectRole);
        this.a(httpServletResponse, projectRole);
        SystemLogUtils.addProjectOperationLog(ProjectModule.permissions.name(), "manager", projectRole.getId(), "\u6dfb\u52a0\u89d2\u8272[" + string + "]");
    }

    @URuleAuthorization(authType="project", model="permissions", code="manager")
    public void renameRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        String string = httpServletRequest.getParameter("roleName");
        ProjectRole projectRole = ProjectRoleManager.ins.get(l);
        if (ContextHolder.getProjectId().longValue() != projectRole.getProjectId()) {
            throw new ParameterInvaidException();
        }
        String string2 = projectRole.getName();
        projectRole.setName(string);
        projectRole.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        ProjectRoleService.ins.update(projectRole);
        SystemLogUtils.addProjectOperationLog(ProjectModule.permissions.name(), "manager", projectRole.getId(), "\u4fee\u6539\u89d2\u8272[" + string + "]\u7684\u540d\u79f0\u4e3a[" + string2 + "]");
    }

    @URuleAuthorization(authType="project", model="permissions", code="manager")
    public void removeRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("roleId"));
        ProjectRole projectRole = ProjectRoleManager.ins.get(l);
        if (ContextHolder.getProjectId().longValue() != projectRole.getProjectId()) {
            throw new ParameterInvaidException();
        }
        ProjectRoleService.ins.remove(l);
        SystemLogUtils.addProjectOperationLog(ProjectModule.permissions.name(), "manager", projectRole.getId(), "\u5220\u9664\u89d2\u8272[" + projectRole.getName() + "]");
    }

    @Transactional
    @URuleAuthorization(authType="project", model="setting", code="approveUser")
    public void updateApproveUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = ContextHolder.getProjectId();
        String string = httpServletRequest.getParameter("disableApproveUser");
        String string2 = httpServletRequest.getParameter("enableApproveUser");
        String string3 = httpServletRequest.getParameter("deployApproveUser");
        if (StringUtils.isNotEmpty(string)) {
            ProjectManager.ins.updateApproveUser(l, ApplyType.enable, string2);
            SystemLogUtils.addProjectOperationLog(ProjectModule.setting.name(), "approveUser", string2, "\u8bbe\u7f6e\u89c4\u5219\u542f\u7528\u5ba1\u6279\u4eba[" + string2 + "]");
        }
        if (StringUtils.isNotEmpty(string)) {
            ProjectManager.ins.updateApproveUser(l, ApplyType.disable, string);
            SystemLogUtils.addProjectOperationLog(ProjectModule.setting.name(), "approveUser", string, "\u8bbe\u7f6e\u89c4\u5219\u7981\u7528\u5ba1\u6279\u4eba[" + string + "]");
        }
        if (StringUtils.isNotEmpty(string3)) {
            ProjectManager.ins.updateApproveUser(l, ApplyType.deploy, string3);
            SystemLogUtils.addProjectOperationLog(ProjectModule.setting.name(), "approveUser", string3, "\u8bbe\u7f6e\u89c4\u5219\u53d1\u5e03\u5ba1\u6279\u4eba[" + string3 + "]");
        }
    }

    public void countRule(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Integer n = FileManager.ins.newCountQuery().projectId(ContextHolder.getProjectId()).getRuleCount();
        Integer n2 = PacketManager.ins.getCount(ContextHolder.getProjectId());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("ruleCount", n);
        hashMap.put("packetCount", n2);
        this.a(httpServletResponse, hashMap);
    }

    public void countUserCommits(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -14);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        List<UserCommitVO> list = ProjectService.ins.getUserCommits(l, date, date2);
        this.a(httpServletResponse, list);
    }

    public void countRuleCommits(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        List<RuleCommitVO> list = ProjectService.ins.getRuleCommits(l, date, date2);
        this.a(httpServletResponse, list);
    }

    public void countRuleExecCount(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        List<RuleExecVO> list = ProjectService.ins.getRuleExecCount(l, date, date2);
        this.a(httpServletResponse, list);
    }

    public void countRuleExecTime(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        List<RuleExecVO> list = ProjectService.ins.getRuleExecTime(l, date, date2);
        this.a(httpServletResponse, list);
    }

    public void countRuleDeploys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        PacketApplyQuery packetApplyQuery = PacketApplyManager.ins.newQuery();
        List<PacketApply> list = packetApplyQuery.projectId(l).startDate(date).endDate(date2).type(ApplyType.deploy).status(ApplyStatus.pass).list();
        HashMap<Date, RuleDeployVO> hashMap = new HashMap<Date, RuleDeployVO>();
        for (PacketApply packetApply : list) {
            RuleDeployVO ruleDeployVO = new RuleDeployVO();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(packetApply.getCreateDate());
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
            if (!hashMap.containsKey(calendar2.getTime())) {
                hashMap.put(calendar2.getTime(), ruleDeployVO);
            } else {
                ruleDeployVO = (RuleDeployVO)hashMap.get(calendar2.getTime());
            }
            ruleDeployVO.setCreateDate(calendar2.getTime());
            ruleDeployVO.setCount(ruleDeployVO.getCount() + 1);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, new Comparator<RuleDeployVO>(){

            @Override
            public int compare(RuleDeployVO ruleDeployVO, RuleDeployVO ruleDeployVO2) {
                return (int)(ruleDeployVO.getCreateDate().getTime() - ruleDeployVO2.getCreateDate().getTime());
            }
        });
        this.a(httpServletResponse, arrayList);
    }

    public void listPacketDeploys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = ContextHolder.getGroupId();
        List<PacketDeployVO> list = ReportGroupQuery.listPacketDeploys(string);
        if (list.size() > 5) {
            this.a(httpServletResponse, list.subList(0, 5));
        } else {
            this.a(httpServletResponse, list);
        }
    }

    public void countUserRuleFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        List<LinkedHashMap<String, Object>> list = ReportProjectQuery.countUserRuleFiles(l);
        this.a(httpServletResponse, list);
    }

    public void countUserLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.add(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        List<LinkedHashMap<String, Object>> list = ReportProjectQuery.countUserLogin(l, date, date2);
        this.a(httpServletResponse, list);
    }

    public void listRecentFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        List<RuleFile> list = ReportProjectQuery.listLastModifyFiles(l);
        if (list.size() > 5) {
            this.a(httpServletResponse, list.subList(0, 5));
        } else {
            this.a(httpServletResponse, list);
        }
    }

    public void getSummary(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ContextHolder.getProjectId();
        int n = ReportProjectQuery.countPacket(l);
        int n2 = ReportProjectQuery.countFile(l);
        int n3 = ReportProjectQuery.countBatch(l);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("packetCount", n);
        hashMap.put("fileCount", n2);
        hashMap.put("batchCount", n3);
        this.a(httpServletResponse, hashMap);
    }

    @Override
    public String url() {
        return "/project";
    }
}

