/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.project.in;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.admin.project.in.ConfigInfo;
import com.bstek.urule.console.admin.project.in.DuplicatePacketCodeException;
import com.bstek.urule.console.database.manager.file.DirectoryManager;
import com.bstek.urule.console.database.manager.file.DirectoryManagerImpl;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.file.version.VersionFileManager;
import com.bstek.urule.console.database.manager.file.version.VersionFileManagerImpl;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.file.PacketFileManager;
import com.bstek.urule.console.database.manager.project.ProjectManager;
import com.bstek.urule.console.database.model.FileInfo;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.model.PacketType;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.model.VersionFile;
import com.bstek.urule.console.database.service.project.ProjectService;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.entity.User;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.console.xml.DocumentHelper;
import com.bstek.urule.exception.RuleException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;

public class ProjectImport {
    private static final Log a = LogFactory.getLog(ProjectImport.class);
    private Map<String, String> b = new HashMap<String, String>();
    private Map<Long, RuleFile> c = new HashMap<Long, RuleFile>();
    private Map<String, RuleFile> d = new HashMap<String, RuleFile>();
    private List<VersionFile> e = new ArrayList<VersionFile>();
    private Map<String, String> f = new HashMap<String, String>();
    private Map<String, String> g = new HashMap<String, String>();
    private Map<String, Long> h = new HashMap<String, Long>();

    public void doImport(InputStream inputStream, Group group, ConfigInfo configInfo) throws Exception {
        Object object;
        Object object2;
        Iterator<FileInfo> iterator;
        this.b(group.getId());
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        String string = Utils.uncompress((byte[])byArray);
        Document document = DocumentHelper.parseText(string);
        Element element = document.getRootElement();
        if (!element.getName().contentEquals("project")) {
            throw new InfoException("\u6587\u4ef6\u4e0d\u5408\u6cd5\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2aURule Pro4+\u9879\u76ee\u5bfc\u51fa\u7684\u5907\u4efd\u6587\u4ef6");
        }
        Long l = Long.parseLong(element.attributeValue("id"));
        String string2 = element.attributeValue("name");
        String string3 = element.attributeValue("type");
        if (StringUtils.isBlank(string2) || StringUtils.isBlank(string3)) {
            throw new InfoException("\u6587\u4ef6\u4e0d\u5408\u6cd5\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2aURule Pro4+\u9879\u76ee\u5bfc\u51fa\u7684\u5907\u4efd\u6587\u4ef6");
        }
        Project project = null;
        boolean bl = false;
        User user = SecurityUtils.getLoginUser(RequestHolder.getRequest());
        List<Project> list = ProjectManager.ins.newQuery().groupId(group.getId()).name(string2).list();
        if (configInfo.isReplace() && list.size() > 0) {
            project = list.get(0);
            bl = true;
            project.setType(string3);
            project.setUpdateUser(user.getName());
            project.setUpdateDate(new Date());
            iterator = this.a(element, "desc");
            project.setDesc((String)((Object)iterator));
            ProjectManager.ins.update(project);
            a.debug((Object)("processProject(replace):" + project.getName()));
            List<RuleFile> object32 = FileManager.ins.newQuery().list(project.getId());
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (((RuleFile)object).isDeleted()) continue;
                this.d.put(((FileInfo)object).getPath(), (RuleFile)object);
            }
        } else {
            project = new Project();
            string2 = this.a(group.getId(), string2);
            project.setName(string2);
            project.setType(string3);
            project.setCreateUser(user.getName());
            project.setId(0L);
            project.setGroupId(group.getId());
            project.setDeployApproveUser(user.getName());
            project.setDisableApproveUser(user.getName());
            project.setEnableApproveUser(user.getName());
            project.setUpdateUser(user.getName());
            iterator = this.a(element, "desc");
            project.setDesc((String)((Object)iterator));
            ProjectService.ins.add(project);
            a.debug((Object)("processProject(add):" + project.getName()));
        }
        if (l != project.getId()) {
            iterator = "project=\"" + l + "\"";
            String string4 = "project=\"" + project.getId() + "\"";
            this.b.put((String)((Object)iterator), string4);
        }
        for (Object e : element.elements()) {
            if (e instanceof Element && !this.b((Element)(object2 = (Element)e), project, bl, configInfo.isForceLock()) && !this.a((Element)object2, project, bl, configInfo.isNewPacketCode())) continue;
        }
        for (RuleFile ruleFile : this.c.values()) {
            String string5;
            object2 = ruleFile.getType();
            if (((String)object2).contentEquals(ResourceType.ActionLibrary.name()) || ((String)object2).contentEquals(ResourceType.ConstantLibrary.name()) || ((String)object2).contentEquals(ResourceType.ParameterLibrary.name()) || ((String)object2).contentEquals(ResourceType.VariableLibrary.name())) continue;
            object = ruleFile.getContent();
            for (String string6 : this.b.keySet()) {
                string5 = this.b.get(string6);
                if (string6.startsWith("file=")) {
                    if (!((String)object2).contentEquals(ResourceType.Flow.name())) continue;
                    object = ((String)object).replace(string6, string5);
                    continue;
                }
                object = ((String)object).replace(string6, string5);
            }
            for (String string6 : this.g.keySet()) {
                string5 = this.g.get(string6);
                object = this.a(string6, (String)object, string5);
            }
            for (String string6 : this.f.keySet()) {
                string5 = this.f.get(string6);
                object = this.a(string6, (String)object, string5);
            }
            FileManager.ins.updateContent(ruleFile.getId(), ruleFile.getCreateUser(), (String)object);
        }
        for (VersionFile versionFile : this.e) {
            object2 = versionFile.getContent();
            for (String string7 : this.b.keySet()) {
                String string6;
                string6 = this.b.get(string7);
                object2 = ((String)object2).replace(string7, string6);
            }
            object = (VersionFileManagerImpl)VersionFileManager.ins;
            ((VersionFileManagerImpl)object).updateContent(versionFile.getId(), (String)object2);
        }
    }

    private String a(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, string3);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String a(String string, String string2) {
        List<Project> list = ProjectManager.ins.newQuery().groupId(string).list();
        for (int i = 0; i < 10000; ++i) {
            String string3 = string2;
            if (i > 0) {
                string3 = string3 + i;
            }
            boolean bl = false;
            for (Project project : list) {
                if (!project.getName().contentEquals(string3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private void a(String string) {
        try {
            List<Packet> list = PacketManager.ins.newQuery().code(string).list();
            if (list.size() > 0) {
                Packet packet = list.get(0);
                long l = packet.getProjectId();
                Project project = ProjectManager.ins.get(l);
                String string2 = project.getGroupId();
                String string3 = "Duplicate packet code " + string + "!<br/>The code under " + project.getName() + "(" + l + ") of " + string2 + " repeated";
                throw new DuplicatePacketCodeException(string3);
            }
        }
        catch (Exception exception) {
            if (exception instanceof DuplicatePacketCodeException) {
                throw exception;
            }
            throw new DuplicatePacketCodeException("Duplicate packet code " + string + "!<br/>" + exception.getMessage());
        }
    }

    private boolean a(Element element, Project project, boolean bl, boolean bl2) {
        List<Packet> list;
        if (!element.getName().contentEquals("packet")) {
            return false;
        }
        long l = Long.valueOf(element.attributeValue("id"));
        String string = element.attributeValue("code");
        String string2 = element.attributeValue("name");
        boolean bl3 = false;
        Packet packet = new Packet();
        if (StringUtils.isNotBlank(string)) {
            if (bl && (list = PacketManager.ins.newQuery().code(string).list()).size() > 0) {
                packet = list.get(0);
                PacketFileManager.ins.deleteByPacketId(packet.getId());
                bl3 = true;
            }
            if (!bl3) {
                try {
                    this.a(string);
                }
                catch (DuplicatePacketCodeException duplicatePacketCodeException) {
                    if (bl2) {
                        string = "";
                    }
                    throw duplicatePacketCodeException;
                }
            }
        } else if (bl && (list = PacketManager.ins.newQuery().name(string2).list()).size() > 0) {
            packet = list.get(0);
            PacketFileManager.ins.deleteByPacketId(packet.getId());
            bl3 = true;
        }
        list = element.attributeValue("type");
        PacketType packetType = PacketType.file;
        if (list != null) {
            packetType = PacketType.valueOf(list);
        }
        packet.setType(packetType);
        packet.setName(string2);
        packet.setCode(string);
        packet.setDesc(element.attributeValue("desc"));
        packet.setProjectId(project.getId());
        packet.setCreateUser(project.getCreateUser());
        packet.setEnable(Boolean.valueOf(element.attributeValue("enable")));
        packet.setAuditEnable(Boolean.valueOf(element.attributeValue("audit-enable")));
        packet.setRestEnable(Boolean.valueOf(element.attributeValue("rest-enable")));
        packet.setRestSecurityEnable(Boolean.valueOf(element.attributeValue("rest-security-enable")));
        if (packet.isRestSecurityEnable()) {
            packet.setRestSecurityUser(element.attributeValue("rest-security-user"));
            packet.setRestSecurityPassword(element.attributeValue("rest-security-password"));
        }
        String string3 = this.a(element, "audit-input");
        String string4 = this.a(element, "audit-output");
        String string5 = this.a(element, "rest-input");
        String string6 = this.a(element, "rest-output");
        String string7 = this.a(element, "input-data");
        String string8 = this.a(element, "output-data");
        packet.setAuditInput(string3);
        packet.setAuditOutput(string4);
        packet.setRestInput(string5);
        packet.setRestOutput(string6);
        packet.setInputData(string7);
        packet.setOutputData(string8);
        if (bl3) {
            PacketManager.ins.update(packet);
            a.debug((Object)("processPacket(replace):" + packet.getName()));
        } else {
            PacketManager.ins.add(packet);
            a.debug((Object)("processPacket(add):" + packet.getName()));
        }
        if (l != packet.getId()) {
            String string9 = "package-id=\"" + l + "\"";
            Object object = "package-id=\"" + packet.getId() + "\"";
            this.b.put(string9, (String)object);
        }
        for (Object object : element.elements()) {
            Element element2;
            if (!(object instanceof Element) || !(element2 = (Element)object).getName().contentEquals("file")) continue;
            this.a(element2, packet);
        }
        return true;
    }

    private void a(Element element, Packet packet) {
        PacketFile packetFile = new PacketFile();
        long l = Long.valueOf(element.attributeValue("id"));
        String string = element.attributeValue("path");
        RuleFile ruleFile = this.c.get(l);
        if (ruleFile != null) {
            packetFile.setFileId(ruleFile.getId());
        } else if (this.h.containsKey(string)) {
            packetFile.setFileId(this.h.get(string));
        } else {
            packetFile.setFileId(0L);
        }
        packetFile.setProjectId(packet.getProjectId());
        packetFile.setCreateUser(packet.getCreateUser());
        packetFile.setDesc(element.attributeValue("desc"));
        packetFile.setPath(string);
        packetFile.setPacketId(packet.getId());
        packetFile.setVersion(element.attributeValue("version"));
        a.debug((Object)("processPacketFile:" + packetFile.getFileId()));
        PacketFileManager.ins.add(packetFile);
    }

    private boolean b(Element element, Project project, boolean bl, boolean bl2) {
        String string;
        if (!element.getName().contentEquals("file")) {
            return false;
        }
        String string2 = element.attributeValue("path");
        long l = Long.valueOf(element.attributeValue("id"));
        RuleFile ruleFile = new RuleFile();
        RuleFile ruleFile2 = this.d.get(string2);
        boolean bl3 = false;
        if (ruleFile2 != null && bl) {
            ruleFile = ruleFile2;
            bl3 = true;
        }
        if (StringUtils.isNotBlank(string = element.attributeValue("deleted"))) {
            ruleFile.setDeleted(Boolean.valueOf(string));
        }
        if (ruleFile.isDeleted()) {
            return false;
        }
        ruleFile.setName(element.attributeValue("name"));
        ruleFile.setDigest(element.attributeValue("digest"));
        ruleFile.setPath(element.attributeValue("path"));
        ruleFile.setLatestVersion(element.attributeValue("latest-version"));
        ruleFile.setCreateUser(project.getCreateUser());
        ruleFile.setProjectId(project.getId());
        ruleFile.setType(element.attributeValue("type"));
        String string3 = this.a(element, "content");
        String string4 = ruleFile.getType();
        if (string4.contentEquals(ResourceType.ActionLibrary.name()) || string4.contentEquals(ResourceType.ConstantLibrary.name()) || string4.contentEquals(ResourceType.ParameterLibrary.name()) || string4.contentEquals(ResourceType.VariableLibrary.name())) {
            string4 = ResourceType.Library.name();
        } else if (string4.contentEquals(ResourceType.Scorecard.name()) || string4.contentEquals(ResourceType.ComplexScorecard.name())) {
            string4 = ResourceType.Scorecard.name();
        } else if (string4.contentEquals(ResourceType.DecisionTable.name()) || string4.contentEquals(ResourceType.CrossDecisionTable.name())) {
            string4 = ResourceType.DecisionTable.name();
        }
        ruleFile.setContent(string3);
        RuleFile ruleFile3 = this.a(ruleFile.getPath(), project, string4);
        if (ruleFile3 != null) {
            ruleFile.setParentId(ruleFile3.getId());
        }
        if (bl3) {
            VersionFileManager.ins.deleteByFileId(ruleFile.getId());
            ruleFile.setModifyDate(new Date());
            ruleFile.setUpdateUser(project.getCreateUser());
            FileManager.ins.update(ruleFile);
            a.debug((Object)("processFile(replace):" + ruleFile.getName()));
        } else {
            FileManager.ins.add(ruleFile);
            a.debug((Object)("processFile(add):" + ruleFile.getName()));
        }
        if (l != ruleFile.getId()) {
            Object object = "id=\"" + l + "\"";
            Object object2 = "id=\"" + ruleFile.getId() + "\"";
            this.b.put((String)object, (String)object2);
            object = "file=\"" + l + "\"";
            object2 = "file=\"" + ruleFile.getId() + "\"";
            this.b.put((String)object, (String)object2);
        }
        if (bl2) {
            FileManager.ins.lock(ruleFile.getId(), ruleFile.getCreateUser());
        }
        this.c.put(l, ruleFile);
        for (Object object2 : element.elements()) {
            Element element2;
            if (!(object2 instanceof Element) || !(element2 = (Element)object2).getName().contentEquals("version")) continue;
            this.a(element2, ruleFile);
        }
        return true;
    }

    private void b(String string) {
        List<Project> list = ProjectManager.ins.newQuery().type("common").groupId(string).list();
        for (Project project : list) {
            Object object;
            Object object2;
            List<Packet> list2 = PacketManager.ins.newQuery().projectId(project.getId()).list();
            for (Packet packet : list2) {
                object2 = "knowledge project=\"" + project.getName() + "\" name=\"" + packet.getName() + "\" package-id=\"[0-9]+\"";
                object = "knowledge project=\"" + project.getName() + "\" name=\"" + packet.getName() + "\" package-id=\"" + packet.getId() + "\"";
                this.f.put((String)object2, (String)object);
            }
            List<RuleFile> list3 = FileManager.ins.newQuery().containCommonProject(false).tree(project.getId());
            String object32 = "";
            object2 = list3.iterator();
            while (object2.hasNext()) {
                object = (RuleFile)object2.next();
                this.a(object32, (RuleFile)object);
            }
        }
    }

    private void a(String string, RuleFile ruleFile) {
        string = StringUtils.isBlank(string) ? "/" + ruleFile.getName() : string + "/" + ruleFile.getName();
        if (ruleFile.isDirectory()) {
            if (ruleFile.getChildren() == null) {
                return;
            }
            for (RuleFile ruleFile2 : ruleFile.getChildren()) {
                this.a(string, ruleFile2);
            }
        } else {
            String string2 = ruleFile.getType();
            if (string2 == null) {
                return;
            }
            if (string2.contentEquals(ResourceType.ActionLibrary.name()) || string2.contentEquals(ResourceType.ConstantLibrary.name()) || string2.contentEquals(ResourceType.ParameterLibrary.name()) || string2.contentEquals(ResourceType.VariableLibrary.name()) || string2.contentEquals(ResourceType.ActionTemplate.name()) || string2.contentEquals(ResourceType.ConditionTemplate.name())) {
                String string3 = "path=\"" + string2 + ":" + string + "\"";
                String string4 = "id=\"[0-9]+\" " + string3 + "";
                String string5 = "id=\"" + ruleFile.getId() + "\" " + string3 + "";
                this.g.put(string4, string5);
                String string6 = string;
                if (string6.startsWith("/")) {
                    string6 = string6.substring(1, string6.length());
                }
                String string7 = "path=\"" + string2 + ":" + string6 + "\"";
                string4 = "id=\"[0-9]+\" " + string7 + "";
                this.g.put(string4, string5);
            } else {
                String string8 = "path=\"" + string2 + ":" + string + "\" version=\"([0-9]+(\\.[0-9]+)*)?\" id=\"[0-9]+\"";
                String string9 = "path=\"" + string2 + ":" + string + "\" version=\"\" id=\"" + ruleFile.getId() + "\"";
                this.g.put(string8, string9);
                String string10 = string;
                if (string10.startsWith("/")) {
                    string10 = string10.substring(1, string10.length());
                }
                string8 = "path=\"" + string2 + ":" + string10 + "\" version=\"([0-9]+(\\.[0-9]+)*)?\" id=\"[0-9]+\"";
                this.g.put(string8, string9);
                String string11 = "id=\"[0-9]+\" path=\"" + string2 + ":" + string + "\"/";
                String string12 = "id=\"" + ruleFile.getId() + "\" path=\"" + string2 + ":" + string + "\"/";
                this.g.put(string11, string12);
                String string13 = "id=\"[0-9]+\" path=\"" + string2 + ":" + string10 + "\"/";
                this.g.put(string13, string12);
                String string14 = string2 + ":" + string;
                String string15 = string2 + ":" + string10;
                this.h.put(string14, ruleFile.getId());
                this.h.put(string15, ruleFile.getId());
            }
        }
    }

    private void a(Element element, RuleFile ruleFile) {
        VersionFile versionFile = new VersionFile();
        versionFile.setProjectId(ruleFile.getProjectId());
        versionFile.setFileId(ruleFile.getId());
        versionFile.setName(ruleFile.getName());
        versionFile.setDigest(element.attributeValue("digest"));
        versionFile.setVersion(element.attributeValue("version"));
        versionFile.setCreateUser(ruleFile.getCreateUser());
        String string = this.a(element, "content");
        versionFile.setContent(string);
        String string2 = this.a(element, "note");
        versionFile.setNote(string2);
        VersionFileManager.ins.saveFile(versionFile);
        this.e.add(versionFile);
    }

    protected RuleFile a(String string, Project project, String string2) {
        int n;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(":")) > -1) {
            string = string.substring(n + 1);
        }
        int n2 = string.indexOf("/");
        if ((n2 = (string = string.substring(n2 + 1)).lastIndexOf("/")) == -1) {
            return null;
        }
        String string3 = string.substring(0, n2);
        String[] stringArray = string3.split("/");
        long l = 0L;
        RuleFile ruleFile = null;
        for (String string4 : stringArray) {
            DirectoryManagerImpl directoryManagerImpl = (DirectoryManagerImpl)DirectoryManager.ins;
            ruleFile = directoryManagerImpl.loadDir(project.getId(), l, string4, string2);
            if (ruleFile == null) {
                ruleFile = new RuleFile();
                ruleFile.setProjectId(project.getId());
                ruleFile.setParentId(l);
                ruleFile.setName(string4);
                ruleFile.setType(string2);
                ruleFile.setCreateUser(project.getCreateUser());
                directoryManagerImpl.add(ruleFile);
            }
            l = ruleFile.getId();
        }
        return ruleFile;
    }

    private String a(Element element, String string) {
        String string2 = null;
        for (Object e : element.elements()) {
            Element element2;
            if (!(e instanceof Element) || !(element2 = (Element)e).getName().contentEquals(string)) continue;
            string2 = element2.getText();
            break;
        }
        if (StringUtils.isNotBlank(string2)) {
            try {
                string2 = IOUtils.toString((byte[])Base64.getDecoder().decode(string2), (String)"utf-8");
            }
            catch (IOException iOException) {
                throw new RuleException((Exception)iOException);
            }
        }
        return string2;
    }
}

