/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.project.out;

import com.bstek.urule.Utils;
import com.bstek.urule.console.database.manager.file.FileManager;
import com.bstek.urule.console.database.manager.file.FileQuery;
import com.bstek.urule.console.database.manager.file.version.VersionFileManager;
import com.bstek.urule.console.database.manager.packet.PacketManager;
import com.bstek.urule.console.database.manager.packet.PacketQuery;
import com.bstek.urule.console.database.model.Packet;
import com.bstek.urule.console.database.model.PacketFile;
import com.bstek.urule.console.database.model.Project;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.model.VersionFile;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultCDATA;

public class ProjectExport {
    private static final Log a = LogFactory.getLog(ProjectExport.class);
    public static final ProjectExport ins = new ProjectExport();

    private ProjectExport() {
    }

    public void doExport(OutputStream outputStream, Project project) throws Exception {
        Document document = this.a(project);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, new OutputFormat());
        xMLWriter.write(document);
        String string = stringWriter.toString();
        byte[] byArray = Utils.compress((String)string);
        IOUtils.write((byte[])byArray, (OutputStream)outputStream);
    }

    private Document a(Project project) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("project");
        element.addAttribute("name", project.getName());
        element.addAttribute("id", String.valueOf(project.getId()));
        element.addAttribute("type", project.getType());
        this.a(element, project.getDesc(), "desc");
        this.b(project, element);
        this.a(project, element);
        return document;
    }

    private void a(Project project, Element element) {
        PacketQuery packetQuery = PacketManager.ins.newQuery();
        List<Packet> list = packetQuery.projectId(project.getId()).list();
        for (Packet packet : list) {
            Element element2 = element.addElement("packet");
            element2.addAttribute("name", packet.getName());
            element2.addAttribute("code", packet.getCode());
            element2.addAttribute("desc", packet.getDesc());
            element2.addAttribute("id", String.valueOf(packet.getId()));
            if (packet.getType() != null) {
                element2.addAttribute("type", packet.getType().name());
            }
            element2.addAttribute("enable", String.valueOf(packet.isEnable()));
            element2.addAttribute("audit-enable", String.valueOf(packet.isAuditEnable()));
            element2.addAttribute("rest-enable", String.valueOf(packet.isRestEnable()));
            element2.addAttribute("rest-security-enable", String.valueOf(packet.isRestSecurityEnable()));
            if (packet.isRestSecurityEnable()) {
                element2.addAttribute("rest-security-user", packet.getRestSecurityUser());
                element2.addAttribute("rest-security-password", packet.getRestSecurityPassword());
            }
            this.a(element2, packet.getAuditInput(), "audit-input");
            this.a(element2, packet.getAuditOutput(), "audit-output");
            this.a(element2, packet.getRestInput(), "rest-input");
            this.a(element2, packet.getRestOutput(), "rest-output");
            this.a(element2, packet.getInputData(), "input-data");
            this.a(element2, packet.getOutputData(), "output-data");
            a.debug((Object)("buildPacket:" + packet.getName()));
            this.a(packet.getFiles(), element2);
        }
    }

    private void a(List<PacketFile> list, Element element) {
        for (PacketFile packetFile : list) {
            a.debug((Object)("buildPacketFile:" + packetFile.getFileId()));
            Element element2 = element.addElement("file");
            element2.addAttribute("id", String.valueOf(packetFile.getFileId()));
            element2.addAttribute("desc", packetFile.getDesc());
            element2.addAttribute("path", packetFile.getPath());
            element2.addAttribute("version", packetFile.getVersion());
        }
    }

    private void b(Project project, Element element) {
        FileQuery fileQuery = FileManager.ins.newQuery();
        List<RuleFile> list = fileQuery.list(project.getId());
        for (RuleFile ruleFile : list) {
            if (ruleFile.isDeleted()) continue;
            a.debug((Object)("buildFile:" + ruleFile.getName()));
            Element element2 = element.addElement("file");
            element2.addAttribute("name", ruleFile.getName());
            element2.addAttribute("deleted", String.valueOf(ruleFile.isDeleted()));
            element2.addAttribute("id", String.valueOf(ruleFile.getId()));
            element2.addAttribute("path", ruleFile.getPath());
            element2.addAttribute("digest", ruleFile.getDigest());
            element2.addAttribute("type", ruleFile.getType());
            element2.addAttribute("latest-version", ruleFile.getLatestVersion());
            String string = FileManager.ins.loadContent(ruleFile.getId());
            this.a(element2, string, "content");
            this.a(ruleFile, element2);
        }
    }

    private void a(RuleFile ruleFile, Element element) {
        List<VersionFile> list = VersionFileManager.ins.loadFiles(ruleFile.getId());
        for (VersionFile versionFile : list) {
            Element element2 = element.addElement("version");
            element2.addAttribute("version", versionFile.getVersion());
            element2.addAttribute("digest", versionFile.getDigest());
            this.a(element2, versionFile.getNote(), "note");
            element2.addAttribute("id", String.valueOf(versionFile.getId()));
            String string = VersionFileManager.ins.loadFileContent(versionFile.getId());
            this.a(element2, string, "content");
        }
    }

    private void a(Element element, String string, String string2) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        try {
            string = Base64.getEncoder().encodeToString(string.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuleException((Exception)unsupportedEncodingException);
        }
        Element element2 = element.addElement(string2);
        element2.add((CDATA)new DefaultCDATA(string));
    }
}

