/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.repository;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.config.dialect.Dialect;
import com.bstek.urule.console.config.dialect.DialectResolver;
import com.bstek.urule.console.config.dialect.OrderLimitDialect;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.IDType;
import com.bstek.urule.console.database.manager.repository.DataSourceManager;
import com.bstek.urule.console.database.manager.repository.DataSourceQuery;
import com.bstek.urule.console.database.model.Page;
import com.bstek.urule.console.database.model.datasource.DataSource;
import com.bstek.urule.console.database.model.datasource.Field;
import com.bstek.urule.console.database.model.datasource.FieldType;
import com.bstek.urule.console.database.service.repository.DataSourceHandlerManager;
import com.bstek.urule.console.database.service.repository.DataSourceService;
import com.bstek.urule.console.database.util.JdbcUtils;
import com.bstek.urule.console.database.util.NamedSQLUtils;
import com.bstek.urule.console.database.util.ParsedSql;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthorization;
import com.bstek.urule.exception.RuleException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class DataSourceServletHandler
extends ApiServletHandler {
    @Transactional
    @URuleAuthorization(authType="group", code="manager", model="datasource")
    public void add(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("data");
        DataSource dataSource = (DataSource)this.a().readValue(string, DataSource.class);
        dataSource.setId(IDGenerator.getInstance().nextId(IDType.DATASOURCE));
        dataSource.setGroupId(ContextHolder.getGroupId());
        dataSource.setCreateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        dataSource.setCreateDate(new Date());
        DataSourceService.ins.add(dataSource);
    }

    @Transactional
    @URuleAuthorization(authType="group", code="manager", model="datasource")
    public void update(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("data");
        DataSource dataSource = (DataSource)this.a().readValue(string, DataSource.class);
        dataSource.setUpdateUser(SecurityUtils.getLoginUsername(httpServletRequest));
        dataSource.setUpdateDate(new Date());
        DataSourceService.ins.update(dataSource);
    }

    @Transactional
    @URuleAuthorization(authType="group", code="manager", model="datasource")
    public void delete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        DataSourceService.ins.remove(l);
    }

    public void page(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        String string2;
        String string3;
        String string4 = ContextHolder.getGroupId();
        int n = Integer.parseInt(httpServletRequest.getParameter("pageIndex"));
        int n2 = Integer.parseInt(httpServletRequest.getParameter("pageSize"));
        Page<DataSource> page = new Page<DataSource>(n, n2);
        DataSourceQuery dataSourceQuery = DataSourceManager.ins.createQuery();
        String string5 = httpServletRequest.getParameter("id");
        if (StringUtils.isNotBlank((String)string5)) {
            dataSourceQuery.id(Long.parseLong(string5));
        }
        if (StringUtils.isNotBlank((String)(string3 = httpServletRequest.getParameter("name")))) {
            dataSourceQuery.nameLike(string3);
        }
        if (StringUtils.isNotBlank((String)(string2 = httpServletRequest.getParameter("type")))) {
            dataSourceQuery.type(string2);
        }
        if (StringUtils.isNotBlank((String)(string = httpServletRequest.getParameter("createUser")))) {
            dataSourceQuery.createUserLike(string);
        }
        dataSourceQuery.groupId(string4).page(page);
        this.a(httpServletResponse, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @URuleAuthorization(authType="group", code="manager", model="datasource")
    public void buildFields(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("id"));
        String string = httpServletRequest.getParameter("tableName");
        String string2 = "select * from " + string;
        DataSource dataSource = DataSourceManager.ins.get(l);
        javax.sql.DataSource dataSource2 = DataSourceHandlerManager.getDataSource(dataSource);
        Connection connection = dataSource2.getConnection();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        try {
            Dialect dialect = DialectResolver.resolveDialect(connection);
            String string3 = dialect.getLimitString(string2, 0, 1);
            if (dialect instanceof OrderLimitDialect) {
                string3 = string2 + " limit 1";
            }
            ParsedSql parsedSql = NamedSQLUtils.parseSql(string3);
            String string4 = JdbcUtils.getOriginSql(parsedSql.getOriginalSql());
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string5 = resultSetMetaData.getColumnLabel(i + 1);
                if (StringUtils.isBlank((String)string5)) {
                    string5 = resultSetMetaData.getColumnName(i + 1);
                }
                if ((n2 = string5.lastIndexOf(".")) > -1) {
                    string5 = string5.substring(n2 + 1);
                }
                int n3 = resultSetMetaData.getColumnType(i + 1);
                FieldType fieldType = JdbcUtils.buildJdbcFieldType(n3);
                arrayList.add(new Field(string5, fieldType));
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(preparedStatement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.a(connection);
        }
        this.a(httpServletResponse, arrayList);
    }

    private void a(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuleException((Exception)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @URuleAuthorization(authType="group", code="manager", model="datasource")
    public void testConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("result", true);
        Connection connection = null;
        javax.sql.DataSource dataSource = null;
        DataSource dataSource2 = null;
        try {
            String string = httpServletRequest.getParameter("data");
            dataSource2 = (DataSource)this.a().readValue(string, DataSource.class);
            dataSource = DataSourceHandlerManager.newDataSource(dataSource2);
            connection = dataSource.getConnection();
            this.a(connection);
        }
        catch (Exception exception) {
            try {
                hashMap.put("error", exception.toString());
                hashMap.put("stack", this.a(exception));
                hashMap.put("result", false);
                this.a(connection);
            }
            catch (Throwable throwable) {
                this.a(connection);
                throw throwable;
            }
        }
        this.a(httpServletResponse, hashMap);
    }

    @Override
    public String url() {
        return "/datasource";
    }
}

