/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.studio;

import com.bstek.urule.Splash;
import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.ContextHolder;
import com.bstek.urule.console.database.model.RuleFile;
import com.bstek.urule.console.database.service.file.FileService;
import com.bstek.urule.console.security.AuthenticationManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.entity.User;
import com.bstek.urule.console.type.RoleCategory;
import com.bstek.urule.console.type.RuleFileType;
import com.bstek.urule.runtime.DynamicSpringConfigLoaderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StudioServletHandler
extends ApiServletHandler {
    public void menu(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Long l = ContextHolder.getProjectId();
        User user = SecurityUtils.getLoginUser(httpServletRequest);
        List<RuleFile> list = FileService.ins.menus(l);
        ArrayList<RuleFile> arrayList = new ArrayList<RuleFile>();
        for (RuleFile ruleFile : list) {
            RuleFileType ruleFileType = RuleFileType.getRuleFileType(ruleFile.getType());
            boolean bl = AuthenticationManager.decide(user, RoleCategory.project, ruleFileType.getModel(), "view");
            if (!bl) continue;
            arrayList.add(ruleFile);
        }
        this.a(httpServletResponse, arrayList);
    }

    public void tree(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean bl;
        Long l = ContextHolder.getProjectId();
        User user = SecurityUtils.getLoginUser(httpServletRequest);
        String string = httpServletRequest.getParameter("type");
        RuleFileType ruleFileType = RuleFileType.getRuleFileType(string);
        if (ruleFileType != null && (bl = AuthenticationManager.decide(user, RoleCategory.project, ruleFileType.getModel(), "view"))) {
            List<RuleFile> list = FileService.ins.tree(l, ruleFileType);
            this.a(httpServletResponse, list);
        }
    }

    public void validate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        hashMap.put("reg", Boolean.valueOf(DynamicSpringConfigLoaderImpl.isReg()));
        if (!DynamicSpringConfigLoaderImpl.isReg()) {
            hashMap.put("expired", Long.valueOf(Splash.getExpired()));
        }
        this.a(httpServletResponse, hashMap);
    }

    @Override
    public String url() {
        return "/studio";
    }
}

