/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.admin.user;

import com.bstek.urule.console.ApiServletHandler;
import com.bstek.urule.console.IllegalOperationException;
import com.bstek.urule.console.InfoException;
import com.bstek.urule.console.RequestHolder;
import com.bstek.urule.console.Transactional;
import com.bstek.urule.console.admin.RegisterInfo;
import com.bstek.urule.console.admin.log.SystemLogUtils;
import com.bstek.urule.console.anonymous.captcha.CaptchaBuilder;
import com.bstek.urule.console.config.Configure;
import com.bstek.urule.console.database.manager.group.GroupManager;
import com.bstek.urule.console.database.manager.invite.InviteManager;
import com.bstek.urule.console.database.model.Group;
import com.bstek.urule.console.database.model.Invite;
import com.bstek.urule.console.database.model.User;
import com.bstek.urule.console.database.service.group.GroupService;
import com.bstek.urule.console.database.service.user.PersistUserService;
import com.bstek.urule.console.database.service.user.UserServiceImpl;
import com.bstek.urule.console.database.service.user.UserServiceManager;
import com.bstek.urule.console.security.SecurityUtils;
import com.bstek.urule.console.security.URuleAuthAnonymous;
import com.bstek.urule.console.security.provider.SecurityProvider;
import com.bstek.urule.console.util.MailInfo;
import com.bstek.urule.console.util.MailUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserServletHandler
extends ApiServletHandler {
    private static final Log e = LogFactory.getLog(UserServletHandler.class);

    @Transactional
    @URuleAuthAnonymous
    public void register(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u52a8\u6001\u6ce8\u518c\u7528\u6237\uff01");
        }
        String string = CaptchaBuilder.ins.getCaptchResult(httpServletRequest);
        if (StringUtils.isBlank(string)) {
            throw new InfoException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5<br>Captcha is Expired");
        }
        RegisterInfo registerInfo = (RegisterInfo)this.a().readValue(httpServletRequest.getParameter("register"), RegisterInfo.class);
        String string2 = registerInfo.getCaptcha();
        if (StringUtils.isBlank(string2)) {
            throw new InfoException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a<br>Captcha can not be null");
        }
        if (!string2.contentEquals(string)) {
            throw new InfoException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e<br>Captcha is Invalid");
        }
        String string3 = registerInfo.getAccount();
        if (string3.length() < 3) {
            throw new InfoException("\u8d26\u53f7\u81f3\u5c113\u4e2a\u5b57\u7b26<br>Account must be at least three characters");
        }
        if (StringUtils.hasChineseChar(string3)) {
            throw new InfoException("\u8d26\u53f7\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u5b57\u7b26<br>The account cannot contain Chinese characters");
        }
        if (registerInfo.getPassword().length() < 8) {
            throw new InfoException("\u5bc6\u7801\u81f3\u5c118\u4e2a\u5b57\u7b26<br>Password must be at least three characters");
        }
        User user = ((UserServiceImpl)UserServiceManager.getUserService()).get(string3);
        if (null != user) {
            throw new InfoException("\u7528\u6237\u8d26\u53f7  " + string3 + "  \u5df2\u5b58\u5728<br>Account is already exist.");
        }
        user = new User();
        user.setId(registerInfo.getAccount());
        user.setEnable(true);
        user.setName(registerInfo.getUsername());
        user.setPassword(registerInfo.getPassword());
        user.setCreateUser(string3);
        ((UserServiceImpl)UserServiceManager.getUserService()).add(user);
        CaptchaBuilder.ins.cleanCaptch(httpServletRequest);
    }

    @URuleAuthAnonymous
    public void login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        String string2;
        String string3 = httpServletRequest.getParameter("key");
        Invite invite = null;
        if (StringUtils.isNotBlank(string3) && ((invite = InviteManager.ins.get(string3)) == null || System.currentTimeMillis() - invite.getExpirDate().getTime() > 1800000L)) {
            throw new InfoException("\u94fe\u63a5\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6\u94fe\u63a5!");
        }
        SecurityProvider securityProvider = SecurityUtils.getSecurityProvider();
        boolean bl = Configure.getConfigure().getBoolean("urule.login.useCaptcha", true);
        if (!SecurityUtils.isCustomProvider() && bl) {
            string2 = CaptchaBuilder.ins.getCaptchResult(httpServletRequest);
            if (StringUtils.isBlank(string2)) {
                throw new InfoException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5<br>Captcha is Expired");
            }
            string = httpServletRequest.getParameter("captcha");
            if (StringUtils.isBlank(string)) {
                throw new InfoException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a<br>Captcha can not be null");
            }
            if (!string.contentEquals(string2)) {
                throw new InfoException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e<br>Captcha is Invalid");
            }
        }
        string2 = httpServletRequest.getParameter("account");
        string = httpServletRequest.getParameter("password");
        try {
            HashMap<String, com.bstek.urule.console.security.entity.User> hashMap = new HashMap<String, com.bstek.urule.console.security.entity.User>();
            securityProvider.login(httpServletRequest, string2, string);
            if (StringUtils.isNotBlank(string3) && invite != null) {
                GroupService.ins.addGroupUser(invite.getGroupId(), string2);
                List<Group> list = GroupManager.ins.createQuery().list(SecurityUtils.getLoginUsername(httpServletRequest));
                com.bstek.urule.console.security.entity.User user = SecurityUtils.getLoginUser(httpServletRequest);
                user.setGroups(list);
            }
            SystemLogUtils.addLoginLog(RequestHolder.getRequest());
            hashMap.put("user", SecurityUtils.getLoginUser(httpServletRequest));
            e.debug((Object)("\u767b\u5f55\u6210\u529f,\u767b\u5f55\u7528\u6237:" + string2));
            CaptchaBuilder.ins.cleanCaptch(httpServletRequest);
            this.a(httpServletResponse, hashMap);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public void get(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        User user = UserServiceManager.getUserService().get(SecurityUtils.getLoginUsername(httpServletRequest));
        user.setPassword("******");
        this.a(httpServletResponse, user);
    }

    public void getUserInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, com.bstek.urule.console.security.entity.User> hashMap = new HashMap<String, com.bstek.urule.console.security.entity.User>();
        hashMap.put("user", SecurityUtils.getLoginUser(httpServletRequest));
        this.a(httpServletResponse, hashMap);
    }

    @URuleAuthAnonymous
    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SecurityUtils.getSecurityProvider().logout(httpServletRequest);
    }

    @URuleAuthAnonymous
    public void forgetPass(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u5bc6\u7801\u627e\u56de\uff01");
        }
        String string = httpServletRequest.getParameter("account");
        User user = ((UserServiceImpl)UserServiceManager.getUserService()).get(string);
        if (null == user) {
            throw new InfoException("Account not exist!");
        }
        if (StringUtils.isBlank(user.getEmail())) {
            throw new InfoException("Mail is not bound!");
        }
        try {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis() + 1800000L);
            if (user.getExpirDate() != null && timestamp.getTime() - user.getExpirDate().getTime() < 60000L) {
                throw new InfoException("Operation not supported!");
            }
            String string2 = RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10) + "" + RandomUtils.nextInt((int)10);
            user.setSecretKey(string2);
            user.setExpirDate(timestamp);
            user.setUpdateUser(string);
            ((UserServiceImpl)UserServiceManager.getUserService()).update(user);
            String string3 = "Retrieve Password";
            String string4 = "<b>\u4eb2\u7231\u7684\u7528\u6237:\u60a8\u597d!</b><br/><b>\u60a8\u6b63\u5728\u4fee\u6539\u5bc6\u7801\uff0c\u8bf7\u5728\u9a8c\u8bc1\u7801\u8f93\u5165\u6846\u4e2d\u8f93\u5165\uff1a " + string2 + "\uff0c\u4ee5\u5b8c\u6210\u64cd\u4f5c\u3002</b><br/>";
            string4 = string4 + "\u6ce8\u610f\uff1a\u6b64\u64cd\u4f5c\u53ef\u80fd\u4f1a\u4fee\u6539\u60a8\u7684\u5bc6\u7801\u3002\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u5e76\u4fee\u6539\u5bc6\u7801\u4ee5\u4fdd\u8bc1\u5e10\u6237\u5b89\u5168 \n\uff08\u5de5\u4f5c\u4eba\u5458\u4e0d\u4f1a\u5411\u4f60\u7d22\u53d6\u6b64\u9a8c\u8bc1\u7801\uff0c\u8bf7\u52ff\u6cc4\u6f0f\uff01)";
            string4 = string4 + "<hr/>";
            string4 = string4 + "\u6b64\u4e3a\u7cfb\u7edf\u90ae\u4ef6\uff0c\u8bf7\u52ff\u56de\u590d\n\u8bf7\u4fdd\u7ba1\u597d\u60a8\u7684\u90ae\u7bb1\uff0c\u907f\u514d\u8d26\u53f7\u88ab\u4ed6\u4eba\u76d7\u7528";
            MailInfo mailInfo = new MailInfo();
            mailInfo.setToAddress(user.getEmail());
            mailInfo.setSubject(string3);
            mailInfo.setContent(string4);
            try {
                MailUtils.sendHtmlMail(mailInfo);
            }
            catch (Exception exception) {
                throw new RuleException("'" + string3 + "' Mail sending failed\uff01", exception);
            }
        }
        catch (Exception exception) {
            throw new RuleException("Retrieve Password Error!", exception);
        }
    }

    @URuleAuthAnonymous
    public void resetPass(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u91cd\u7f6e\u5bc6\u7801\uff01");
        }
        String string = httpServletRequest.getParameter("verifyCode");
        String string2 = httpServletRequest.getParameter("account");
        String string3 = httpServletRequest.getParameter("password");
        HashMap hashMap = new HashMap();
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2) || StringUtils.isBlank(string3)) {
            throw new InfoException("\u91cd\u7f6e\u4fe1\u606f\u4e0d\u5b8c\u6574<br>Invalid info");
        }
        User user = ((UserServiceImpl)UserServiceManager.getUserService()).get(string2);
        if (user == null) {
            throw new InfoException("\u65e0\u6cd5\u627e\u5230\u5339\u914d\u7528\u6237<br>Invalid user");
        }
        if (string3.equals(user.getPassword()) || string3.length() < 6) {
            throw new InfoException("\u65e0\u6548\u5bc6\u7801<br>Invalid password");
        }
        Date date = user.getExpirDate();
        if (date == null || date.getTime() <= System.currentTimeMillis()) {
            throw new InfoException("\u9a8c\u8bc1\u7801\u5df2\u7ecf\u8fc7\u671f,\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801.<br>SecretKey is Expired");
        }
        user.setPassword(string3);
        user.setExpirDate(null);
        user.setSecretKey(null);
        user.setUpdateUser(string2);
        ((UserServiceImpl)UserServiceManager.getUserService()).update(user);
        e.debug((Object)("[" + string2 + "]\u5bc6\u7801\u4fee\u6539\u6210\u529f!"));
        this.a(httpServletResponse, hashMap);
    }

    public void changeName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u540d\u79f0\u4fee\u6539\uff01");
        }
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        String string2 = httpServletRequest.getParameter("name");
        User user = ((UserServiceImpl)UserServiceManager.getUserService()).get(string);
        user.setName(string2);
        com.bstek.urule.console.security.entity.User user2 = SecurityUtils.getLoginUser(httpServletRequest);
        user.setUpdateUser(user2.getName());
        ((UserServiceImpl)UserServiceManager.getUserService()).update(user);
        SecurityUtils.getSecurityProvider().login(httpServletRequest, user.getId(), user.getPassword());
    }

    public void changeEMail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u90ae\u7bb1\u4fee\u6539\uff01");
        }
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        String string2 = httpServletRequest.getParameter("email");
        User user = ((UserServiceImpl)UserServiceManager.getUserService()).get(string);
        user.setEmail(string2);
        com.bstek.urule.console.security.entity.User user2 = SecurityUtils.getLoginUser(httpServletRequest);
        user.setUpdateUser(user2.getName());
        ((UserServiceImpl)UserServiceManager.getUserService()).update(user);
    }

    public void changePwd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!(UserServiceManager.getUserService() instanceof PersistUserService)) {
            throw new IllegalOperationException("\u5f53\u524d\u7528\u6237\u670d\u52a1\u7c7b\u4e0d\u652f\u6301\u5bc6\u7801\u4fee\u6539\uff01");
        }
        String string = SecurityUtils.getLoginUsername(httpServletRequest);
        String string2 = httpServletRequest.getParameter("oldpwd");
        String string3 = httpServletRequest.getParameter("newpwd");
        User user = ((UserServiceImpl)UserServiceManager.getUserService()).get(string);
        if (!user.getPassword().equals(string2)) {
            throw new InfoException("\u5bc6\u7801\u9519\u8bef<br>Invalid password");
        }
        user.setPassword(string3);
        com.bstek.urule.console.security.entity.User user2 = SecurityUtils.getLoginUser(httpServletRequest);
        user.setUpdateUser(user2.getName());
        ((UserServiceImpl)UserServiceManager.getUserService()).update(user);
    }

    @Override
    public String url() {
        return "/user";
    }
}

