/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.anonymous.dynamic;

import com.bstek.urule.Utils;
import com.bstek.urule.console.anonymous.AnonymousServletHandler;
import com.bstek.urule.console.anonymous.ValidateUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketCacheImpl;
import com.bstek.urule.console.database.IDGenerator;
import com.bstek.urule.console.database.manager.jar.DynamicJarManager;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.console.util.StringUtils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.DynamicSpringConfigLoader;
import com.bstek.urule.runtime.RemoteDynamicJarsBuilder;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class DynamicServletHandler
extends AnonymousServletHandler {
    public static final String URL = "/dynamic";
    private RemoteDynamicJarsBuilder a = ServiceUtils.getRemoteDynamicJarsBuilder();
    private DynamicSpringConfigLoader e = ServiceUtils.getDynamicSpringConfigLoader();

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n;
        if (!ValidateUtils.validateUserPwd(httpServletRequest, this.a.getUser(), this.a.getPwd())) {
            return;
        }
        String string = httpServletRequest.getContextPath() + "/urule" + URL;
        String string2 = httpServletRequest.getRequestURI();
        String string3 = string2.substring(string.length());
        String string4 = string3.substring((n = string3.lastIndexOf("/")) + 1, string3.length());
        if (StringUtils.isNotBlank(string4)) {
            this.c(string4, httpServletRequest, httpServletResponse);
        } else {
            if (this.c(httpServletRequest)) {
                return;
            }
            String string5 = this.e.buildDynamicJarsStoreDirectPath();
            int n2 = DynamicJarManager.ins.createJarFiles(string5);
            if (n2 == 0) {
                return;
            }
            this.e.loadDynamicJars(string5);
        }
    }

    public void recacheAllPackets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.c(httpServletRequest)) {
            this.a(httpServletResponse, "ok");
            return;
        }
        ((PacketCacheImpl)PacketCache.ins).doRecacheAllPackets();
        IDGenerator.getInstance().clean();
        this.a(httpServletResponse, "ok");
    }

    public void syncPacket(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.c(httpServletRequest)) {
            this.a(httpServletResponse, "ok");
            return;
        }
        long l = Long.valueOf(httpServletRequest.getParameter("id"));
        ((PacketCacheImpl)PacketCache.ins).doReloadPacket(l);
        this.a(httpServletResponse, "ok");
    }

    public void syncPacketForRemoveProject(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.c(httpServletRequest)) {
            this.a(httpServletResponse, "ok");
            return;
        }
        long l = Long.valueOf(httpServletRequest.getParameter("projectId"));
        ((PacketCacheImpl)PacketCache.ins).doRemoveProjectPackets(l);
        this.a(httpServletResponse, "ok");
    }

    public void checkLatestJarsDir(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = "n";
        String string2 = this.e.getDynamicJarsIdDigest();
        if (string2 != null) {
            string = string2;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = httpServletRequest.getParameter("digest");
        hashMap.put("digest", string);
        String string4 = this.e.getDynamicJarsStoreDirectPath();
        if (StringUtils.isBlank(string4)) {
            hashMap.put("match", true);
        } else if (string3 == null) {
            hashMap.put("match", false);
        } else {
            hashMap.put("match", string3.equals(string));
        }
        this.a(httpServletResponse, hashMap);
    }

    public void loadDynamicJars(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.e.getDynamicJarsStoreDirectPath();
        if (string == null) {
            throw new RuleException("Current jars dir not exist.");
        }
        byte[] byArray = this.e.zipDynamicJars();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)servletOutputStream);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        dataOutputStream.close();
        IOUtils.closeQuietly((OutputStream)servletOutputStream);
    }

    private void a(HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    private boolean c(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        String string = httpServletRequest.getParameter("systemId");
        return string != null && (string = URLDecoder.decode(string, "utf-8")).contentEquals(Utils.SystemId);
    }

    @Override
    public String url() {
        return URL;
    }
}

