/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.anonymous.knowledge;

import com.bstek.urule.Configure;
import com.bstek.urule.Utils;
import com.bstek.urule.console.anonymous.AnonymousServletHandler;
import com.bstek.urule.console.anonymous.ValidateUtils;
import com.bstek.urule.console.cache.packet.PacketCache;
import com.bstek.urule.console.cache.packet.PacketData;
import com.bstek.urule.console.util.ServiceUtils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.RemoteDynamicJarsBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class LoadKnowledgeServletHandler
extends AnonymousServletHandler {
    public static final String URL = "/loadknowledge";
    private RemoteDynamicJarsBuilder a = ServiceUtils.getRemoteDynamicJarsBuilder();

    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!ValidateUtils.validateUserPwd(httpServletRequest, this.a.getUser(), this.a.getPwd())) {
            return;
        }
        String string = httpServletRequest.getParameter("packageId");
        if (StringUtils.isEmpty((String)string)) {
            String string2 = "<h1>PackageId can not be null<h1>";
            this.a(httpServletResponse, string2);
            return;
        }
        string = Utils.decodeURL((String)string);
        String string3 = httpServletRequest.getParameter("timestamp");
        PacketData packetData = PacketCache.ins.getPacket(string);
        if (packetData == null) {
            long l = 0L;
            try {
                l = Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuleException("Package [" + string + "] not exist");
            }
            packetData = PacketCache.ins.getPacket(l);
        }
        if (packetData == null) {
            throw new RuleException("Package [" + string + "] not exist");
        }
        KnowledgePackageWrapper knowledgePackageWrapper = packetData.getKnowledgePackageWrapper();
        KnowledgePackage knowledgePackage = knowledgePackageWrapper.getKnowledgePackage();
        boolean bl = false;
        String string4 = httpServletRequest.getParameter("debug");
        if (string4 != null && string4.equals("true") && Utils.isDebug()) {
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)string3)) {
            long l = Long.valueOf(string3);
            long l2 = knowledgePackage.getTimestamp();
            if (l2 > l) {
                if (bl) {
                    this.a(httpServletResponse, knowledgePackageWrapper);
                } else {
                    this.a(httpServletResponse, packetData);
                }
            }
        } else if (bl) {
            this.a(httpServletResponse, knowledgePackageWrapper);
        } else {
            this.a(httpServletResponse, packetData);
        }
    }

    private void a(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write("<html>");
        printWriter.write("<header>");
        printWriter.write("</header>");
        printWriter.write("<body>");
        printWriter.write(string);
        printWriter.write("</body>");
        printWriter.write("</html>");
        printWriter.flush();
        printWriter.close();
    }

    private void a(HttpServletResponse httpServletResponse, PacketData packetData) throws IOException {
        JsonMapper.Builder builder;
        httpServletResponse.setContentType("text/json");
        httpServletResponse.setCharacterEncoding("UTF-8");
        byte[] byArray = PacketCache.ins.getKnowledgeContent(packetData.getPacket().getId());
        if (byArray == null) {
            builder = JsonMapper.builder();
            builder.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            ObjectMapper objectMapper = builder.build();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(Configure.getDateFormat()));
            String string = objectMapper.writeValueAsString((Object)packetData.getKnowledgePackageWrapper());
            byArray = Utils.compress((String)string);
        }
        builder = httpServletResponse.getOutputStream();
        builder.write(byArray);
        builder.flush();
        builder.close();
    }

    @Override
    public String url() {
        return URL;
    }
}

