/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.console.anonymous.res;

import com.bstek.urule.console.anonymous.AnonymousServletHandler;
import com.bstek.urule.exception.RuleException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class ResourceLoaderServletHandler
extends AnonymousServletHandler {
    public static final String RES_PREFIX = "/res";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getContextPath() + "/urule" + RES_PREFIX;
        String string2 = httpServletRequest.getRequestURI();
        String string3 = string2.substring(string.length() + 1);
        if (string3.endsWith(".js")) {
            httpServletResponse.setContentType("text/javascript");
        } else if (string3.endsWith(".css")) {
            httpServletResponse.setContentType("text/css");
        } else if (string3.endsWith(".png")) {
            httpServletResponse.setContentType("image/png");
        } else if (string3.endsWith(".jpg")) {
            httpServletResponse.setContentType("image/jpeg");
        } else if (string3.endsWith(".svg")) {
            httpServletResponse.setContentType("image/svg+xml");
        } else {
            httpServletResponse.setContentType("application/octet-stream");
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string3);
        if (inputStream == null) {
            throw new RuleException("Resource\u3010" + string3 + "\u3011not exist\uff01");
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)servletOutputStream);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public String url() {
        return RES_PREFIX;
    }
}

